/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.IMixinBlockRendererDispatcher;
import fi.dy.masa.litematica.mixin.IMixinViewFrustum;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderContainerSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.CompiledChunkSchematic;
import fi.dy.masa.litematica.render.schematic.RenderChunkFactoryList;
import fi.dy.masa.litematica.render.schematic.RenderChunkFactoryVbo;
import fi.dy.masa.litematica.render.schematic.RenderChunkSchematicVbo;
import fi.dy.masa.litematica.render.schematic.RenderListSchematic;
import fi.dy.masa.litematica.render.schematic.VboRenderListSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.IRenderChunkFactory;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class RenderGlobalSchematic
extends RenderGlobal {
    private final Minecraft mc;
    private final RenderManager renderManager;
    private final BlockModelShapes blockModelShapes;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final BlockFluidRenderer fluidRenderer;
    private final Set<TileEntity> setTileEntities = new HashSet<TileEntity>();
    private final List<RenderChunkSchematicVbo> renderInfos = new ArrayList<RenderChunkSchematicVbo>(1024);
    private Set<RenderChunkSchematicVbo> chunksToUpdate = new LinkedHashSet<RenderChunkSchematicVbo>();
    private WorldClient world;
    private ViewFrustum viewFrustum;
    private double frustumUpdatePosX = Double.MIN_VALUE;
    private double frustumUpdatePosY = Double.MIN_VALUE;
    private double frustumUpdatePosZ = Double.MIN_VALUE;
    private int frustumUpdatePosChunkX = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkY = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkZ = Integer.MIN_VALUE;
    private double lastViewEntityX = Double.MIN_VALUE;
    private double lastViewEntityY = Double.MIN_VALUE;
    private double lastViewEntityZ = Double.MIN_VALUE;
    private float lastViewEntityPitch = Float.MIN_VALUE;
    private float lastViewEntityYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private ChunkRenderContainerSchematic renderContainer;
    private IRenderChunkFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private boolean vboEnabled;
    private double prevRenderSortX;
    private double prevRenderSortY;
    private double prevRenderSortZ;
    private boolean displayListEntitiesDirty = true;

    public RenderGlobalSchematic(Minecraft mc) {
        super(mc);
        this.mc = mc;
        this.renderManager = mc.func_175598_ae();
        this.vboEnabled = OpenGlHelper.func_176075_f();
        if (this.vboEnabled) {
            this.renderContainer = new VboRenderListSchematic();
            this.renderChunkFactory = new RenderChunkFactoryVbo();
        } else {
            this.renderContainer = new RenderListSchematic();
            this.renderChunkFactory = new RenderChunkFactoryList();
        }
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        this.blockModelShapes = dispatcher.func_175023_a();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.func_184125_al());
        this.fluidRenderer = ((IMixinBlockRendererDispatcher)dispatcher).getFluidRenderer();
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public String func_72735_c() {
        int rcTotal = this.viewFrustum != null ? this.viewFrustum.field_178164_f.length : 0;
        int rcRendered = this.viewFrustum != null ? this.func_184382_g() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.field_175612_E ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String func_72723_d() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int func_184382_g() {
        int count = 0;
        for (RenderChunk renderChunk : this.renderInfos) {
            CompiledChunk compiledchunk = renderChunk.field_178590_b;
            if (compiledchunk == CompiledChunk.field_178502_a || compiledchunk.func_178489_a()) continue;
            ++count;
        }
        return count;
    }

    public void func_72732_a(@Nullable WorldClient worldClientIn) {
        if (this.world != null) {
            this.world.func_72848_b((IWorldEventListener)this);
        }
        this.frustumUpdatePosX = Double.MIN_VALUE;
        this.frustumUpdatePosY = Double.MIN_VALUE;
        this.frustumUpdatePosZ = Double.MIN_VALUE;
        this.frustumUpdatePosChunkX = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkY = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkZ = Integer.MIN_VALUE;
        this.world = worldClientIn;
        if (worldClientIn != null) {
            worldClientIn.func_72954_a((IWorldEventListener)this);
            this.func_72712_a();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.viewFrustum != null) {
                this.viewFrustum.func_178160_a();
                this.viewFrustum = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_72712_a() {
        WorldClient world = this.world;
        if (world != null) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = this.mc.field_71474_y.field_151451_c;
            boolean vboEnabledPrevious = this.vboEnabled;
            this.vboEnabled = OpenGlHelper.func_176075_f();
            if (!this.vboEnabled && vboEnabledPrevious) {
                this.renderContainer = new RenderListSchematic();
                this.renderChunkFactory = new RenderChunkFactoryList();
            } else if (this.vboEnabled && !vboEnabledPrevious) {
                this.renderContainer = new VboRenderListSchematic();
                this.renderChunkFactory = new RenderChunkFactoryVbo();
            }
            if (this.viewFrustum != null) {
                this.viewFrustum.func_178160_a();
            }
            this.func_174986_e();
            Set<TileEntity> set = this.setTileEntities;
            synchronized (set) {
                this.setTileEntities.clear();
            }
            this.viewFrustum = new ViewFrustum((World)world, this.mc.field_71474_y.field_151451_c, (RenderGlobal)this, this.renderChunkFactory);
            Entity entity = this.mc.func_175606_aa();
            if (entity != null) {
                this.viewFrustum.func_178163_a(entity.field_70165_t, entity.field_70161_v);
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void func_174986_e() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void func_174970_a(Entity viewEntity, double partialTicks, ICamera camera, int frameCount, boolean playerSpectator) {
        Set<RenderChunkSchematicVbo> set;
        WorldClient world = this.world;
        world.field_72984_F.func_76320_a("setup_terrain");
        if (this.viewFrustum == null || this.mc.field_71474_y.field_151451_c != this.renderDistanceChunks) {
            this.func_72712_a();
        }
        world.field_72984_F.func_76320_a("camera");
        double diffX = viewEntity.field_70165_t - this.frustumUpdatePosX;
        double diffY = viewEntity.field_70163_u - this.frustumUpdatePosY;
        double diffZ = viewEntity.field_70161_v - this.frustumUpdatePosZ;
        if (this.frustumUpdatePosChunkX != viewEntity.field_70176_ah || this.frustumUpdatePosChunkY != viewEntity.field_70162_ai || this.frustumUpdatePosChunkZ != viewEntity.field_70164_aj || diffX * diffX + diffY * diffY + diffZ * diffZ > 16.0) {
            this.frustumUpdatePosX = viewEntity.field_70165_t;
            this.frustumUpdatePosY = viewEntity.field_70163_u;
            this.frustumUpdatePosZ = viewEntity.field_70161_v;
            this.frustumUpdatePosChunkX = viewEntity.field_70176_ah;
            this.frustumUpdatePosChunkY = viewEntity.field_70162_ai;
            this.frustumUpdatePosChunkZ = viewEntity.field_70164_aj;
            this.viewFrustum.func_178163_a(viewEntity.field_70165_t, viewEntity.field_70161_v);
        }
        world.field_72984_F.func_76318_c("renderlist_camera");
        double x = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTicks;
        double y = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTicks;
        double z = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTicks;
        this.renderContainer.func_178004_a(x, y, z);
        world.field_72984_F.func_76318_c("culling");
        BlockPos viewPos = new BlockPos(x, y + (double)viewEntity.func_70047_e(), z);
        int centerChunkX = viewPos.func_177958_n() >> 4;
        int centerChunkZ = viewPos.func_177952_p() >> 4;
        int renderDistance = this.mc.field_71474_y.field_151451_c;
        SubChunkPos viewSubChunk = new SubChunkPos(centerChunkX, viewPos.func_177956_o() >> 4, centerChunkZ);
        BlockPos viewPosSubChunk = new BlockPos(viewSubChunk.func_177958_n() << 4, viewSubChunk.func_177956_o() << 4, viewSubChunk.func_177952_p() << 4);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || viewEntity.field_70165_t != this.lastViewEntityX || viewEntity.field_70163_u != this.lastViewEntityY || viewEntity.field_70161_v != this.lastViewEntityZ || viewEntity.field_70125_A != this.lastViewEntityPitch || viewEntity.field_70177_z != this.lastViewEntityYaw;
        this.lastViewEntityX = viewEntity.field_70165_t;
        this.lastViewEntityY = viewEntity.field_70163_u;
        this.lastViewEntityZ = viewEntity.field_70161_v;
        this.lastViewEntityPitch = viewEntity.field_70125_A;
        this.lastViewEntityYaw = viewEntity.field_70177_z;
        world.field_72984_F.func_76318_c("update");
        if (this.displayListEntitiesDirty) {
            world.field_72984_F.func_76320_a("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            Entity.func_184227_b((double)MathHelper.func_151237_a((double)((double)renderDistance / 8.0), (double)1.0, (double)2.5));
            set = DataManager.getSchematicPlacementManager().getAllTouchedSubChunks();
            ArrayList<RenderChunkSchematicVbo> positions = new ArrayList<RenderChunkSchematicVbo>(set.size());
            positions.addAll(set);
            Collections.sort(positions, new SubChunkPos.DistanceComparator(viewSubChunk));
            world.field_72984_F.func_76318_c("iteration");
            for (int i = 0; i < positions.size(); ++i) {
                BlockPos subChunkCornerPos;
                RenderChunkSchematicVbo renderChunk;
                SubChunkPos subChunk = (SubChunkPos)positions.get(i);
                if (Math.abs(subChunk.func_177958_n() - centerChunkX) > renderDistance || Math.abs(subChunk.func_177952_p() - centerChunkZ) > renderDistance || !world.func_72863_F().func_191062_e(subChunk.func_177958_n(), subChunk.func_177952_p()) || (renderChunk = (RenderChunkSchematicVbo)((IMixinViewFrustum)this.viewFrustum).invokeGetRenderChunk(subChunkCornerPos = new BlockPos(subChunk.func_177958_n() << 4, subChunk.func_177956_o() << 4, subChunk.func_177952_p() << 4))) == null || !renderChunk.func_178577_a(frameCount) || !camera.func_78546_a(renderChunk.field_178591_c)) continue;
                if (renderChunk.func_178569_m() && subChunkCornerPos.equals((Object)viewPosSubChunk)) {
                    renderChunk.func_178575_a(true);
                }
                this.renderInfos.add(renderChunk);
            }
            world.field_72984_F.func_76319_b();
        }
        world.field_72984_F.func_76318_c("rebuild_near");
        set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<RenderChunkSchematicVbo>();
        for (RenderChunkSchematicVbo renderChunkTmp : this.renderInfos) {
            boolean isNear;
            if (!renderChunkTmp.func_178569_m() && !set.contains((Object)renderChunkTmp)) continue;
            this.displayListEntitiesDirty = true;
            BlockPos pos = renderChunkTmp.func_178568_j().func_177982_a(8, 8, 8);
            boolean bl = isNear = pos.func_177951_i((Vec3i)viewPos) < 1024.0;
            if (!renderChunkTmp.func_188281_o() && !isNear) {
                this.chunksToUpdate.add(renderChunkTmp);
                continue;
            }
            world.field_72984_F.func_76320_a("build_near");
            this.renderDispatcher.updateChunkNow(renderChunkTmp);
            renderChunkTmp.func_188282_m();
            world.field_72984_F.func_76319_b();
        }
        this.chunksToUpdate.addAll(set);
        world.field_72984_F.func_76319_b();
        world.field_72984_F.func_76319_b();
    }

    public void func_174967_a(long finishTimeNano) {
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        if (!this.chunksToUpdate.isEmpty()) {
            RenderChunkSchematicVbo renderChunk;
            boolean flag;
            Iterator<RenderChunkSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext() && (flag = (renderChunk = iterator.next()).func_188281_o() ? this.renderDispatcher.updateChunkNow(renderChunk) : this.renderDispatcher.updateChunkLater(renderChunk))) {
                renderChunk.func_188282_m();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public int renderBlockLayer(BlockRenderLayer blockLayerIn, double partialTicks, Entity entityIn) {
        this.world.field_72984_F.func_76320_a("render_block_layer_" + blockLayerIn);
        RenderUtils.disableItemLighting();
        if (blockLayerIn == BlockRenderLayer.TRANSLUCENT) {
            this.world.field_72984_F.func_76320_a("translucent_sort");
            double diffX = entityIn.field_70165_t - this.prevRenderSortX;
            double diffY = entityIn.field_70163_u - this.prevRenderSortY;
            double diffZ = entityIn.field_70161_v - this.prevRenderSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.prevRenderSortX = entityIn.field_70165_t;
                this.prevRenderSortY = entityIn.field_70163_u;
                this.prevRenderSortZ = entityIn.field_70161_v;
                int i = 0;
                for (RenderChunkSchematicVbo renderChunk : this.renderInfos) {
                    if (!renderChunk.func_178571_g().func_178492_d(blockLayerIn) && (renderChunk.func_178571_g() == CompiledChunk.field_178502_a || !renderChunk.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(renderChunk);
                }
            }
            this.world.field_72984_F.func_76319_b();
        }
        this.world.field_72984_F.func_76320_a("filter_empty");
        boolean reverse = blockLayerIn == BlockRenderLayer.TRANSLUCENT;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        for (int i = startIndex; i != stopIndex; i += increment) {
            RenderChunk renderchunk = this.renderInfos.get(i);
            if (renderchunk.func_178571_g().func_178491_b(blockLayerIn)) continue;
            ++count;
            this.renderContainer.func_178002_a(renderchunk, blockLayerIn);
        }
        this.world.field_72984_F.func_76318_c("render");
        this.renderBlockLayer(blockLayerIn);
        this.world.field_72984_F.func_76319_b();
        this.world.field_72984_F.func_76319_b();
        return count;
    }

    private void renderBlockLayer(BlockRenderLayer layer) {
        this.mc.field_71460_t.func_180436_i();
        if (OpenGlHelper.func_176075_f()) {
            GlStateManager.func_187410_q((int)32884);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_187410_q((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_187410_q((int)32888);
            OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_187410_q((int)32886);
        }
        this.renderContainer.func_178001_a(layer);
        if (OpenGlHelper.func_176075_f()) {
            for (VertexFormatElement vertexformatelement : DefaultVertexFormats.field_176600_a.func_177343_g()) {
                VertexFormatElement.EnumUsage vertexformatelement$enumusage = vertexformatelement.func_177375_c();
                int index = vertexformatelement.func_177369_e();
                switch (vertexformatelement$enumusage) {
                    case POSITION: {
                        GlStateManager.func_187429_p((int)32884);
                        break;
                    }
                    case UV: {
                        OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + index));
                        GlStateManager.func_187429_p((int)32888);
                        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.func_187429_p((int)32886);
                        GlStateManager.func_179117_G();
                    }
                }
            }
        }
        this.mc.field_71460_t.func_175072_h();
    }

    public void renderBlockOverlays() {
        this.renderBlockOverlay(RenderChunkSchematicVbo.OverlayRenderType.OUTLINE);
        this.renderBlockOverlay(RenderChunkSchematicVbo.OverlayRenderType.QUAD);
    }

    private void renderBlockOverlay(RenderChunkSchematicVbo.OverlayRenderType type) {
        this.world.field_72984_F.func_76320_a("overlay_" + type.name());
        this.world.field_72984_F.func_76320_a("filter_empty");
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            CompiledChunkSchematic compiledChunk;
            RenderChunkSchematicVbo renderChunk = this.renderInfos.get(i);
            if (renderChunk.func_178571_g() == CompiledChunk.field_178502_a || !renderChunk.hasOverlay() || (compiledChunk = (CompiledChunkSchematic)renderChunk.func_178571_g()).isOverlayTypeEmpty(type)) continue;
            this.renderContainer.addOverlayChunk(renderChunk);
        }
        this.world.field_72984_F.func_76318_c("render");
        this.renderBlockOverlayBuffers(type);
        this.world.field_72984_F.func_76319_b();
        this.world.field_72984_F.func_76319_b();
    }

    private void renderBlockOverlayBuffers(RenderChunkSchematicVbo.OverlayRenderType type) {
        this.mc.field_71460_t.func_180436_i();
        if (OpenGlHelper.func_176075_f()) {
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187410_q((int)32886);
        }
        this.renderContainer.renderBlockOverlays(type);
        if (OpenGlHelper.func_176075_f()) {
            for (VertexFormatElement element : DefaultVertexFormats.field_181706_f.func_177343_g()) {
                VertexFormatElement.EnumUsage usage = element.func_177375_c();
                switch (usage) {
                    case POSITION: {
                        GlStateManager.func_187429_p((int)32884);
                        break;
                    }
                    case UV: {
                        OpenGlHelper.func_77472_b((int)(OpenGlHelper.field_77478_a + element.func_177369_e()));
                        GlStateManager.func_187429_p((int)32888);
                        OpenGlHelper.func_77472_b((int)OpenGlHelper.field_77478_a);
                        break;
                    }
                    case COLOR: {
                        GlStateManager.func_187429_p((int)32886);
                        GlStateManager.func_179117_G();
                    }
                }
            }
        }
        this.mc.field_71460_t.func_175072_h();
    }

    public boolean renderBlock(IBlockState state, BlockPos pos, IBlockAccess blockAccess, BufferBuilder bufferBuilderIn) {
        try {
            EnumBlockRenderType renderType = state.func_185901_i();
            if (renderType == EnumBlockRenderType.INVISIBLE) {
                return false;
            }
            switch (renderType) {
                case MODEL: {
                    return this.blockModelRenderer.renderModel(blockAccess, this.getModelForState(state), state, pos, bufferBuilderIn);
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
                case LIQUID: {
                    return this.fluidRenderer.func_178270_a(blockAccess, state, pos, bufferBuilderIn);
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_180523_a((CrashReportCategory)crashreportcategory, (BlockPos)pos, (Block)state.func_177230_c(), (int)state.func_177230_c().func_176201_c(state));
            throw new ReportedException(crashreport);
        }
    }

    public IBakedModel getModelForState(IBlockState state) {
        return this.blockModelShapes.func_178125_b(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_180446_a(Entity renderViewEntity, ICamera camera, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            double renderX = renderViewEntity.field_70169_q + (renderViewEntity.field_70165_t - renderViewEntity.field_70169_q) * (double)partialTicks;
            double renderY = renderViewEntity.field_70167_r + (renderViewEntity.field_70163_u - renderViewEntity.field_70167_r) * (double)partialTicks;
            double renderZ = renderViewEntity.field_70166_s + (renderViewEntity.field_70161_v - renderViewEntity.field_70166_s) * (double)partialTicks;
            this.world.field_72984_F.func_76320_a("prepare");
            TileEntityRendererDispatcher.field_147556_a.func_190056_a((World)this.world, this.mc.func_110434_K(), this.mc.field_71466_p, this.mc.func_175606_aa(), this.mc.field_71476_x, partialTicks);
            this.renderManager.func_180597_a((World)this.world, this.mc.field_71466_p, this.mc.func_175606_aa(), this.mc.field_147125_j, this.mc.field_71474_y, partialTicks);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            Entity entity = this.mc.func_175606_aa();
            double entityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double entityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double entityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            TileEntityRendererDispatcher.field_147554_b = entityX;
            TileEntityRendererDispatcher.field_147555_c = entityY;
            TileEntityRendererDispatcher.field_147552_d = entityZ;
            this.renderManager.func_178628_a(entityX, entityY, entityZ);
            this.mc.field_71460_t.func_180436_i();
            this.countEntitiesTotal = this.world.func_72910_y().size();
            this.world.field_72984_F.func_76318_c("regular_entities");
            ArrayList entitiesOutlined = Lists.newArrayList();
            ArrayList entitiesMultipass = Lists.newArrayList();
            BlockPos.PooledMutableBlockPos posMutable = BlockPos.PooledMutableBlockPos.func_185346_s();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (RenderChunk renderChunk : this.renderInfos) {
                Chunk chunk = this.world.func_175726_f(renderChunk.func_178568_j());
                ClassInheritanceMultiMap classinheritancemultimap = chunk.func_177429_s()[renderChunk.func_178568_j().func_177956_o() / 16];
                if (classinheritancemultimap.isEmpty()) continue;
                for (Entity entityTmp : classinheritancemultimap) {
                    boolean sleeping;
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.field_70165_t, (int)entityTmp.field_70163_u, (int)entityTmp.field_70161_v) || !(shouldRender = this.renderManager.func_178635_a(entityTmp, camera, renderX, renderY, renderZ) || entityTmp.func_184215_y((Entity)this.mc.field_71439_g))) continue;
                    boolean bl = sleeping = this.mc.func_175606_aa() instanceof EntityLivingBase ? ((EntityLivingBase)this.mc.func_175606_aa()).func_70608_bn() : false;
                    if (entityTmp == this.mc.func_175606_aa() && this.mc.field_71474_y.field_74320_O == 0 && !sleeping || !(entityTmp.field_70163_u < 0.0) && !(entityTmp.field_70163_u >= 256.0) && !this.world.func_175667_e((BlockPos)posMutable.func_189535_a(entityTmp))) continue;
                    ++this.countEntitiesRendered;
                    this.renderManager.func_188388_a(entityTmp, 0.0f, false);
                    if (this.isOutlineActive(entityTmp, entity, camera)) {
                        entitiesOutlined.add(entityTmp);
                    }
                    if (!this.renderManager.func_188390_b(entityTmp)) continue;
                    entitiesMultipass.add(entityTmp);
                }
            }
            posMutable.func_185344_t();
            if (!entitiesMultipass.isEmpty()) {
                for (Entity entity2 : entitiesMultipass) {
                    this.renderManager.func_188389_a(entity2, partialTicks);
                }
            }
            this.world.field_72984_F.func_76318_c("block_entities");
            RenderUtils.enableItemLighting();
            for (RenderChunk renderChunk : this.renderInfos) {
                List tiles = renderChunk.func_178571_g().func_178485_b();
                if (tiles.isEmpty()) continue;
                for (TileEntity te : tiles) {
                    TileEntityRendererDispatcher.field_147556_a.func_180546_a(te, partialTicks, -1);
                }
            }
            Set<TileEntity> set = this.setTileEntities;
            synchronized (set) {
                for (TileEntity te : this.setTileEntities) {
                    TileEntityRendererDispatcher.field_147556_a.func_180546_a(te, partialTicks, -1);
                }
            }
            this.mc.field_71460_t.func_175072_h();
            this.world.field_72984_F.func_76319_b();
        }
    }

    private boolean isOutlineActive(Entity entityIn, Entity viewer, ICamera camera) {
        boolean sleeping;
        boolean bl = sleeping = viewer instanceof EntityLivingBase && ((EntityLivingBase)viewer).func_70608_bn();
        if (entityIn == viewer && this.mc.field_71474_y.field_74320_O == 0 && !sleeping) {
            return false;
        }
        if (entityIn.func_184202_aL()) {
            return true;
        }
        if (this.mc.field_71439_g.func_175149_v() && this.mc.field_71474_y.field_178883_an.func_151470_d() && entityIn instanceof EntityPlayer) {
            return entityIn.field_70158_ak || camera.func_78546_a(entityIn.func_174813_aQ()) || entityIn.func_184215_y((Entity)this.mc.field_71439_g);
        }
        return false;
    }

    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.markBlocksForUpdate(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, (flags & 8) != 0);
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.markBlocksForUpdate(x1 - 1, y1 - 1, z1 - 1, x2 + 1, y2 + 1, z2 + 1, false);
    }

    private void markBlocksForUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately) {
        if (this.viewFrustum != null) {
            this.viewFrustum.func_187474_a(minX, minY, minZ, maxX, maxY, maxZ, updateImmediately);
        }
    }

    public void func_174959_b(BlockPos pos) {
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_190570_a(int id, boolean ignoreRange, boolean p_190570_3_, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
    }

    public void func_72703_a(Entity entityIn) {
    }

    public void func_72709_b(Entity entityIn) {
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
    }
}

