/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCompileTaskGeneratorSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.CompiledChunkSchematic;
import fi.dy.masa.litematica.render.schematic.RenderChunkSchematicVbo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorkerLitematica
implements Runnable {
    private static final Logger LOGGER = Litematica.logger;
    private final ChunkRenderDispatcherLitematica chunkRenderDispatcher;
    @Nullable
    private final BufferBuilderCache bufferCache;
    private boolean shouldRun = true;

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn) {
        this(chunkRenderDispatcherIn, null);
    }

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn, @Nullable BufferBuilderCache bufferCache) {
        this.chunkRenderDispatcher = chunkRenderDispatcherIn;
        this.bufferCache = bufferCache;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                this.processTask(this.chunkRenderDispatcher.getNextChunkUpdate());
            }
            catch (InterruptedException e) {
                LOGGER.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Batching chunks");
                Minecraft.func_71410_x().func_71404_a(Minecraft.func_71410_x().func_71396_d(crashreport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTask(final ChunkCompileTaskGeneratorSchematic generator) throws InterruptedException {
        generator.getLock().lock();
        try {
            if (generator.getStatus() != ChunkCompileTaskGeneratorSchematic.Status.PENDING) {
                if (!generator.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be pending; ignoring task", (Object)generator.getStatus());
                }
                return;
            }
            generator.setStatus(ChunkCompileTaskGeneratorSchematic.Status.COMPILING);
        }
        finally {
            generator.getLock().unlock();
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null) {
            generator.finish();
        } else {
            generator.setRegionRenderCacheBuilder(this.getRegionRenderCacheBuilder());
            ChunkCompileTaskGeneratorSchematic.Type generatorType = generator.getType();
            float x = (float)entity.field_70165_t;
            float y = (float)entity.field_70163_u + entity.func_70047_e();
            float z = (float)entity.field_70161_v;
            if (generatorType == ChunkCompileTaskGeneratorSchematic.Type.REBUILD_CHUNK) {
                generator.getRenderChunk().rebuildChunk(x, y, z, generator);
            } else if (generatorType == ChunkCompileTaskGeneratorSchematic.Type.RESORT_TRANSPARENCY) {
                generator.getRenderChunk().resortTransparency(x, y, z, generator);
            }
            generator.getLock().lock();
            try {
                if (generator.getStatus() != ChunkCompileTaskGeneratorSchematic.Status.COMPILING) {
                    if (!generator.isFinished()) {
                        LOGGER.warn("Chunk render task was {} when I expected it to be compiling; aborting task", (Object)generator.getStatus());
                    }
                    this.freeRenderBuilder(generator);
                    return;
                }
                generator.setStatus(ChunkCompileTaskGeneratorSchematic.Status.UPLOADING);
            }
            finally {
                generator.getLock().unlock();
            }
            final CompiledChunkSchematic compiledChunk = (CompiledChunkSchematic)generator.getCompiledChunk();
            ArrayList futuresList = Lists.newArrayList();
            BufferBuilderCache buffers = generator.getBufferCache();
            RenderChunkSchematicVbo renderChunk = generator.getRenderChunk();
            if (generatorType == ChunkCompileTaskGeneratorSchematic.Type.REBUILD_CHUNK) {
                BufferBuilder buffer;
                for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                    if (compiledChunk.func_178491_b(blockRenderLayer)) continue;
                    buffer = buffers.getWorldRendererByLayer(blockRenderLayer);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(blockRenderLayer, buffer, renderChunk, compiledChunk, generator.getDistanceSq()));
                }
                for (RenderChunkSchematicVbo.OverlayRenderType overlayRenderType : RenderChunkSchematicVbo.OverlayRenderType.values()) {
                    if (compiledChunk.isOverlayTypeEmpty(overlayRenderType)) continue;
                    buffer = buffers.getOverlayBuffer(overlayRenderType);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(overlayRenderType, buffer, renderChunk, compiledChunk, generator.getDistanceSq()));
                }
            } else if (generatorType == ChunkCompileTaskGeneratorSchematic.Type.RESORT_TRANSPARENCY) {
                BufferBuilder bufferBuilder = buffers.getWorldRendererByLayer(BlockRenderLayer.TRANSLUCENT);
                futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(BlockRenderLayer.TRANSLUCENT, bufferBuilder, renderChunk, compiledChunk, generator.getDistanceSq()));
                if (!compiledChunk.isOverlayTypeEmpty(RenderChunkSchematicVbo.OverlayRenderType.QUAD)) {
                    BufferBuilder bufferBuilder2 = buffers.getOverlayBuffer(RenderChunkSchematicVbo.OverlayRenderType.QUAD);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(RenderChunkSchematicVbo.OverlayRenderType.QUAD, bufferBuilder2, renderChunk, compiledChunk, generator.getDistanceSq()));
                }
            }
            final ListenableFuture listenableFuture = Futures.allAsList((Iterable)futuresList);
            generator.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    listenableFuture.cancel(false);
                }
            });
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<List<Object>>(){

                public void onSuccess(@Nullable List<Object> list) {
                    block6: {
                        ChunkRenderWorkerLitematica.this.freeRenderBuilder(generator);
                        generator.getLock().lock();
                        try {
                            if (generator.getStatus() == ChunkCompileTaskGeneratorSchematic.Status.UPLOADING) {
                                generator.setStatus(ChunkCompileTaskGeneratorSchematic.Status.DONE);
                                break block6;
                            }
                            if (!generator.isFinished()) {
                                LOGGER.warn("Chunk render task was {} when I expected it to be uploading; aborting task", (Object)generator.getStatus());
                            }
                        }
                        finally {
                            generator.getLock().unlock();
                        }
                        return;
                    }
                    generator.getRenderChunk().func_178580_a(compiledChunk);
                }

                public void onFailure(Throwable throwable) {
                    ChunkRenderWorkerLitematica.this.freeRenderBuilder(generator);
                    if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Litematica chunk"));
                    }
                }
            });
        }
    }

    private BufferBuilderCache getRegionRenderCacheBuilder() throws InterruptedException {
        return this.bufferCache != null ? this.bufferCache : this.chunkRenderDispatcher.allocateRenderBuilder();
    }

    private void freeRenderBuilder(ChunkCompileTaskGeneratorSchematic generator) {
        if (this.bufferCache == null) {
            this.chunkRenderDispatcher.freeRenderBuilder(generator.getBufferCache());
        }
    }

    public void notifyToStop() {
        this.shouldRun = false;
    }
}

