/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class ChunkCacheSchematic
implements IBlockAccess {
    private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected int chunkStartX;
    protected int chunkStartZ;
    protected Chunk[][] chunkArray;
    protected boolean empty;
    protected World world;

    public ChunkCacheSchematic(World worldIn, BlockPos pos, int expand) {
        int cz;
        int cx;
        this.world = worldIn;
        this.chunkStartX = pos.func_177958_n() - expand >> 4;
        this.chunkStartZ = pos.func_177952_p() - expand >> 4;
        int chunkEndX = pos.func_177958_n() + expand + 15 >> 4;
        int chunkEndZ = pos.func_177952_p() + expand + 15 >> 4;
        this.chunkArray = new Chunk[chunkEndX - this.chunkStartX + 1][chunkEndZ - this.chunkStartZ + 1];
        this.empty = true;
        for (cx = this.chunkStartX; cx <= chunkEndX; ++cx) {
            for (cz = this.chunkStartZ; cz <= chunkEndZ; ++cz) {
                this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ] = worldIn.func_72964_e(cx, cz);
            }
        }
        block2: for (cx = pos.func_177958_n() >> 4; cx <= pos.func_177958_n() + 15 >> 4; ++cx) {
            for (cz = pos.func_177952_p() >> 4; cz <= pos.func_177952_p() + 15 >> 4; ++cz) {
                Chunk chunk = this.chunkArray[cx - this.chunkStartX][cz - this.chunkStartZ];
                if (chunk == null || chunk.func_76606_c(pos.func_177956_o(), pos.func_177956_o() + 15)) continue;
                this.empty = false;
                continue block2;
            }
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int cx = (pos.func_177958_n() >> 4) - this.chunkStartX;
            int cz = (pos.func_177952_p() >> 4) - this.chunkStartZ;
            if (cx >= 0 && cx < this.chunkArray.length && cz >= 0 && cz < this.chunkArray[cx].length && (chunk = this.chunkArray[cx][cz]) != null) {
                return chunk.func_177435_g(pos);
            }
        }
        return AIR;
    }

    public Biome func_180494_b(BlockPos pos) {
        int cx = (pos.func_177958_n() >> 4) - this.chunkStartX;
        int cz = (pos.func_177952_p() >> 4) - this.chunkStartZ;
        return this.chunkArray[cx][cz].func_177411_a(pos, this.world.func_72959_q());
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity getTileEntity(BlockPos pos, Chunk.EnumCreateEntityType type) {
        int i = (pos.func_177958_n() >> 4) - this.chunkStartX;
        int j = (pos.func_177952_p() >> 4) - this.chunkStartZ;
        return this.chunkArray[i][j].func_177424_a(pos, type);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).func_185904_a() == Material.field_151579_a;
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        int sky = 15;
        int block = 0;
        if (block < lightValue) {
            block = lightValue;
        }
        return sky << 20 | block << 4;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockAccess)this, pos, direction);
    }

    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean defaultValue) {
        int z;
        if (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return defaultValue;
        }
        int x = (pos.func_177958_n() >> 4) - this.chunkStartX;
        if (!this.withinBounds(x, z = (pos.func_177952_p() >> 4) - this.chunkStartZ)) {
            return defaultValue;
        }
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isSideSolid(state, (IBlockAccess)this, pos, side);
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.chunkArray.length && z >= 0 && z < this.chunkArray[x].length && this.chunkArray[x][z] != null;
    }
}

