/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.RenderGlobalSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import org.lwjgl.opengl.GL20;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("litematica", null, "shaders/alpha.frag");
    private Minecraft mc;
    private RenderGlobalSchematic worldRenderer;
    private int frameCount;
    private long finishTimeNano;
    private Entity entity;
    private ICamera camera;
    private boolean renderPiecewise;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewisePrepared;
    private boolean translucentSchematic;

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public RenderGlobalSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = Minecraft.func_71410_x();
            this.worldRenderer = new RenderGlobalSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().func_72712_a();
    }

    public void onSchematicWorldChanged(@Nullable WorldClient worldClient) {
        this.getWorldRenderer().func_72732_a(worldClient);
    }

    private void calculateFinishTime() {
        long fpsLimit = this.mc.field_71474_y.field_74350_i;
        long fpsMin = Math.min((long)Minecraft.func_175610_ah(), fpsLimit);
        fpsMin = Math.max(fpsMin, 60L);
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsMin / 2L, 0L);
    }

    public void renderSchematicWorld(float partialTicks) {
        if (!this.mc.field_71454_w) {
            this.mc.field_71424_I.func_76320_a("litematica_schematic_world_render");
            if (this.mc.func_175606_aa() == null) {
                this.mc.func_175607_a((Entity)this.mc.field_71439_g);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            this.calculateFinishTime();
            this.renderWorld(partialTicks, this.finishTimeNano);
            this.cleanup();
            GlStateManager.func_179121_F();
            this.mc.field_71424_I.func_76319_b();
        }
    }

    private void renderWorld(float partialTicks, long finishTimeNano) {
        this.mc.field_71424_I.func_76320_a("culling");
        Entity entity = this.mc.func_175606_aa();
        ICamera icamera = this.createCamera(entity, partialTicks);
        GlStateManager.func_179103_j((int)7425);
        this.mc.field_71424_I.func_76318_c("prepare_terrain");
        this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderUtils.disableItemLighting();
        RenderGlobalSchematic renderGlobal = this.getWorldRenderer();
        this.mc.field_71424_I.func_76318_c("terrain_setup");
        renderGlobal.func_174970_a(entity, partialTicks, icamera, this.frameCount++, this.mc.field_71439_g.func_175149_v());
        this.mc.field_71424_I.func_76318_c("update_chunks");
        renderGlobal.func_174967_a(finishTimeNano);
        this.mc.field_71424_I.func_76318_c("terrain");
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179118_c();
        if (Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
            GlStateManager.func_179094_E();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-0.2f, (float)-0.4f);
            }
            this.startShaderIfEnabled();
            RenderUtils.setupBlend();
            renderGlobal.renderBlockLayer(BlockRenderLayer.SOLID, partialTicks, entity);
            renderGlobal.renderBlockLayer(BlockRenderLayer.CUTOUT_MIPPED, partialTicks, entity);
            this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            renderGlobal.renderBlockLayer(BlockRenderLayer.CUTOUT, partialTicks, entity);
            this.mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            this.mc.field_71424_I.func_76318_c("entities");
            GlStateManager.func_179094_E();
            RenderUtils.enableItemLighting();
            RenderUtils.setupBlend();
            renderGlobal.func_180446_a(entity, icamera, partialTicks);
            GlStateManager.func_179106_n();
            GlStateManager.func_179084_k();
            RenderUtils.disableItemLighting();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179121_F();
            GlStateManager.func_179089_o();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            this.mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179103_j((int)7425);
            this.mc.field_71424_I.func_76318_c("translucent");
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179094_E();
            RenderUtils.setupBlend();
            renderGlobal.renderBlockLayer(BlockRenderLayer.TRANSLUCENT, partialTicks, entity);
            GlStateManager.func_179121_F();
            this.disableShader();
        }
        this.mc.field_71424_I.func_76318_c("overlay");
        this.renderSchematicOverlay();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179089_o();
        this.mc.field_71424_I.func_76319_b();
    }

    public void renderSchematicOverlay() {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179129_p();
            GlStateManager.func_179092_a((int)516, (float)0.001f);
            GlStateManager.func_179088_q();
            GlStateManager.func_179136_a((float)-0.4f, (float)-0.8f);
            RenderUtils.setupBlend();
            GlStateManager.func_187441_d((float)lineWidth);
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            if (renderThrough) {
                GlStateManager.func_179097_i();
            }
            this.getWorldRenderer().renderBlockOverlays();
            GlStateManager.func_179126_j();
            GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
            GlStateManager.func_179113_r();
            GlStateManager.func_179098_w();
            GlStateManager.func_179121_F();
        }
    }

    public void startShaderIfEnabled() {
        boolean bl = this.translucentSchematic = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && OpenGlHelper.field_148824_g;
        if (this.translucentSchematic) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            GL20.glUseProgram((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)alpha);
        }
    }

    public void disableShader() {
        if (this.translucentSchematic) {
            GL20.glUseProgram((int)0);
        }
    }

    public void piecewisePrepareAndUpdate(float partialTicks) {
        this.renderPiecewise = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.func_175606_aa() != null;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
        if (this.renderPiecewise) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.mc.field_71424_I.func_76320_a("litematica_culling");
            Entity entity = this.mc.func_175606_aa();
            ICamera icamera = this.createCamera(entity, partialTicks);
            this.calculateFinishTime();
            RenderGlobalSchematic renderGlobal = this.getWorldRenderer();
            this.mc.field_71424_I.func_76318_c("litematica_terrain_setup");
            renderGlobal.func_174970_a(entity, partialTicks, icamera, this.frameCount++, this.mc.field_71439_g.func_175149_v());
            this.mc.field_71424_I.func_76318_c("litematica_update_chunks");
            renderGlobal.func_174967_a(this.finishTimeNano);
            this.mc.field_71424_I.func_76319_b();
            this.renderPiecewisePrepared = true;
        }
    }

    public void piecewiseRenderSolid(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.field_71424_I.func_76320_a("litematica_blocks_solid");
            if (renderColliding) {
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(BlockRenderLayer.SOLID, partialTicks, this.entity);
            this.disableShader();
            if (renderColliding) {
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
            }
            this.mc.field_71424_I.func_76319_b();
        }
    }

    public void piecewiseRenderCutoutMipped(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.field_71424_I.func_76320_a("litematica_blocks_cutout_mipped");
            if (renderColliding) {
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(BlockRenderLayer.CUTOUT_MIPPED, partialTicks, this.entity);
            this.disableShader();
            if (renderColliding) {
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
            }
            this.mc.field_71424_I.func_76319_b();
        }
    }

    public void piecewiseRenderCutout(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.field_71424_I.func_76320_a("litematica_blocks_cutout");
            if (renderColliding) {
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(BlockRenderLayer.CUTOUT, partialTicks, this.entity);
            this.disableShader();
            if (renderColliding) {
                GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                GlStateManager.func_179113_r();
            }
            this.mc.field_71424_I.func_76319_b();
        }
    }

    public void piecewiseRenderTranslucent(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewisePrepared) {
            if (this.renderPiecewiseBlocks) {
                this.mc.field_71424_I.func_76320_a("litematica_translucent");
                if (renderColliding) {
                    GlStateManager.func_179088_q();
                    GlStateManager.func_179136_a((float)-0.3f, (float)-0.6f);
                }
                this.startShaderIfEnabled();
                this.getWorldRenderer().renderBlockLayer(BlockRenderLayer.TRANSLUCENT, partialTicks, this.entity);
                this.disableShader();
                if (renderColliding) {
                    GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
                    GlStateManager.func_179113_r();
                }
                this.mc.field_71424_I.func_76319_b();
            }
            if (this.renderPiecewiseSchematic) {
                this.mc.field_71424_I.func_76320_a("litematica_overlay");
                this.renderSchematicOverlay();
                this.mc.field_71424_I.func_76319_b();
            }
            this.cleanup();
        }
    }

    public void piecewiseRenderEntities(float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.field_71424_I.func_76320_a("litematica_entities");
            RenderUtils.setupBlend();
            this.startShaderIfEnabled();
            this.getWorldRenderer().func_180446_a(this.entity, this.camera, partialTicks);
            this.disableShader();
            GlStateManager.func_179084_k();
            this.mc.field_71424_I.func_76319_b();
        }
    }

    private ICamera createCamera(Entity entity, float partialTicks) {
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        this.entity = entity;
        this.camera = new Frustum();
        this.camera.func_78547_a(x, y, z);
        return this.camera;
    }

    private void cleanup() {
        this.entity = null;
        this.camera = null;
        this.renderPiecewise = false;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
    }

    static {
        int program = SHADER_ALPHA.getProgram();
        GL20.glUseProgram((int)program);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)program, (CharSequence)"texture"), (int)0);
        GL20.glUseProgram((int)0);
    }
}

