/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;

public class MaterialCache {
    private static final MaterialCache INSTANCE = new MaterialCache();
    protected final IdentityHashMap<IBlockState, ItemStack> buildItemsForStates = new IdentityHashMap();
    protected final IdentityHashMap<IBlockState, ItemStack> displayItemsForStates = new IdentityHashMap();
    protected final WorldSchematic tempWorld;
    protected final BlockPos checkPos;
    protected boolean hasReadFromFile;
    protected boolean dirty;

    private MaterialCache() {
        WorldSettings settings = new WorldSettings(0L, GameType.CREATIVE, false, false, WorldType.field_77138_c);
        this.tempWorld = new WorldSchematic(null, settings, -1, EnumDifficulty.PEACEFUL, Minecraft.func_71410_x().field_71424_I);
        this.checkPos = new BlockPos(8, 0, 8);
        WorldUtils.loadChunksClientWorld(this.tempWorld, this.checkPos, new Vec3i(1, 1, 1));
    }

    public static MaterialCache getInstance() {
        if (!MaterialCache.INSTANCE.hasReadFromFile) {
            INSTANCE.readFromFile();
        }
        return INSTANCE;
    }

    public void clearCache() {
        this.buildItemsForStates.clear();
    }

    public ItemStack getRequiredBuildItemForState(IBlockState state) {
        return this.getRequiredBuildItemForState(state, (World)this.tempWorld, this.checkPos);
    }

    public ItemStack getRequiredBuildItemForState(IBlockState state, World world, BlockPos pos) {
        ItemStack stack = this.buildItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, world, pos, true);
        }
        return stack;
    }

    public ItemStack getItemForDisplayNameForState(IBlockState state) {
        ItemStack stack = this.displayItemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, (World)this.tempWorld, this.checkPos, false);
        }
        return stack;
    }

    protected ItemStack getItemForStateFromWorld(IBlockState state, World world, BlockPos pos, boolean isBuildItem) {
        ItemStack stack;
        ItemStack itemStack = stack = isBuildItem ? this.getStateToItemOverride(state) : null;
        if (stack == null) {
            world.func_180501_a(pos, state, 20);
            stack = state.func_177230_c().func_185473_a(world, pos, state);
        }
        if (stack == null || stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        } else {
            this.overrideStackSize(state, stack);
        }
        if (isBuildItem) {
            this.buildItemsForStates.put(state, stack);
        } else {
            this.displayItemsForStates.put(state, stack);
        }
        this.dirty = true;
        return stack;
    }

    public boolean requiresMultipleItems(IBlockState state) {
        Block block = state.func_177230_c();
        return block == Blocks.field_150457_bL && state.func_177229_b((IProperty)BlockFlowerPot.field_176443_b) != BlockFlowerPot.EnumFlowerType.EMPTY;
    }

    public ImmutableList<ItemStack> getItems(IBlockState state) {
        return this.getItems(state, (World)this.tempWorld, this.checkPos);
    }

    public ImmutableList<ItemStack> getItems(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150457_bL && state.func_177229_b((IProperty)BlockFlowerPot.field_176443_b) != BlockFlowerPot.EnumFlowerType.EMPTY) {
            BlockFlowerPot.EnumFlowerType type = (BlockFlowerPot.EnumFlowerType)state.func_177229_b((IProperty)BlockFlowerPot.field_176443_b);
            ItemStack plant = null;
            switch (type) {
                case ACACIA_SAPLING: {
                    plant = new ItemStack(Blocks.field_150345_g, 1, 4);
                    break;
                }
                case ALLIUM: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 2);
                    break;
                }
                case BIRCH_SAPLING: {
                    plant = new ItemStack(Blocks.field_150345_g, 1, 2);
                    break;
                }
                case BLUE_ORCHID: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 1);
                    break;
                }
                case CACTUS: {
                    plant = new ItemStack((Block)Blocks.field_150434_aF, 1, 0);
                    break;
                }
                case DANDELION: {
                    plant = new ItemStack((Block)Blocks.field_150327_N, 1, 0);
                    break;
                }
                case DARK_OAK_SAPLING: {
                    plant = new ItemStack(Blocks.field_150345_g, 1, 5);
                    break;
                }
                case DEAD_BUSH: {
                    plant = new ItemStack((Block)Blocks.field_150330_I, 1, 0);
                    break;
                }
                case FERN: {
                    plant = new ItemStack((Block)Blocks.field_150329_H, 1, 2);
                    break;
                }
                case HOUSTONIA: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 3);
                    break;
                }
                case JUNGLE_SAPLING: {
                    plant = new ItemStack(Blocks.field_150345_g, 1, 3);
                    break;
                }
                case MUSHROOM_BROWN: {
                    plant = new ItemStack((Block)Blocks.field_150338_P, 1, 0);
                    break;
                }
                case MUSHROOM_RED: {
                    plant = new ItemStack((Block)Blocks.field_150337_Q, 1, 0);
                    break;
                }
                case OAK_SAPLING: {
                    plant = new ItemStack(Blocks.field_150345_g, 1, 0);
                    break;
                }
                case ORANGE_TULIP: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 5);
                    break;
                }
                case OXEYE_DAISY: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 8);
                    break;
                }
                case PINK_TULIP: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 7);
                    break;
                }
                case POPPY: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 0);
                    break;
                }
                case RED_TULIP: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 4);
                    break;
                }
                case SPRUCE_SAPLING: {
                    plant = new ItemStack(Blocks.field_150345_g, 1, 1);
                    break;
                }
                case WHITE_TULIP: {
                    plant = new ItemStack((Block)Blocks.field_150328_O, 1, 6);
                    break;
                }
            }
            if (plant != null) {
                return ImmutableList.of((Object)new ItemStack(Items.field_151162_bE), (Object)plant);
            }
        }
        return ImmutableList.of((Object)this.getRequiredBuildItemForState(state, world, pos));
    }

    @Nullable
    protected ItemStack getStateToItemOverride(IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150332_K || block == Blocks.field_180384_M || block == Blocks.field_150427_aO || block == Blocks.field_150384_bq || block == Blocks.field_185775_db) {
            return ItemStack.field_190927_a;
        }
        if (block == Blocks.field_150458_ak) {
            return new ItemStack(Blocks.field_150346_d);
        }
        if (block == Blocks.field_150420_aW) {
            return new ItemStack(Blocks.field_150420_aW);
        }
        if (block == Blocks.field_150419_aX) {
            return new ItemStack(Blocks.field_150419_aX);
        }
        if (block == Blocks.field_150353_l) {
            if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                return new ItemStack(Items.field_151129_at);
            }
            return ItemStack.field_190927_a;
        }
        if (block == Blocks.field_150355_j) {
            if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                return new ItemStack(Items.field_151131_as);
            }
            return ItemStack.field_190927_a;
        }
        if (block instanceof BlockDoor && state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            return ItemStack.field_190927_a;
        }
        if (block instanceof BlockBed && state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
            return ItemStack.field_190927_a;
        }
        if (block instanceof BlockDoublePlant && state.func_177229_b((IProperty)BlockDoublePlant.field_176492_b) == BlockDoublePlant.EnumBlockHalf.UPPER) {
            return ItemStack.field_190927_a;
        }
        return null;
    }

    protected void overrideStackSize(IBlockState state, ItemStack stack) {
        if (state.func_177230_c() instanceof BlockSlab && ((BlockSlab)state.func_177230_c()).func_176552_j()) {
            stack.func_190920_e(2);
        } else if (state.func_177230_c() == Blocks.field_150431_aC) {
            stack.func_190920_e(((Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a)).intValue());
        }
    }

    protected NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("MaterialCache", (NBTBase)this.writeMapToNBT(this.buildItemsForStates));
        nbt.func_74782_a("DisplayMaterialCache", (NBTBase)this.writeMapToNBT(this.displayItemsForStates));
        return nbt;
    }

    protected NBTTagList writeMapToNBT(IdentityHashMap<IBlockState, ItemStack> map) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<IBlockState, ItemStack> entry : map.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound stateTag = new NBTTagCompound();
            NBTUtil.func_190009_a((NBTTagCompound)stateTag, (IBlockState)entry.getKey());
            tag.func_74782_a("Block", (NBTBase)stateTag);
            tag.func_74782_a("Item", (NBTBase)entry.getValue().func_77955_b(new NBTTagCompound()));
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    protected void readFromNBT(NBTTagCompound nbt) {
        this.buildItemsForStates.clear();
        this.displayItemsForStates.clear();
        this.readMapFromNBT(nbt, "MaterialCache", this.buildItemsForStates);
        this.readMapFromNBT(nbt, "DisplayMaterialCache", this.displayItemsForStates);
    }

    protected void readMapFromNBT(NBTTagCompound nbt, String tagName, IdentityHashMap<IBlockState, ItemStack> map) {
        if (nbt.func_150297_b(tagName, 9)) {
            NBTTagList list = nbt.func_150295_c(tagName, 10);
            int count = list.func_74745_c();
            for (int i = 0; i < count; ++i) {
                IBlockState state;
                NBTTagCompound tag = list.func_150305_b(i);
                if (!tag.func_150297_b("Block", 10) || !tag.func_150297_b("Item", 10) || (state = NBTUtil.func_190008_d((NBTTagCompound)tag.func_74775_l("Block"))) == null) continue;
                ItemStack stack = new ItemStack(tag.func_74775_l("Item"));
                this.buildItemsForStates.put(state, stack);
            }
        }
    }

    protected File getCacheDir() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    protected File getCacheFile() {
        return new File(this.getCacheDir(), "material_cache.nbt");
    }

    public boolean writeToFile() {
        if (!this.dirty) {
            return false;
        }
        File dir = this.getCacheDir();
        File file = this.getCacheFile();
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath());
                return false;
            }
            FileOutputStream os = new FileOutputStream(file);
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(), (OutputStream)os);
            os.close();
            this.dirty = false;
            return true;
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public void readFromFile() {
        File file = this.getCacheFile();
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)is);
            is.close();
            if (nbt != null) {
                this.readFromNBT(nbt);
                this.hasReadFromFile = true;
                this.dirty = false;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read the material list cache from file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

