/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.gui;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicManager;
import fi.dy.masa.litematica.gui.GuiSchematicSaveBase;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicBrowser;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.widgets.WidgetFileBrowserBase;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;

public class GuiSchematicSaveExported
extends GuiSchematicSaveBase {
    private final GuiSchematicManager.ExportType exportType;
    private final WidgetFileBrowserBase.DirectoryEntryType type;
    private final File dirSource;
    private final String inputFileName;

    public GuiSchematicSaveExported(WidgetFileBrowserBase.DirectoryEntryType type, File dirSource, String inputFileName, GuiSchematicManager.ExportType exportType) {
        super(null);
        this.exportType = exportType;
        this.type = type;
        this.dirSource = dirSource;
        this.inputFileName = inputFileName;
        this.defaultText = FileUtils.getNameWithoutExtension((String)inputFileName);
        this.title = StringUtils.translate((String)"litematica.gui.title.save_exported_schematic", (Object[])new Object[]{exportType.getDisplayName(), inputFileName});
        this.useTitleHierarchy = false;
    }

    @Override
    public String getBrowserContext() {
        return "schematic_save_exported";
    }

    @Override
    public File getDefaultDirectory() {
        return DataManager.getSchematicsBaseDirectory();
    }

    @Override
    protected void saveSchematic() {
        File dir = ((WidgetSchematicBrowser)this.getListWidget()).getCurrentDirectory();
        String fileName = this.getTextFieldText();
        if (FileUtils.doesFilenameContainIllegalCharacters((String)fileName)) {
            this.addMessage(Message.MessageType.ERROR, "litematica.error.illegal_characters_in_file_name", new Object[]{fileName});
            return;
        }
        if (!dir.isDirectory()) {
            this.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_save.invalid_directory", new Object[]{dir.getAbsolutePath()});
            return;
        }
        if (fileName.isEmpty()) {
            this.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_save.invalid_schematic_name", new Object[]{fileName});
            return;
        }
        if (this.type == WidgetFileBrowserBase.DirectoryEntryType.FILE) {
            File inDir = this.dirSource;
            String inFile = this.inputFileName;
            boolean override = GuiBase.isShiftDown();
            boolean ignoreEntities = this.checkboxIgnoreEntities.isChecked();
            FileType fileType = FileType.fromFile(new File(inDir, inFile));
            if (fileType == FileType.LITEMATICA_SCHEMATIC) {
                if (this.exportType == GuiSchematicManager.ExportType.SCHEMATIC) {
                    if (WorldUtils.convertLitematicaSchematicToSchematicaSchematic(inDir, inFile, dir, fileName, ignoreEntities, override, (IStringConsumer)this)) {
                        this.addMessage(Message.MessageType.SUCCESS, "litematica.message.schematic_exported_as", new Object[]{fileName});
                        ((WidgetSchematicBrowser)this.getListWidget()).refreshEntries();
                    }
                } else if (this.exportType == GuiSchematicManager.ExportType.VANILLA && WorldUtils.convertLitematicaSchematicToVanillaStructure(inDir, inFile, dir, fileName, ignoreEntities, override, (IStringConsumer)this)) {
                    this.addMessage(Message.MessageType.SUCCESS, "litematica.message.schematic_exported_as", new Object[]{fileName});
                    ((WidgetSchematicBrowser)this.getListWidget()).refreshEntries();
                }
                return;
            }
        }
        this.addMessage(Message.MessageType.ERROR, "litematica.error.schematic_export.unsupported_type", new Object[]{this.inputFileName});
    }
}

