/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.event;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.SchematicUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private static final InputHandler INSTANCE = new InputHandler();

    private InputHandler() {
    }

    public static InputHandler getInstance() {
        return INSTANCE;
    }

    public List<? extends IHotkey> getAllHotkeys() {
        return Hotkeys.HOTKEY_LIST;
    }

    public List<KeybindCategory> getHotkeyCategoriesForCombinedView() {
        return ImmutableList.of((Object)new KeybindCategory("Litematica", "litematica.hotkeys.category.generic_hotkeys", Hotkeys.HOTKEY_LIST));
    }

    public boolean onKeyInput(int eventKey, boolean eventKeyState) {
        if (eventKeyState) {
            Minecraft mc = Minecraft.func_71410_x();
            if (eventKey == mc.field_71474_y.field_74313_G.func_151463_i()) {
                return this.handleUseKey(mc);
            }
            if (eventKey == mc.field_71474_y.field_74312_F.func_151463_i()) {
                return this.handleAttackKey(mc);
            }
            if (eventKey == mc.field_71474_y.field_151447_Z.func_151463_i() && GuiSchematicManager.hasPendingPreviewTask()) {
                return GuiSchematicManager.setPreviewImage();
            }
        }
        return false;
    }

    public boolean onMouseInput(int eventButton, int dWheel, boolean eventButtonState) {
        Minecraft mc = Minecraft.func_71410_x();
        if (GuiUtils.getCurrentScreen() == null && mc.field_71441_e != null && mc.field_71439_g != null) {
            if (eventButtonState && eventButton == mc.field_71474_y.field_74313_G.func_151463_i() + 100) {
                return this.handleUseKey(mc);
            }
            if (eventButtonState && eventButton == mc.field_71474_y.field_74312_F.func_151463_i() + 100) {
                return this.handleAttackKey(mc);
            }
            if (dWheel != 0) {
                return this.handleMouseScroll(dWheel, mc);
            }
        }
        return false;
    }

    private boolean handleMouseScroll(double dWheel, Minecraft mc) {
        boolean toolEnabled;
        EntityPlayerSP player = mc.field_71439_g;
        boolean bl = toolEnabled = Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue();
        if (!toolEnabled || !EntityUtils.hasToolItem((EntityLivingBase)player)) {
            return false;
        }
        int amount = dWheel > 0.0 ? 1 : -1;
        ToolMode mode = DataManager.getToolMode();
        EnumFacing direction = fi.dy.masa.malilib.util.PositionUtils.getClosestLookingDirection((Entity)player);
        if (Hotkeys.SELECTION_EXPAND_MODIFIER.getKeybind().isKeybindHeld() && mode.getUsesAreaSelection()) {
            return this.modifySelectionBox(amount, mode, direction, (boxIn, amountIn, side) -> PositionUtils.expandOrShrinkBox(boxIn, amountIn, side));
        }
        if (Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld() && mode.getUsesAreaSelection()) {
            SelectionManager sm = DataManager.getSelectionManager();
            if (sm.hasGrabbedElement()) {
                sm.changeGrabDistance((Entity)player, amount);
                return true;
            }
            if (sm.hasSelectedOrigin()) {
                AreaSelection area = sm.getCurrentSelection();
                BlockPos old = area.getEffectiveOrigin();
                area.moveEntireSelectionTo(old.func_177967_a(EntityUtils.getClosestLookingDirection((Entity)player), amount), false);
                return true;
            }
            if (mode == ToolMode.MOVE) {
                SchematicUtils.moveCurrentlySelectedWorldRegionToLookingDirection(amount, (EntityPlayer)player, mc);
                return true;
            }
        }
        if (Hotkeys.SELECTION_GROW_MODIFIER.getKeybind().isKeybindHeld()) {
            return this.modifySelectionBox(amount, mode, direction, (boxIn, amountIn, side) -> PositionUtils.growOrShrinkBox(boxIn, amountIn));
        }
        if (Hotkeys.SELECTION_NUDGE_MODIFIER.getKeybind().isKeybindHeld()) {
            return InputHandler.nudgeSelection(amount, mode, (EntityPlayer)player);
        }
        if (Hotkeys.OPERATION_MODE_CHANGE_MODIFIER.getKeybind().isKeybindHeld()) {
            DataManager.setToolMode(DataManager.getToolMode().cycle((EntityPlayer)player, amount < 0));
            return true;
        }
        if (Hotkeys.SCHEMATIC_VERSION_CYCLE_MODIFIER.getKeybind().isKeybindHeld()) {
            if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                DataManager.getSchematicProjectsManager().cycleVersion(amount * -1);
            }
            return true;
        }
        return false;
    }

    public static boolean nudgeSelection(int amount, ToolMode mode, EntityPlayer player) {
        if (mode.getUsesAreaSelection()) {
            SelectionManager sm = DataManager.getSelectionManager();
            if (sm.hasSelectedElement()) {
                sm.moveSelectedElement(EntityUtils.getClosestLookingDirection((Entity)player), amount);
                return true;
            }
        } else if (mode.getUsesSchematic()) {
            EnumFacing direction = EntityUtils.getClosestLookingDirection((Entity)player);
            DataManager.getSchematicPlacementManager().nudgePositionOfCurrentSelection(direction, amount);
            return true;
        }
        return false;
    }

    private boolean modifySelectionBox(int amount, ToolMode mode, EnumFacing direction, IBoxEditor editor) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null) {
            Box box = area.getSelectedSubRegionBox();
            if (box != null) {
                Box newBox = editor.editBox(box, amount, direction);
                area.setSelectedSubRegionCornerPos(newBox.getPos1(), PositionUtils.Corner.CORNER_1);
                area.setSelectedSubRegionCornerPos(newBox.getPos2(), PositionUtils.Corner.CORNER_2);
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.area_selection.no_sub_region_selected", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
        return true;
    }

    private boolean handleAttackKey(Minecraft mc) {
        if (mc.field_71439_g != null && DataManager.getToolMode() == ToolMode.REBUILD) {
            if (Hotkeys.SCHEMATIC_REBUILD_BREAK_DIRECTION.getKeybind().isKeybindHeld()) {
                return SchematicUtils.breakSchematicBlocks(mc);
            }
            if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL.getKeybind().isKeybindHeld()) {
                return SchematicUtils.breakAllIdenticalSchematicBlocks(mc);
            }
            return SchematicUtils.breakSchematicBlock(mc);
        }
        return false;
    }

    private boolean handleUseKey(Minecraft mc) {
        if (mc.field_71439_g != null) {
            if (DataManager.getToolMode() == ToolMode.REBUILD) {
                if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_DIRECTION.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.replaceSchematicBlocksInDirection(mc);
                }
                if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_ALL.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.replaceAllIdenticalSchematicBlocks(mc);
                }
                if (Hotkeys.SCHEMATIC_REBUILD_BREAK_DIRECTION.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.placeSchematicBlocksInDirection(mc);
                }
                if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.fillAirWithBlocks(mc);
                }
                return SchematicUtils.placeSchematicBlock(mc);
            }
            if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld()) {
                return WorldUtils.handleEasyPlace(mc);
            }
            if (Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && KeybindMulti.hotkeyMatchesKeybind((IHotkey)Hotkeys.PICK_BLOCK_LAST, (KeyBinding)mc.field_71474_y.field_74313_G)) {
                WorldUtils.doSchematicWorldPickBlock(false, mc);
            }
            if (Configs.Generic.PLACEMENT_RESTRICTION.getBooleanValue()) {
                return WorldUtils.handlePlacementRestriction(mc);
            }
        }
        return false;
    }

    public static void onTick(Minecraft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        if (sm.hasGrabbedElement()) {
            sm.moveGrabbedElement((Entity)mc.field_71439_g);
        } else {
            WorldUtils.easyPlaceOnUseTick(mc);
        }
    }

    private static interface IBoxEditor {
        public Box editBox(Box var1, int var2, EnumFacing var3);
    }
}

