/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.gui.GuiConfigs;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.projects.SchematicProjectsManager;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelectionSimple;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.tool.ToolModeData;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.malilib.gui.interfaces.IConfigGuiTab;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryCache;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DataManager
implements IDirectoryCache {
    private static final DataManager INSTANCE = new DataManager();
    private static final Pattern PATTERN_ITEM_META_NBT = Pattern.compile("^(?<name>[a-z0-9\\._-]+:[a-z0-9\\._-]+)@(?<meta>[0-9]+)(?<nbt>\\{.*\\})$");
    private static final Pattern PATTERN_ITEM_META = Pattern.compile("^(?<name>[a-z0-9\\._-]+:[a-z0-9\\._-]+)@(?<meta>[0-9]+)$");
    private static final Pattern PATTERN_ITEM_BASE = Pattern.compile("^(?<name>[a-z0-9\\._-]+:[a-z0-9\\._-]+)$");
    private static final Map<String, File> LAST_DIRECTORIES = new HashMap<String, File>();
    private static ItemStack toolItem = new ItemStack(Items.field_151055_y);
    private static IConfigGuiTab configGuiTab = GuiConfigs.VISUALS;
    private static boolean createPlacementOnLoad = true;
    private static boolean canSave;
    private static long clientTickStart;
    private final SelectionManager selectionManager = new SelectionManager();
    private final SchematicPlacementManager schematicPlacementManager = new SchematicPlacementManager();
    private final SchematicProjectsManager schematicProjectsManager = new SchematicProjectsManager();
    private LayerRange renderRange = new LayerRange((IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
    private ToolMode operationMode = ToolMode.SCHEMATIC_PLACEMENT;
    private AreaSelectionSimple areaSimple = new AreaSelectionSimple(true);
    @Nullable
    private MaterialListBase materialList;

    private DataManager() {
    }

    private static DataManager getInstance() {
        return INSTANCE;
    }

    public static IDirectoryCache getDirectoryCache() {
        return INSTANCE;
    }

    public static void onClientTickStart() {
        clientTickStart = System.nanoTime();
    }

    public static long getClientTickStartTime() {
        return clientTickStart;
    }

    public static ItemStack getToolItem() {
        return toolItem;
    }

    public static boolean getCreatePlacementOnLoad() {
        return createPlacementOnLoad;
    }

    public static void setCreatePlacementOnLoad(boolean create) {
        createPlacementOnLoad = create;
    }

    public static IConfigGuiTab getConfigGuiTab() {
        return configGuiTab;
    }

    public static void setConfigGuiTab(IConfigGuiTab tab) {
        configGuiTab = tab;
    }

    public static SelectionManager getSelectionManager() {
        return DataManager.getInstance().selectionManager;
    }

    public static SchematicPlacementManager getSchematicPlacementManager() {
        return DataManager.getInstance().schematicPlacementManager;
    }

    public static SchematicProjectsManager getSchematicProjectsManager() {
        return DataManager.getInstance().schematicProjectsManager;
    }

    @Nullable
    public static MaterialListBase getMaterialList() {
        return DataManager.getInstance().materialList;
    }

    public static void setMaterialList(@Nullable MaterialListBase materialList) {
        MaterialListHudRenderer renderer;
        MaterialListBase old = DataManager.getInstance().materialList;
        if (old != null && materialList != old && (renderer = old.getHudRenderer()).getShouldRenderCustom()) {
            renderer.toggleShouldRender();
            InfoHud.getInstance().removeInfoHudRenderer(renderer, false);
        }
        DataManager.getInstance().materialList = materialList;
    }

    public static ToolMode getToolMode() {
        return DataManager.getInstance().operationMode;
    }

    public static void setToolMode(ToolMode mode) {
        DataManager.getInstance().operationMode = mode;
    }

    public static LayerRange getRenderLayerRange() {
        return DataManager.getInstance().renderRange;
    }

    public static AreaSelectionSimple getSimpleArea() {
        return DataManager.getInstance().areaSimple;
    }

    @Nullable
    public File getCurrentDirectoryForContext(String context) {
        return LAST_DIRECTORIES.get(context);
    }

    public void setCurrentDirectoryForContext(String context, File dir) {
        LAST_DIRECTORIES.put(context, dir);
    }

    public static void load() {
        LAST_DIRECTORIES.clear();
        DataManager.getInstance().loadPerDimensionData();
        File file = DataManager.getCurrentStorageFile(true);
        JsonElement element = JsonUtils.parseJsonFile((File)file);
        if (element != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            if (JsonUtils.hasObject((JsonObject)root, (String)"last_directories")) {
                JsonObject obj = root.get("last_directories").getAsJsonObject();
                for (Map.Entry entry : obj.entrySet()) {
                    File dir;
                    String name = (String)entry.getKey();
                    JsonElement el = (JsonElement)entry.getValue();
                    if (!el.isJsonPrimitive() || !(dir = new File(el.getAsString())).exists() || !dir.isDirectory()) continue;
                    LAST_DIRECTORIES.put(name, dir);
                }
            }
            if (JsonUtils.hasString((JsonObject)root, (String)"config_gui_tab")) {
                configGuiTab = GuiConfigs.VISUALS;
                String tabName = root.get("config_gui_tab").getAsString();
                for (IConfigGuiTab tab : GuiConfigs.TABS) {
                    if (!tabName.equalsIgnoreCase(tab.getName())) continue;
                    configGuiTab = tab;
                    break;
                }
            }
            createPlacementOnLoad = JsonUtils.getBooleanOrDefault((JsonObject)root, (String)"create_placement_on_load", (boolean)true);
        }
        canSave = true;
    }

    public static void save() {
        DataManager.save(false);
        MaterialCache.getInstance().writeToFile();
    }

    public static void save(boolean forceSave) {
        if (!canSave && !forceSave) {
            return;
        }
        DataManager.getInstance().savePerDimensionData();
        JsonObject root = new JsonObject();
        JsonObject objDirs = new JsonObject();
        for (Map.Entry<String, File> entry : LAST_DIRECTORIES.entrySet()) {
            objDirs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue().getAbsolutePath()));
        }
        root.add("last_directories", (JsonElement)objDirs);
        root.add("create_placement_on_load", (JsonElement)new JsonPrimitive(Boolean.valueOf(createPlacementOnLoad)));
        root.add("config_gui_tab", (JsonElement)new JsonPrimitive(configGuiTab.getName()));
        File file = DataManager.getCurrentStorageFile(true);
        JsonUtils.writeJsonToFile((JsonElement)root, (File)file);
        canSave = false;
    }

    public static void clear() {
        TaskScheduler.getInstanceClient().clearTasks();
        SchematicVerifier.clearActiveVerifiers();
        InfoHud.getInstance().reset();
        DataManager.getInstance().clearData(true);
    }

    private void savePerDimensionData() {
        this.schematicProjectsManager.saveCurrentProject();
        JsonObject root = this.toJson();
        File file = DataManager.getCurrentStorageFile(false);
        JsonUtils.writeJsonToFile((JsonElement)root, (File)file);
    }

    private void clearData(boolean isLogout) {
        this.selectionManager.clear();
        this.schematicPlacementManager.clear();
        this.schematicProjectsManager.clear();
        this.areaSimple = new AreaSelectionSimple(true);
        if (isLogout || this.materialList != null && this.materialList.isForPlacement()) {
            DataManager.setMaterialList(null);
        }
    }

    private void loadPerDimensionData() {
        this.clearData(false);
        File file = DataManager.getCurrentStorageFile(false);
        JsonElement element = JsonUtils.parseJsonFile((File)file);
        if (element != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            this.fromJson(root);
        }
    }

    private void fromJson(JsonObject obj) {
        if (JsonUtils.hasObject((JsonObject)obj, (String)"selections")) {
            this.selectionManager.loadFromJson(obj.get("selections").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"placements")) {
            this.schematicPlacementManager.loadFromJson(obj.get("placements").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"schematic_projects_manager")) {
            this.schematicProjectsManager.loadFromJson(obj.get("schematic_projects_manager").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"render_range")) {
            this.renderRange = LayerRange.createFromJson((JsonObject)JsonUtils.getNestedObject((JsonObject)obj, (String)"render_range", (boolean)false), (IRangeChangeListener)SchematicWorldRefresher.INSTANCE);
        }
        if (JsonUtils.hasString((JsonObject)obj, (String)"operation_mode")) {
            try {
                this.operationMode = ToolMode.valueOf(obj.get("operation_mode").getAsString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.operationMode == null) {
                this.operationMode = ToolMode.AREA_SELECTION;
            }
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"area_simple")) {
            this.areaSimple = AreaSelectionSimple.fromJson(obj.get("area_simple").getAsJsonObject());
        }
        if (JsonUtils.hasObject((JsonObject)obj, (String)"tool_mode_data")) {
            this.toolModeDataFromJson(obj.get("tool_mode_data").getAsJsonObject());
        }
    }

    private JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("selections", (JsonElement)this.selectionManager.toJson());
        obj.add("placements", (JsonElement)this.schematicPlacementManager.toJson());
        obj.add("schematic_projects_manager", (JsonElement)this.schematicProjectsManager.toJson());
        obj.add("operation_mode", (JsonElement)new JsonPrimitive(this.operationMode.name()));
        obj.add("render_range", (JsonElement)this.renderRange.toJson());
        obj.add("area_simple", (JsonElement)this.areaSimple.toJson());
        obj.add("tool_mode_data", (JsonElement)this.toolModeDataToJson());
        return obj;
    }

    private JsonObject toolModeDataToJson() {
        JsonObject obj = new JsonObject();
        obj.add("delete", (JsonElement)ToolModeData.DELETE.toJson());
        return obj;
    }

    private void toolModeDataFromJson(JsonObject obj) {
        if (JsonUtils.hasObject((JsonObject)obj, (String)"delete")) {
            ToolModeData.DELETE.fromJson(obj.get("delete").getAsJsonObject());
        }
    }

    public static File getCurrentConfigDirectory() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    public static File getSchematicsBaseDirectory() {
        File dir = FileUtils.getCanonicalFileIfPossible((File)new File(FileUtils.getMinecraftDirectory(), "schematics"));
        if (!dir.exists() && !dir.mkdirs()) {
            Litematica.logger.warn("Failed to create the schematic directory '{}'", (Object)dir.getAbsolutePath());
        }
        return dir;
    }

    public static File getAreaSelectionsBaseDirectory() {
        String name = StringUtils.getWorldOrServerName();
        File dir = Configs.Generic.AREAS_PER_WORLD.getBooleanValue() && name != null ? FileUtils.getCanonicalFileIfPossible((File)new File(new File(new File(DataManager.getCurrentConfigDirectory(), "area_selections_per_world"), name), "area_selections")) : FileUtils.getCanonicalFileIfPossible((File)new File(DataManager.getCurrentConfigDirectory(), "area_selections"));
        if (!dir.exists() && !dir.mkdirs()) {
            Litematica.logger.warn("Failed to create the area selections base directory '{}'", (Object)dir.getAbsolutePath());
        }
        return dir;
    }

    private static File getCurrentStorageFile(boolean globalData) {
        File dir = DataManager.getCurrentConfigDirectory();
        if (!dir.exists() && !dir.mkdirs()) {
            Litematica.logger.warn("Failed to create the config directory '{}'", (Object)dir.getAbsolutePath());
        }
        return new File(dir, DataManager.getStorageFileName(globalData));
    }

    private static String getStorageFileName(boolean globalData) {
        Minecraft mc = Minecraft.func_71410_x();
        String name = StringUtils.getWorldOrServerName();
        if (name != null) {
            if (globalData) {
                return "litematica_" + name + ".json";
            }
            return "litematica_" + name + "_dim" + WorldUtils.getDimensionId((World)mc.field_71441_e) + ".json";
        }
        return "litematica_default.json";
    }

    public static void setToolItem(String itemNameIn) {
        if (itemNameIn.isEmpty() || itemNameIn.equals("empty")) {
            toolItem = ItemStack.field_190927_a;
            return;
        }
        try {
            Item item;
            Matcher matcherNbt = PATTERN_ITEM_META_NBT.matcher(itemNameIn);
            Matcher matcherMeta = PATTERN_ITEM_META.matcher(itemNameIn);
            Matcher matcherBase = PATTERN_ITEM_BASE.matcher(itemNameIn);
            String itemName = null;
            int meta = 0;
            NBTTagCompound nbt = null;
            if (matcherNbt.matches()) {
                itemName = matcherNbt.group("name");
                meta = Integer.parseInt(matcherNbt.group("meta"));
                nbt = JsonToNBT.func_180713_a((String)matcherNbt.group("nbt"));
            } else if (matcherMeta.matches()) {
                itemName = matcherMeta.group("name");
                meta = Integer.parseInt(matcherMeta.group("meta"));
            } else if (matcherBase.matches()) {
                itemName = matcherBase.group("name");
            }
            if (itemName != null && (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName))) != null && item != Items.field_190931_a) {
                toolItem = new ItemStack(item, 1, meta);
                toolItem.func_77982_d(nbt);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        toolItem = new ItemStack(Items.field_151055_y);
        Configs.Generic.TOOL_ITEM.setValueFromString(((ResourceLocation)Item.field_150901_e.func_177774_c((Object)Items.field_151055_y)).toString());
    }
}

