/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client.condition;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.multipart.ConditionPropertyValue;

public class FoamyConditionPropertyValue
extends ConditionPropertyValue {
    private static final Splitter SPLITTER = Splitter.on((char)'|').omitEmptyStrings();

    public FoamyConditionPropertyValue(String keyIn, String valueIn) {
        super(keyIn, valueIn);
    }

    public Predicate<IBlockState> func_188118_a(BlockStateContainer blockState) {
        List valueNames;
        boolean negate;
        IProperty property = blockState.func_185920_a(this.field_188125_d);
        if (property == null) {
            throw new RuntimeException(this.toString() + ": Definition: " + blockState + " has no property: " + this.field_188125_d);
        }
        String s = this.field_188126_e;
        boolean bl = negate = !s.isEmpty() && s.charAt(0) == '!';
        if (negate) {
            s = s.substring(1);
        }
        if ((valueNames = SPLITTER.splitToList((CharSequence)s)).isEmpty()) {
            throw new RuntimeException(this.toString() + ": has an empty value: " + this.field_188126_e);
        }
        Object[] values = new Object[valueNames.size()];
        for (int i = 0; i < values.length; ++i) {
            Optional valueParsed = property.func_185929_b((String)valueNames.get(i));
            if (!valueParsed.isPresent()) {
                throw new RuntimeException(this.toString() + ": has an unknown value: " + this.field_188126_e);
            }
            values[i] = valueParsed.get();
        }
        if (negate) {
            return values.length > 1 ? new PredicateNegative(property, values) : new SingletonPredicateNegative(property, values[0]);
        }
        return values.length > 1 ? new PredicatePositive(property, values) : new SingletonPredicatePositive(property, values[0]);
    }

    public static final class PredicateNegative
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object[] values;

        protected PredicateNegative(IProperty<?> property, Object[] values) {
            this.property = property;
            this.values = values;
        }

        public boolean apply(@Nullable IBlockState state) {
            if (state != null) {
                Comparable value = state.func_177229_b(this.property);
                for (int i = 0; i < this.values.length; ++i) {
                    if (!value.equals(this.values[i])) continue;
                    return false;
                }
            }
            return true;
        }

        public static final class HashingStrategy
        implements gnu.trove.strategy.HashingStrategy<PredicateNegative> {
            public int computeHashCode(PredicateNegative object) {
                return 31 * object.property.hashCode() + Arrays.hashCode(object.values);
            }

            public boolean equals(PredicateNegative o1, PredicateNegative o2) {
                if (o1.property == o2.property) {
                    if (o1.values.length != o2.values.length) {
                        return false;
                    }
                    for (int i = 0; i < o1.values.length; ++i) {
                        if (o1.values[i] == o2.values[i]) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public static final class SingletonPredicateNegative
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object value;

        protected SingletonPredicateNegative(IProperty<?> property, Object value) {
            this.property = property;
            this.value = value;
        }

        public boolean apply(@Nullable IBlockState state) {
            return state == null || !state.func_177229_b(this.property).equals(this.value);
        }

        public static final class HashingStrategy
        implements gnu.trove.strategy.HashingStrategy<SingletonPredicateNegative> {
            public int computeHashCode(SingletonPredicateNegative object) {
                return 31 * object.property.hashCode() + (object.value != null ? object.value.hashCode() : 0);
            }

            public boolean equals(SingletonPredicateNegative o1, SingletonPredicateNegative o2) {
                return o1.property == o2.property && o1.value == o2.value;
            }
        }
    }

    public static final class PredicatePositive
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object[] values;

        protected PredicatePositive(IProperty<?> property, Object[] values) {
            this.property = property;
            this.values = values;
        }

        public boolean apply(@Nullable IBlockState state) {
            if (state != null) {
                Comparable value = state.func_177229_b(this.property);
                for (int i = 0; i < this.values.length; ++i) {
                    if (!value.equals(this.values[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public static final class HashingStrategy
        implements gnu.trove.strategy.HashingStrategy<PredicatePositive> {
            public int computeHashCode(PredicatePositive object) {
                return 31 * object.property.hashCode() + Arrays.hashCode(object.values);
            }

            public boolean equals(PredicatePositive o1, PredicatePositive o2) {
                if (o1.property == o2.property) {
                    if (o1.values.length != o2.values.length) {
                        return false;
                    }
                    for (int i = 0; i < o1.values.length; ++i) {
                        if (o1.values[i] == o2.values[i]) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    public static final class SingletonPredicatePositive
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object value;

        protected SingletonPredicatePositive(IProperty<?> property, Object value) {
            this.property = property;
            this.value = value;
        }

        public boolean apply(@Nullable IBlockState state) {
            return state != null && state.func_177229_b(this.property).equals(this.value);
        }

        public static final class HashingStrategy
        implements gnu.trove.strategy.HashingStrategy<SingletonPredicatePositive> {
            public int computeHashCode(SingletonPredicatePositive object) {
                return 31 * object.property.hashCode() + (object.value != null ? object.value.hashCode() : 0);
            }

            public boolean equals(SingletonPredicatePositive o1, SingletonPredicatePositive o2) {
                return o1.property == o2.property && o1.value == o2.value;
            }
        }
    }

    public static final class HashingStrategy
    implements gnu.trove.strategy.HashingStrategy<FoamyConditionPropertyValue> {
        public int computeHashCode(FoamyConditionPropertyValue object) {
            return 31 * object.field_188125_d.hashCode() + object.field_188126_e.hashCode();
        }

        public boolean equals(FoamyConditionPropertyValue o1, FoamyConditionPropertyValue o2) {
            return o2.field_188125_d.equals(o1.field_188125_d) && o2.field_188126_e.equals(o1.field_188126_e);
        }
    }
}

