/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import melonslise.locks.Locks;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LockPickItem
extends Item {
    public static final ITextComponent TOO_COMPLEX_MESSAGE = new TextComponentTranslation("locks.status.too_complex", new Object[0]);
    public static final String KEY_STRENGTH = "Strength";
    public final float strength;

    public LockPickItem(float strength) {
        this.strength = strength;
    }

    public static float getStrength(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return ((LockPickItem)stack.func_77973_b()).strength;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b(KEY_STRENGTH)) {
            return ((LockPickItem)stack.func_77973_b()).strength;
        }
        return nbt.func_74760_g(KEY_STRENGTH);
    }

    public static boolean canPick(ItemStack stack, int cmp) {
        return LockPickItem.getStrength(stack) > (float)cmp * 0.25f;
    }

    public static boolean canPick(ItemStack stack, Lockable lkb) {
        return LockPickItem.canPick(stack, EnchantmentHelper.func_77506_a((Enchantment)LocksEnchantments.COMPLEXITY, (ItemStack)lkb.stack));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        List matching = LocksUtil.intersecting(world, pos).filter(LocksPredicates.LOCKED).collect(Collectors.toList());
        if (matching.isEmpty()) {
            return EnumActionResult.PASS;
        }
        Lockable lkb = (Lockable)matching.get(0);
        if (!LockPickItem.canPick(player.func_184586_b(hand), lkb)) {
            if (world.field_72995_K) {
                player.func_146105_b(TOO_COMPLEX_MESSAGE, true);
            }
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        player.openGui((Object)Locks.instance, 1, world, lkb.networkID, hand == EnumHand.MAIN_HAND ? 0 : 1, 0);
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        float strength = LocksUtil.hasKey(stack, KEY_STRENGTH) ? stack.func_77978_p().func_74760_g(KEY_STRENGTH) : this.strength;
        TextComponentTranslation txt = new TextComponentTranslation("locks.tooltip.strength", new Object[]{ItemStack.field_111284_a.format(strength)});
        txt.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        lines.add(txt.func_150254_d());
    }
}

