/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import com.google.common.math.Quantiles;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.worldgen.WorldGenWizardryStructure;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public abstract class WorldGenSurfaceStructure
extends WorldGenWizardryStructure {
    private static final float MAX_LIQUID_FRACTION = 0.4f;

    @Override
    @Nullable
    protected BlockPos attemptPosition(Template template, PlacementSettings settings, Random random, World world, int chunkX, int chunkZ, String structureFile) {
        Integer startingHeight;
        BlockPos size = template.func_186257_a(settings.func_186215_c());
        BlockPos origin = new BlockPos((chunkX << 4) + random.nextInt(16) + 8 - size.func_177958_n() / 2, 0, (chunkZ << 4) + random.nextInt(16) + 8 - size.func_177952_p() / 2);
        BlockPos centre = world.func_175672_r(new BlockPos((Vec3i)origin.func_177982_a(size.func_177958_n() / 2, 0, size.func_177952_p() / 2)));
        if (centre.func_177956_o() >= world.func_72940_L()) {
            centre = new BlockPos(centre.func_177958_n(), random.nextInt(world.func_72940_L()), centre.func_177952_p());
        }
        if ((startingHeight = BlockUtils.getNearestSurface(world, centre, EnumFacing.UP, 32, true, BlockUtils.SurfaceCriteria.COLLIDABLE_IGNORING_TREES)) == null) {
            return null;
        }
        if (Wizardry.settings.fastWorldgen) {
            BlockPos result = origin.func_177981_b(startingHeight.intValue());
            return world.func_180495_p(new BlockPos(centre.func_177958_n(), startingHeight + 1, centre.func_177952_p())).func_185904_a().func_76224_d() ? null : result;
        }
        int[] floorHeights = new int[size.func_177958_n() * size.func_177952_p()];
        int liquidCount = 0;
        for (int i = 0; i < floorHeights.length; ++i) {
            BlockPos pos = origin.func_177982_a(i / size.func_177952_p(), 0, i % size.func_177952_p());
            Integer floor = BlockUtils.getNearestSurface(world, pos.func_177981_b(startingHeight.intValue()), EnumFacing.UP, 32, true, BlockUtils.SurfaceCriteria.COLLIDABLE_IGNORING_TREES);
            int n = floorHeights[i] = floor == null ? 0 : floor;
            if (world.func_180495_p(pos.func_177981_b(floorHeights[i])).func_185904_a().func_76224_d()) {
                ++liquidCount;
            }
            if (!((float)liquidCount > (float)floorHeights.length * 0.4f)) continue;
            return null;
        }
        int medianFloorHeight = MathHelper.func_76128_c((double)Quantiles.median().compute(floorHeights));
        for (int i = 0; i < floorHeights.length; ++i) {
            int orthogonalDist = Math.max(Math.abs(i / size.func_177952_p() - size.func_177958_n() / 2), Math.abs(i % size.func_177952_p() - size.func_177952_p() / 2));
            if (Math.abs(floorHeights[i] - medianFloorHeight) <= Math.max(2, orthogonalDist)) continue;
            return null;
        }
        return origin.func_177981_b(medianFloorHeight - 1);
    }

    @Override
    protected void postGenerate(Random random, World world, PlacementSettings settings) {
        if (!Wizardry.settings.fastWorldgen) {
            WorldGenSurfaceStructure.removeFloatingTrees(world, settings.func_186213_g(), random);
        }
    }

    protected static void removeFloatingTrees(World world, StructureBoundingBox boundingBox, Random random) {
        int y;
        boolean changed = true;
        for (y = boundingBox.field_78895_b; changed && y < world.func_72800_K(); ++y) {
            if (y > boundingBox.field_78894_e + 1) {
                changed = false;
            }
            for (int x = boundingBox.field_78897_a; x <= boundingBox.field_78893_d; ++x) {
                for (int z = boundingBox.field_78896_c; z <= boundingBox.field_78892_f; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    Block below = world.func_180495_p(pos.func_177977_b()).func_177230_c();
                    if (!(block instanceof BlockLog) || below == Blocks.field_150349_c || below == Blocks.field_150346_d || BlockUtils.isTreeBlock(world, pos.func_177977_b())) continue;
                    world.func_175698_g(pos);
                    changed = true;
                }
            }
        }
        int border = 8;
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        for (int x = boundingBox.field_78897_a - border; x <= boundingBox.field_78893_d + border; ++x) {
            for (int y1 = boundingBox.field_78895_b - border; y1 <= y + border; ++y1) {
                for (int z = boundingBox.field_78896_c - border; z <= boundingBox.field_78892_f + border; ++z) {
                    BlockPos pos = new BlockPos(x, y1, z);
                    if (!world.func_175667_e(pos) || !(world.func_180495_p(pos).func_177230_c() instanceof BlockLeaves)) continue;
                    leaves.add(pos);
                }
            }
        }
        for (int i = 0; i < 16; ++i) {
            leaves.forEach(p -> world.func_180495_p(p).func_177230_c().func_180650_b(world, p, world.func_180495_p(p), random));
        }
        AxisAlignedBB box = new AxisAlignedBB((double)boundingBox.field_78897_a, (double)boundingBox.field_78895_b, (double)boundingBox.field_78896_c, (double)boundingBox.field_78893_d, (double)y, (double)boundingBox.field_78892_f).func_186662_g((double)border);
        world.func_72872_a(EntityItem.class, box).forEach(Entity::func_70106_y);
    }
}

