/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.worldgen;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockPedestal;
import electroblob.wizardry.block.BlockRunestone;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.integration.antiqueatlas.WizardryAntiqueAtlasIntegration;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityShrineCore;
import electroblob.wizardry.worldgen.WorldGenSurfaceStructure;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.lang3.ArrayUtils;

public class WorldGenShrine
extends WorldGenSurfaceStructure {
    private static final String CORE_DATA_BLOCK_TAG = "core";

    @Override
    public String getStructureName() {
        return "shrine";
    }

    @Override
    public long getRandomSeedModifier() {
        return 17502749L;
    }

    @Override
    public boolean canGenerate(Random random, World world, int chunkX, int chunkZ) {
        return ArrayUtils.contains((int[])Wizardry.settings.shrineDimensions, (int)world.field_73011_w.getDimension()) && Wizardry.settings.shrineRarity > 0 && random.nextInt(Wizardry.settings.shrineRarity) == 0;
    }

    @Override
    public ResourceLocation getStructureFile(Random random) {
        return Wizardry.settings.shrineFiles[random.nextInt(Wizardry.settings.shrineFiles.length)];
    }

    @Override
    public void spawnStructure(Random random, World world, BlockPos origin, Template template, PlacementSettings settings, ResourceLocation structureFile) {
        Element element = Element.values()[1 + random.nextInt(Element.values().length - 1)];
        ITemplateProcessor processor = (w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockRunestone ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a(BlockRunestone.ELEMENT, (Comparable)((Object)element)), i.field_186244_c) : i;
        template.func_189960_a(world, origin, processor, settings, 18);
        WizardryAntiqueAtlasIntegration.markShrine(world, origin.func_177958_n(), origin.func_177952_p());
        Map dataBlocks = template.func_186258_a(origin, settings);
        for (Map.Entry entry : dataBlocks.entrySet()) {
            if (((String)entry.getValue()).equals(CORE_DATA_BLOCK_TAG)) {
                world.func_175656_a((BlockPos)entry.getKey(), WizardryBlocks.runestone_pedestal.func_176223_P().func_177226_a(BlockPedestal.ELEMENT, (Comparable)((Object)element)).func_177226_a((IProperty)BlockPedestal.NATURAL, (Comparable)Boolean.valueOf(true)));
                TileEntity core = world.func_175625_s((BlockPos)entry.getKey());
                TileEntity container = world.func_175625_s(((BlockPos)entry.getKey()).func_177984_a());
                if (container != null) {
                    container.getTileData().func_186854_a("arcaneLockOwner", new UUID(0L, 0L));
                    container.func_70296_d();
                    BlockPos chestPos = ((BlockPos)entry.getKey()).func_177984_a();
                    IBlockState blockState = world.func_180495_p(chestPos);
                    world.markAndNotifyBlock(chestPos, null, blockState, blockState, 3);
                    world.func_184138_a(chestPos, blockState, blockState, 3);
                    if (container instanceof TileEntityChest) {
                        TileEntityChest chest = (TileEntityChest)container;
                        chest.func_189404_a(new ResourceLocation("ebwizardry", "chests/shrine"), world.field_73012_v.nextLong());
                    }
                    if (core instanceof TileEntityShrineCore) {
                        ((TileEntityShrineCore)core).linkContainer(container);
                        ((TileEntityShrineCore)core).setShrineElement(element);
                        continue;
                    }
                    Wizardry.logger.info("What?!");
                    continue;
                }
                Wizardry.logger.info("Expected chest or other container at {} in structure {}, found no tile entity", entry.getKey(), (Object)structureFile);
                continue;
            }
            Wizardry.logger.info("Unrecognised data block value {} in structure {}", entry.getValue(), (Object)structureFile);
        }
    }
}

