/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.util;

import electroblob.wizardry.Settings;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCactus;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static IBlockState copyState(Block block, IBlockState source) {
        IBlockState state = block.func_176223_P();
        for (IProperty property : source.func_177227_a()) {
            state = state.func_177226_a(property, (Comparable)source.func_177228_b().get((Object)property));
        }
        return state;
    }

    public static int getLightLevel(World world, BlockPos pos) {
        int i = world.func_175671_l(pos);
        if (world.func_72911_I()) {
            int j = world.func_175657_ab();
            world.func_175692_b(10);
            i = world.func_175671_l(pos);
            world.func_175692_b(j);
        }
        return i;
    }

    public static boolean canBlockBeReplaced(World world, BlockPos pos, boolean excludeLiquids) {
        return !(!world.func_175623_d(new BlockPos((Vec3i)pos)) && !world.func_180495_p(pos).func_185904_a().func_76222_j() || excludeLiquids && world.func_180495_p(pos).func_185904_a().func_76224_d());
    }

    public static boolean canBlockBeReplaced(World world, BlockPos pos) {
        return BlockUtils.canBlockBeReplaced(world, pos, false);
    }

    public static boolean isBlockUnbreakable(World world, BlockPos pos) {
        return !world.func_175623_d(new BlockPos((Vec3i)pos)) && world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f;
    }

    public static IBlockState getBlockEntityIsStandingOn(Entity entity) {
        BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), (int)entity.field_70163_u - 1, MathHelper.func_76128_c((double)entity.field_70161_v));
        return entity.field_70170_p.func_180495_p(pos);
    }

    public static List<BlockPos> getBlockSphere(BlockPos centre, double radius) {
        ArrayList<BlockPos> sphere = new ArrayList<BlockPos>((int)Math.pow(radius, 3.0));
        int i = -((int)radius);
        while ((double)i <= radius) {
            float r1 = MathHelper.func_76133_a((double)(radius * radius - (double)(i * i)));
            int j = -((int)r1);
            while ((float)j <= r1) {
                float r2 = MathHelper.func_76133_a((double)(radius * radius - (double)(i * i) - (double)(j * j)));
                int k = -((int)r2);
                while ((float)k <= r2) {
                    sphere.add(centre.func_177982_a(i, j, k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return sphere;
    }

    public static boolean canPlaceBlock(@Nullable Entity placer, World world, BlockPos pos) {
        if (world.field_72995_K) {
            Wizardry.logger.warn("BlockUtils#canPlaceBlock called from the client side! Blocks should be modified server-side only");
            return true;
        }
        if (!EntityUtils.canDamageBlocks(placer, world)) {
            return false;
        }
        if (world.func_189509_E(pos)) {
            return false;
        }
        if (placer instanceof EntityPlayer && !world.func_175660_a((EntityPlayer)placer, pos)) {
            return false;
        }
        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (ForgeEventFactory.onBlockPlace((Entity)placer, (BlockSnapshot)snapshot, (EnumFacing)EnumFacing.UP).isCanceled()) {
            return false;
        }
        return !(placer instanceof EntityPlayer) || !ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)((EntityPlayer)placer), (BlockSnapshot)snapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled();
    }

    public static boolean canBreakBlock(@Nullable Entity breaker, World world, BlockPos pos) {
        return BlockUtils.checkBlockBreakXP(breaker, world, pos) >= 0;
    }

    public static int checkBlockBreakXP(@Nullable Entity breaker, World world, BlockPos pos) {
        if (world.field_72995_K) {
            Wizardry.logger.warn("BlockUtils#checkBlockBreakXP called from the client side! Blocks should be modified server-side only");
            return 0;
        }
        if (!EntityUtils.canDamageBlocks(breaker, world)) {
            return -1;
        }
        if (world.func_189509_E(pos)) {
            return -1;
        }
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        if (breaker instanceof EntityPlayer ? !world.func_175660_a((EntityPlayer)breaker, pos) : breaker == null && !world.func_175660_a((EntityPlayer)fakeplayer, pos)) {
            return -1;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockAccess)world, pos, breaker)) {
            return -1;
        }
        if (breaker instanceof EntityLiving && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)((EntityLivingBase)breaker), (BlockPos)pos, (IBlockState)state)) {
            return -1;
        }
        if (breaker instanceof EntityPlayer && ForgeEventFactory.getBreakSpeed((EntityPlayer)((EntityPlayer)breaker), (IBlockState)state, (float)1.0f, (BlockPos)pos) < 0.0f) {
            return -1;
        }
        if (breaker == null && MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)fakeplayer))) {
            return -1;
        }
        int xp = 0;
        if (breaker instanceof EntityPlayerMP) {
            xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)breaker).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)breaker), (BlockPos)pos);
        }
        return xp;
    }

    public static boolean isTreeBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockLog || block instanceof BlockCactus || block.isLeaves(world.func_180495_p(pos), (IBlockAccess)world, pos) || block.isFoliage((IBlockAccess)world, pos) || Settings.containsMetaBlock(Wizardry.settings.treeBlocks, world.func_180495_p(pos));
    }

    public static BlockPlanks.EnumType getBiomeWoodVariant(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            return BlockPlanks.EnumType.SPRUCE;
        }
        if (biome == Biomes.field_150583_P || biome == Biomes.field_150582_Q) {
            return BlockPlanks.EnumType.BIRCH;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return BlockPlanks.EnumType.JUNGLE;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA)) {
            return BlockPlanks.EnumType.ACACIA;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
            return BlockPlanks.EnumType.DARK_OAK;
        }
        return BlockPlanks.EnumType.OAK;
    }

    public static BlockPos getConnectedChest(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockChest) {
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                BlockPos pos1 = pos.func_177972_a(enumfacing);
                if (world.func_180495_p(pos1).func_177230_c() != block) continue;
                return pos1;
            }
        }
        return null;
    }

    public static boolean isWaterSource(IBlockState state) {
        return state.func_185904_a() == Material.field_151586_h && (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    public static boolean isLavaSource(IBlockState state) {
        return state.func_185904_a() == Material.field_151587_i && (state.func_177230_c() == Blocks.field_150353_l || state.func_177230_c() == Blocks.field_150356_k) && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    public static boolean freeze(World world, BlockPos pos, boolean freezeLava) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (BlockUtils.isWaterSource(state)) {
            world.func_175656_a(pos, Blocks.field_150432_aD.func_176223_P());
        } else if (freezeLava && BlockUtils.isLavaSource(state)) {
            world.func_175656_a(pos, Blocks.field_150343_Z.func_176223_P());
        } else if (freezeLava && (block == Blocks.field_150353_l || block == Blocks.field_150356_k)) {
            world.func_175656_a(pos, Blocks.field_150347_e.func_176223_P());
        } else if (BlockUtils.canBlockBeReplaced(world, pos.func_177984_a()) && Blocks.field_150431_aC.func_176196_c(world, pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
        } else {
            return false;
        }
        return true;
    }

    @Nullable
    public static Integer getNearestSurface(World world, BlockPos pos, EnumFacing direction, int range, boolean doubleSided, SurfaceCriteria criteria) {
        int i;
        Integer surface = null;
        int currentBest = Integer.MAX_VALUE;
        int n = i = doubleSided ? -range : 0;
        while (i <= range && i < currentBest) {
            BlockPos testPos = pos.func_177967_a(direction, i);
            if (criteria.test(world, testPos, direction)) {
                surface = (int)GeometryUtils.component(GeometryUtils.getFaceCentre(testPos, direction), direction.func_176740_k());
                currentBest = Math.abs(i);
            }
            ++i;
        }
        return surface;
    }

    @Nullable
    public static Integer getNearestFloor(World world, BlockPos pos, int range) {
        return BlockUtils.getNearestSurface(world, pos, EnumFacing.UP, range, true, SurfaceCriteria.COLLIDABLE);
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(Entity entity, int horizontalRange, int verticalRange) {
        World world = entity.field_70170_p;
        BlockPos origin = new BlockPos(entity);
        return BlockUtils.findNearbyFloorSpace(world, origin, horizontalRange, verticalRange);
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(World world, BlockPos origin, int horizontalRange, int verticalRange) {
        return BlockUtils.findNearbyFloorSpace(world, origin, horizontalRange, verticalRange, true);
    }

    @Nullable
    public static BlockPos findNearbyFloorSpace(World world, BlockPos origin, int horizontalRange, int verticalRange, boolean lineOfSight) {
        ArrayList<BlockPos> possibleLocations = new ArrayList<BlockPos>();
        Vec3d centre = GeometryUtils.getCentre(origin);
        for (int x = -horizontalRange; x <= horizontalRange; ++x) {
            for (int z = -horizontalRange; z <= horizontalRange; ++z) {
                RayTraceResult rayTrace;
                Integer y = BlockUtils.getNearestFloor(world, origin.func_177982_a(x, 0, z), verticalRange);
                if (y == null) continue;
                BlockPos location = new BlockPos(origin.func_177958_n() + x, y.intValue(), origin.func_177952_p() + z);
                if (lineOfSight && (rayTrace = world.func_147447_a(centre, GeometryUtils.getCentre(location), false, true, false)) != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK) continue;
                possibleLocations.add(location);
            }
        }
        if (possibleLocations.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleLocations.get(world.field_73012_v.nextInt(possibleLocations.size()));
    }

    @FunctionalInterface
    public static interface SurfaceCriteria {
        public static final SurfaceCriteria COLLIDABLE = SurfaceCriteria.basedOn((IBlockState b) -> b.func_185904_a().func_76230_c());
        public static final SurfaceCriteria BUILDABLE = (world, pos, side) -> world.isSideSolid(pos, side) && world.func_180495_p(pos.func_177972_a(side)).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177972_a(side));
        public static final SurfaceCriteria SOLID_LIQUID_TO_AIR = (world, pos, side) -> world.func_180495_p(pos).func_185904_a().func_76224_d() || world.isSideSolid(pos, side) && world.func_175623_d(pos.func_177972_a(side));
        public static final SurfaceCriteria NOT_AIR_TO_AIR = SurfaceCriteria.basedOn(World::func_175623_d).flip();
        public static final SurfaceCriteria COLLIDABLE_IGNORING_TREES = SurfaceCriteria.basedOn((World world, BlockPos pos) -> world.func_180495_p(pos).func_185904_a().func_76230_c() && !BlockUtils.isTreeBlock(world, pos));

        public boolean test(World var1, BlockPos var2, EnumFacing var3);

        default public SurfaceCriteria flip() {
            return (world, pos, side) -> this.test(world, pos.func_177972_a(side), side.func_176734_d());
        }

        public static SurfaceCriteria basedOn(BiPredicate<World, BlockPos> condition) {
            return (world, pos, side) -> condition.test(world, pos) && !condition.test(world, pos.func_177972_a(side));
        }

        public static SurfaceCriteria basedOn(Predicate<IBlockState> condition) {
            return (world, pos, side) -> condition.test(world.func_180495_p(pos)) && !condition.test(world.func_180495_p(pos.func_177972_a(side)));
        }
    }
}

