/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class SpellConjuration
extends Spell {
    public static final String ITEM_LIFETIME = "item_lifetime";
    protected final Item item;

    public SpellConjuration(String name, Item item) {
        this("ebwizardry", name, item);
    }

    public SpellConjuration(String modID, String name, Item item) {
        super(modID, name, SpellActions.IMBUE, false);
        this.item = item;
        this.addProperties(ITEM_LIFETIME);
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (this.conjureItem(caster, modifiers)) {
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
            }
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        for (int i = 0; i < 10; ++i) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create(ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(0.7f, 0.9f, 1.0f).spawn(world);
        }
    }

    protected boolean conjureItem(EntityPlayer caster, SpellModifiers modifiers) {
        ItemStack stack = new ItemStack(this.item);
        if (InventoryUtils.doesPlayerHaveItem(caster, this.item)) {
            return false;
        }
        IConjuredItem.setDurationMultiplier(stack, modifiers.get(WizardryItems.duration_upgrade));
        IConjuredItem.setDamageMultiplier(stack, modifiers.get("potency"));
        this.addItemExtras(caster, stack, modifiers);
        if (caster.func_184614_ca().func_190926_b()) {
            caster.func_184611_a(EnumHand.MAIN_HAND, stack);
        } else if (!caster.field_71071_by.func_70441_a(stack)) {
            return false;
        }
        return true;
    }

    protected void addItemExtras(EntityPlayer caster, ItemStack stack, SpellModifiers modifiers) {
    }
}

