/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class SpellAreaEffect
extends Spell {
    protected boolean targetAllies = false;
    protected boolean alwaysSucceed = false;
    protected float particleDensity = 0.65f;

    public SpellAreaEffect(String name, EnumAction action, boolean continuous) {
        this("ebwizardry", name, action, continuous);
    }

    public SpellAreaEffect(String modID, String name, EnumAction action, boolean continuous) {
        super(modID, name, action, continuous);
        this.addProperties("effect_radius");
        this.npcSelector((e, o) -> true);
    }

    public SpellAreaEffect targetAllies(boolean targetAllies) {
        this.targetAllies = targetAllies;
        return this;
    }

    public SpellAreaEffect alwaysSucceed(boolean alwaysSucceed) {
        this.alwaysSucceed = alwaysSucceed;
        return this;
    }

    public SpellAreaEffect particleDensity(float particleDensity) {
        this.particleDensity = particleDensity;
        return this;
    }

    @Override
    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean result = this.findAndAffectEntities(world, caster.func_174791_d(), (EntityLivingBase)caster, ticksInUse, modifiers);
        if (result) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return result;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        boolean result = this.findAndAffectEntities(world, caster.func_174791_d(), (EntityLivingBase)caster, ticksInUse, modifiers);
        if (result) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return result;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        boolean result = this.findAndAffectEntities(world, new Vec3d(x, y, z), null, ticksInUse, modifiers);
        if (result) {
            this.playSound(world, x, y, z, ticksInUse, -1, modifiers, new String[0]);
        }
        return result;
    }

    protected boolean findAndAffectEntities(World world, Vec3d origin, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List<EntityLivingBase> targets = EntityUtils.getLivingWithinRadius(radius, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, world);
        if (this.targetAllies) {
            targets.removeIf(target -> target != caster && !AllyDesignationSystem.isAllied(caster, target));
        } else {
            targets.removeIf(target -> !AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target));
        }
        targets.sort(Comparator.comparingDouble(e -> e.func_70092_e(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c)));
        boolean result = this.alwaysSucceed;
        int i = 0;
        for (EntityLivingBase target2 : targets) {
            if (!this.affectEntity(world, origin, caster, target2, i++, ticksInUse, modifiers)) continue;
            result = true;
        }
        if (world.field_72995_K) {
            this.spawnParticleEffect(world, origin, radius, caster, modifiers);
        }
        return result;
    }

    protected abstract boolean affectEntity(World var1, Vec3d var2, @Nullable EntityLivingBase var3, EntityLivingBase var4, int var5, int var6, SpellModifiers var7);

    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        int particleCount = (int)Math.round((double)this.particleDensity * Math.PI * radius * radius);
        for (int i = 0; i < particleCount; ++i) {
            double r = 1.0 + world.field_73012_v.nextDouble() * (radius - 1.0);
            float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            this.spawnParticle(world, origin.field_72450_a + r * (double)MathHelper.func_76134_b((float)angle), origin.field_72448_b, origin.field_72449_c + r * (double)MathHelper.func_76126_a((float)angle));
        }
    }

    protected void spawnParticle(World world, double x, double y, double z) {
    }
}

