/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConjuration;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class Flamecatcher
extends SpellConjuration {
    public static final String SHOT_COUNT = "shot_count";
    public static final String SHOTS_REMAINING_NBT_KEY = "shotsRemaining";

    public Flamecatcher() {
        super("flamecatcher", WizardryItems.flamecatcher);
        this.addProperties("range", SHOT_COUNT, "damage", "burn_duration");
    }

    @Override
    protected void addItemExtras(EntityPlayer caster, ItemStack stack, SpellModifiers modifiers) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(SHOTS_REMAINING_NBT_KEY, (int)((float)this.getProperty(SHOT_COUNT).intValue() * modifiers.get("potency")));
    }

    @Override
    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        ParticleBuilder.create(ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(16739584).spawn(world);
        for (int i = 0; i < 10; ++i) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

