/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Firestorm
extends SpellAreaEffect {
    public Firestorm() {
        super("firestorm", SpellActions.POINT_DOWN, false);
        this.soundValues(2.0f, 1.0f, 0.0f);
        this.alwaysSucceed(true);
        this.addProperties("burn_duration");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.burnNearbyBlocks(world, caster.func_174791_d(), (EntityLivingBase)caster, modifiers);
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.burnNearbyBlocks(world, caster.func_174791_d(), (EntityLivingBase)caster, modifiers);
        return super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        this.burnNearbyBlocks(world, new Vec3d(x, y, z), null, modifiers);
        return super.cast(world, x, y, z, direction, ticksInUse, duration, modifiers);
    }

    @Override
    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        target.func_70015_d(this.getProperty("burn_duration").intValue());
        return true;
    }

    @Override
    protected void spawnParticleEffect(World world, Vec3d origin, double radius, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        double speed;
        float r;
        int i;
        for (i = 0; i < 100; ++i) {
            r = world.field_73012_v.nextFloat();
            speed = 0.02 / (double)r * (1.0 + world.field_73012_v.nextDouble());
            ParticleBuilder.create(ParticleBuilder.Type.MAGIC_FIRE).pos(origin.field_72450_a, origin.field_72448_b + world.field_73012_v.nextDouble() * 3.0, origin.field_72449_c).vel(0.0, 0.0, 0.0).scale(2.0f).time(40 + world.field_73012_v.nextInt(10)).spin(world.field_73012_v.nextDouble() * (radius - 0.5) + 0.5, speed).spawn(world);
        }
        for (i = 0; i < 60; ++i) {
            r = world.field_73012_v.nextFloat();
            speed = 0.02 / (double)r * (1.0 + world.field_73012_v.nextDouble());
            ParticleBuilder.create(ParticleBuilder.Type.CLOUD).pos(origin.field_72450_a, origin.field_72448_b + world.field_73012_v.nextDouble() * 2.5, origin.field_72449_c).clr(DrawingUtils.mix(DrawingUtils.mix(16760320, 16725504, r / 0.6f), 0x222222, (r - 0.6f) / 0.4f)).spin((double)r * (radius - 1.0) + 0.5, speed).spawn(world);
        }
    }

    private void burnNearbyBlocks(World world, Vec3d origin, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, world)) {
            double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            for (int i = -((int)radius); i <= (int)radius; ++i) {
                for (int j = -((int)radius); j <= (int)radius; ++j) {
                    BlockPos pos = new BlockPos(origin).func_177982_a(i, 0, j);
                    Integer y = BlockUtils.getNearestSurface(world, new BlockPos((Vec3i)pos), EnumFacing.UP, (int)radius, true, BlockUtils.SurfaceCriteria.NOT_AIR_TO_AIR);
                    if (y == null) continue;
                    pos = new BlockPos(pos.func_177958_n(), y.intValue(), pos.func_177952_p());
                    double dist = origin.func_72438_d(new Vec3d(origin.field_72450_a + (double)i, (double)y.intValue(), origin.field_72449_c + (double)j));
                    if (y == -1 || !((double)world.field_73012_v.nextInt((int)(dist * 2.0) + 1) < radius) || !(dist < radius) || !(dist > 1.5) || !BlockUtils.canPlaceBlock((Entity)caster, world, pos)) continue;
                    world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }
}

