/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.spell;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Banish
extends SpellRay {
    public static final String MINIMUM_TELEPORT_DISTANCE = "minimum_teleport_distance";
    public static final String MAXIMUM_TELEPORT_DISTANCE = "maximum_teleport_distance";

    public Banish() {
        super("banish", SpellActions.POINT, false);
        this.addProperties(MINIMUM_TELEPORT_DISTANCE, MAXIMUM_TELEPORT_DISTANCE);
    }

    @Override
    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)target;
            double minRadius = this.getProperty(MINIMUM_TELEPORT_DISTANCE).doubleValue();
            double maxRadius = this.getProperty(MAXIMUM_TELEPORT_DISTANCE).doubleValue();
            double radius = (minRadius + world.field_73012_v.nextDouble() * maxRadius - minRadius) * (double)modifiers.get(WizardryItems.blast_upgrade);
            this.teleport(entity, world, radius);
        }
        return true;
    }

    @Override
    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    @Override
    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.PORTAL, x, y - 0.5, z, 0.0, 0.0, 0.0, new int[0]);
        ParticleBuilder.create(ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(0.2f, 0.0f, 0.2f).spawn(world);
    }

    public boolean teleport(EntityLivingBase entity, World world, double radius) {
        float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        int x = MathHelper.func_76128_c((double)(entity.field_70165_t + (double)MathHelper.func_76126_a((float)angle) * radius));
        int z = MathHelper.func_76128_c((double)(entity.field_70161_v - (double)MathHelper.func_76134_b((float)angle) * radius));
        Integer y = BlockUtils.getNearestFloor(world, new BlockPos(x, (int)entity.field_70163_u, z), (int)radius);
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx1 = entity.field_70165_t;
                double dy1 = entity.field_70163_u + (double)(entity.field_70131_O * world.field_73012_v.nextFloat());
                double dz1 = entity.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx1, dy1, dz1, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
            if (entity instanceof EntityPlayer) {
                Wizardry.proxy.playBlinkEffect((EntityPlayer)entity);
            }
        }
        if (y != null) {
            if (!world.func_180495_p(new BlockPos(x, y.intValue(), z)).func_185904_a().func_76230_c()) {
                Integer n = y;
                Integer n2 = y = Integer.valueOf(y - 1);
            }
            if (world.func_180495_p(new BlockPos(x, y + 1, z)).func_185904_a().func_76230_c() || world.func_180495_p(new BlockPos(x, y + 2, z)).func_185904_a().func_76230_c()) {
                return false;
            }
            if (!world.field_72995_K) {
                entity.func_70634_a((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            this.playSound(world, entity, 0, -1, new SpellModifiers(), new String[0]);
        }
        return true;
    }
}

