/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.misc;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class WizardryPathFinder {
    private final PathHeap path = new PathHeap();
    private final Set<PathPoint> closedSet = Sets.newHashSet();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;

    public WizardryPathFinder(NodeProcessor processor) {
        this.nodeProcessor = processor;
    }

    @Nullable
    public Path findPath(IBlockAccess world, EntityLiving entity, BlockPos destination, float range) {
        return this.findPath(world, entity, (float)destination.func_177958_n() + 0.5f, (float)destination.func_177956_o() + 0.5f, (float)destination.func_177952_p() + 0.5f, range);
    }

    @Nullable
    private Path findPath(IBlockAccess world, EntityLiving entity, double x, double y, double z, float range) {
        this.path.func_75848_a();
        this.nodeProcessor.func_186315_a(world, entity);
        PathPoint pathpoint = this.nodeProcessor.func_186318_b();
        PathPoint pathpoint1 = this.nodeProcessor.func_186325_a(x, y, z);
        Path path = this.findPath(pathpoint, pathpoint1, range);
        this.nodeProcessor.func_176163_a();
        return path;
    }

    @Nullable
    private Path findPath(PathPoint start, PathPoint end, float range) {
        start.field_75836_e = 0.0f;
        start.field_75834_g = start.field_75833_f = start.func_186281_c(end);
        this.path.func_75848_a();
        this.closedSet.clear();
        this.path.func_75849_a(start);
        PathPoint pathpoint = start;
        int i = 0;
        while (!this.path.func_75845_e() && ++i < 5000) {
            PathPoint pathpoint1 = this.path.func_75844_c();
            if (pathpoint1.equals((Object)end)) {
                pathpoint = end;
                break;
            }
            if (pathpoint1.func_186281_c(end) < pathpoint.func_186281_c(end)) {
                pathpoint = pathpoint1;
            }
            pathpoint1.field_75842_i = true;
            int j = this.nodeProcessor.func_186320_a(this.pathOptions, pathpoint1, end, range);
            for (int k = 0; k < j; ++k) {
                PathPoint pathpoint2 = this.pathOptions[k];
                float f = pathpoint1.func_186281_c(pathpoint2);
                pathpoint2.field_186284_j = pathpoint1.field_186284_j + f;
                pathpoint2.field_186285_k = f + pathpoint2.field_186286_l;
                float f1 = pathpoint1.field_75836_e + pathpoint2.field_186285_k;
                if (!(pathpoint2.field_186284_j < range) || pathpoint2.func_75831_a() && !(f1 < pathpoint2.field_75836_e)) continue;
                pathpoint2.field_75841_h = pathpoint1;
                pathpoint2.field_75836_e = f1;
                pathpoint2.field_75833_f = pathpoint2.func_186281_c(end) + pathpoint2.field_186286_l;
                if (pathpoint2.func_75831_a()) {
                    this.path.func_75850_a(pathpoint2, pathpoint2.field_75836_e + pathpoint2.field_75833_f);
                    continue;
                }
                pathpoint2.field_75834_g = pathpoint2.field_75836_e + pathpoint2.field_75833_f;
                this.path.func_75849_a(pathpoint2);
            }
        }
        if (pathpoint == start) {
            return null;
        }
        Path path = this.createEntityPath(start, pathpoint);
        return path;
    }

    private Path createEntityPath(PathPoint start, PathPoint end) {
        int i = 1;
        PathPoint pathpoint = end;
        while (pathpoint.field_75841_h != null) {
            ++i;
            pathpoint = pathpoint.field_75841_h;
        }
        PathPoint[] points = new PathPoint[i];
        PathPoint pathpoint1 = end;
        points[--i] = end;
        while (pathpoint1.field_75841_h != null) {
            pathpoint1 = pathpoint1.field_75841_h;
            points[--i] = pathpoint1;
        }
        return new Path(points);
    }
}

