/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.item;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.projectile.EntityFlamecatcherArrow;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.InventoryUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlamecatcher
extends ItemBow
implements IConjuredItem {
    public static final float DRAW_TIME = 10.0f;

    public ItemFlamecatcher() {
        this.func_77656_e(1200);
        this.setNoRepair();
        this.func_77637_a(null);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack.func_77973_b() == ItemFlamecatcher.this ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 10.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.addAnimationPropertyOverrides();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxDamageFromNBT(stack, Spells.flamecatcher);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return IConjuredItem.getTimerBarColour(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return false;
        }
        return super.shouldCauseBlockBreakReset(oldStack, newStack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        int damage = stack.func_77952_i();
        if (damage > stack.func_77958_k()) {
            InventoryUtils.replaceItemInInventory(entity, slot, stack, ItemStack.field_190927_a);
        }
        stack.func_77964_b(damage + 1);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Wizardry.proxy.getConjuredBowDurability(stack);
    }

    public double getDefaultDurabilityForDisplay(ItemStack stack) {
        return super.getDurabilityForDisplay(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int shotsLeft = stack.func_77978_p().func_74762_e("shotsRemaining");
        if (shotsLeft == 0) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)stack, (World)world, (EntityPlayer)player, (EnumHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            stack.func_77964_b(stack.func_77952_i() + (this.func_77626_a(stack) - timeLeft));
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            int charge = this.func_77626_a(stack) - timeLeft;
            if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (EntityPlayer)((EntityPlayer)entity), (int)charge, (boolean)true)) < 0) {
                return;
            }
            float velocity = (float)charge / 10.0f;
            if ((velocity = (velocity * velocity + velocity * 2.0f) / 3.0f) > 1.0f) {
                velocity = 1.0f;
            }
            if ((double)velocity >= 0.1) {
                if (stack.func_77978_p() != null) {
                    int shotsLeft = stack.func_77978_p().func_74762_e("shotsRemaining") - 1;
                    stack.func_77978_p().func_74768_a("shotsRemaining", shotsLeft);
                    if (shotsLeft == 0 && !world.field_72995_K) {
                        stack.func_77964_b(this.getMaxDamage(stack) - this.getAnimationFrames());
                    }
                }
                if (!world.field_72995_K) {
                    EntityFlamecatcherArrow arrow = new EntityFlamecatcherArrow(world);
                    arrow.aim((EntityLivingBase)player, 3.0f * velocity);
                    world.func_72838_d((Entity)arrow);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, WizardrySounds.ITEM_FLAMECATCHER_SHOOT, WizardrySounds.SPELLS, 1.0f, 1.0f);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, WizardrySounds.ITEM_FLAMECATCHER_FLAME, WizardrySounds.SPELLS, 1.0f, 1.0f);
            }
        }
    }
}

