/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.integration.jei;

import com.google.common.collect.Streams;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.integration.jei.ArcaneWorkbenchRecipe;
import electroblob.wizardry.inventory.ContainerArcaneWorkbench;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArcaneTome;
import electroblob.wizardry.item.ItemArmourUpgrade;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class ArcaneWorkbenchRecipeCategory
implements IRecipeCategory<ArcaneWorkbenchRecipe> {
    static final String UID = "ebwizardry:arcane_workbench";
    static final ResourceLocation TEXTURE = new ResourceLocation("ebwizardry", "textures/integration/jei/arcane_workbench_background.png");
    static final int WIDTH = 166;
    static final int HEIGHT = 126;
    static final int CENTRE_SLOT_X = 74;
    static final int CENTRE_SLOT_Y = 54;
    static final int CRYSTAL_SLOT_X = 7;
    static final int CRYSTAL_SLOT_Y = 91;
    static final int UPGRADE_SLOT_X = 141;
    static final int UPGRADE_SLOT_Y = 7;
    static final int OUTPUT_SLOT_X = 141;
    static final int OUTPUT_SLOT_Y = 101;
    private final IDrawable background;

    public ArcaneWorkbenchRecipeCategory(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        this.background = helper.createDrawable(TEXTURE, 0, 0, 166, 126);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"integration.jei.category.ebwizardry:arcane_workbench", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Electroblob's Wizardry";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ArcaneWorkbenchRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup slots = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        ItemStack centreStack = (ItemStack)((List)inputs.get(inputs.size() - 2)).get(0);
        int bookSlots = 0;
        if (centreStack.func_77973_b() instanceof IWorkbenchItem) {
            bookSlots = ((IWorkbenchItem)centreStack.func_77973_b()).getSpellSlotCount(centreStack);
        }
        int i = 0;
        while (i < bookSlots) {
            int x = 74 + ContainerArcaneWorkbench.getBookSlotXOffset(i, bookSlots);
            int y = 54 + ContainerArcaneWorkbench.getBookSlotYOffset(i, bookSlots);
            slots.init(i++, true, x, y);
        }
        while (i < 8) {
            slots.init(i++, true, 0, 0);
        }
        slots.init(i++, true, 7, 91);
        slots.init(i++, true, 74, 54);
        slots.init(i++, true, 141, 7);
        slots.init(i++, false, 141, 101);
        for (int j = 0; j < Math.min(bookSlots, inputs.size() - 3); ++j) {
            slots.set(j, (List)inputs.get(j));
        }
        slots.set(8, (List)inputs.get(inputs.size() - 3));
        slots.set(9, (List)inputs.get(inputs.size() - 2));
        slots.set(10, (List)inputs.get(inputs.size() - 1));
        for (int k = 0; k < outputs.size(); ++k) {
            slots.set(11 + k, (List)outputs.get(k));
        }
    }

    public static Collection<ArcaneWorkbenchRecipe> generateRecipes() {
        ArrayList<ArcaneWorkbenchRecipe> recipes = new ArrayList<ArcaneWorkbenchRecipe>();
        recipes.addAll(ArcaneWorkbenchRecipeCategory.generateUpgradeRecipes());
        recipes.addAll(ArcaneWorkbenchRecipeCategory.generateChargingRecipes());
        recipes.addAll(ArcaneWorkbenchRecipeCategory.generateScrollRecipes());
        return recipes;
    }

    private static Collection<ArcaneWorkbenchRecipe> generateUpgradeRecipes() {
        ArrayList<ArcaneWorkbenchRecipe> recipes = new ArrayList<ArcaneWorkbenchRecipe>();
        ArrayList upgrades = new ArrayList();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemArcaneTome) && !(item instanceof ItemArmourUpgrade)) continue;
            NonNullList variants = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), variants);
            upgrades.addAll(variants);
        }
        ArrayList specialUpgrades = new ArrayList();
        for (Item item : WandHelper.getSpecialUpgrades()) {
            NonNullList variants = NonNullList.func_191196_a();
            item.func_150895_a(item.func_77640_w(), variants);
            specialUpgrades.addAll(variants);
        }
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof IWorkbenchItem)) continue;
            ItemStack original = new ItemStack(item);
            for (ItemStack upgrade : upgrades) {
                ItemStack result = ((IWorkbenchItem)item).applyUpgrade(null, original.func_77946_l(), upgrade.func_77946_l());
                if (ItemStack.func_77989_b((ItemStack)original, (ItemStack)result)) continue;
                recipes.add(new ArcaneWorkbenchRecipe(original, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(upgrade), result));
            }
            ArrayList<ItemStack> applicableSpecialUpgrades = new ArrayList<ItemStack>();
            for (ItemStack upgrade : specialUpgrades) {
                ItemStack result = ((IWorkbenchItem)item).applyUpgrade(null, original.func_77946_l(), upgrade.func_77946_l());
                if (ItemStack.func_77989_b((ItemStack)original, (ItemStack)result)) continue;
                applicableSpecialUpgrades.add(upgrade);
            }
            if (applicableSpecialUpgrades.isEmpty()) continue;
            recipes.add(new ArcaneWorkbenchRecipe(original, Collections.emptyList(), Collections.emptyList(), applicableSpecialUpgrades, original));
        }
        return recipes;
    }

    private static Collection<ArcaneWorkbenchRecipe> generateChargingRecipes() {
        ArrayList<ArcaneWorkbenchRecipe> recipes = new ArrayList<ArcaneWorkbenchRecipe>();
        ArrayList<ItemStack> crystals = new ArrayList<ItemStack>();
        for (int meta = 0; meta < Element.values().length; ++meta) {
            crystals.add(new ItemStack(WizardryItems.magic_crystal, 1, meta));
        }
        List<ItemStack> shard = Collections.singletonList(new ItemStack(WizardryItems.crystal_shard));
        List<ItemStack> grandCrystal = Collections.singletonList(new ItemStack(WizardryItems.grand_crystal));
        for (Item chargeable : WizardryRecipes.getChargeableItems()) {
            if (!(chargeable instanceof IManaStoringItem)) {
                throw new IllegalArgumentException("Item to be charged must be an instance of IManaStoringItem");
            }
            ItemStack input = new ItemStack(chargeable);
            ((IManaStoringItem)chargeable).setMana(input, 0);
            ItemStack result = new ItemStack(chargeable);
            ((IManaStoringItem)chargeable).setMana(result, Constants.MANA_PER_CRYSTAL);
            recipes.add(new ArcaneWorkbenchRecipe(input, Collections.emptyList(), crystals, Collections.emptyList(), result));
            result = new ItemStack(chargeable);
            ((IManaStoringItem)chargeable).setMana(result, Constants.MANA_PER_SHARD);
            recipes.add(new ArcaneWorkbenchRecipe(input, Collections.emptyList(), shard, Collections.emptyList(), result));
            result = new ItemStack(chargeable);
            ((IManaStoringItem)chargeable).setMana(result, Constants.GRAND_CRYSTAL_MANA);
            recipes.add(new ArcaneWorkbenchRecipe(input, Collections.emptyList(), grandCrystal, Collections.emptyList(), result));
        }
        return recipes;
    }

    private static Collection<ArcaneWorkbenchRecipe> generateScrollRecipes() {
        ArrayList<ArcaneWorkbenchRecipe> recipes = new ArrayList<ArcaneWorkbenchRecipe>();
        ItemStack blankScroll = new ItemStack(WizardryItems.blank_scroll);
        List spellBooks = Streams.stream((Iterable)Item.field_150901_e).filter(i -> i instanceof ItemSpellBook).collect(Collectors.toList());
        List scrolls = Streams.stream((Iterable)Item.field_150901_e).filter(i -> i instanceof ItemScroll).collect(Collectors.toList());
        for (Spell spell : Spell.getAllSpells()) {
            for (Item spellBook : spellBooks) {
                for (Item scroll : scrolls) {
                    if (!spell.applicableForItem(spellBook) || !spell.applicableForItem(scroll)) continue;
                    List<ItemStack> books = Collections.singletonList(new ItemStack(WizardryItems.spell_book, 1, spell.metadata()));
                    ItemStack result = new ItemStack(WizardryItems.scroll, 1, spell.metadata());
                    recipes.add(new ArcaneWorkbenchRecipe(blankScroll, books, spell.getCost(), Collections.emptyList(), result));
                }
            }
        }
        return recipes;
    }
}

