/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.renderer;

public class RayHelper
implements Comparable<RayHelper> {
    int ordinal;
    public double x1;
    public double y1;
    public double z1;
    public double x2;
    public double y2;
    public double z2;
    double offsetX;
    double offsetY;
    double offsetZ;

    public RayHelper(int ordinal, double x1, double y1, double z1, double x2, double y2, double z2, double offsetX, double offsetY, double offsetZ) {
        this.ordinal = ordinal;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    double getDistanceFromViewpoint() {
        double midX = (this.x1 + this.x2) / 2.0;
        double midY = (this.y1 + this.y2) / 2.0;
        double midZ = (this.z1 + this.z2) / 2.0;
        double absoluteX = this.offsetX + midX;
        double absoluteY = this.offsetY + midY;
        double absoluteZ = this.offsetZ + midZ;
        return Math.sqrt(absoluteX * absoluteX + absoluteY * absoluteY + absoluteZ * absoluteZ);
    }

    @Override
    public int compareTo(RayHelper ray) {
        return Double.compare(ray.getDistanceFromViewpoint(), this.getDistanceFromViewpoint());
    }
}

