/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.gui;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.SpellGlyphData;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public abstract class GuiSpellInfo
extends GuiScreen {
    protected static final String TRANSLATION_KEY_PREFIX = "gui.ebwizardry:spell_book";
    protected final int xSize;
    protected final int ySize;
    protected int textureWidth = 512;
    protected int textureHeight = 256;

    public GuiSpellInfo(int xSize, int ySize) {
        this.xSize = xSize;
        this.ySize = ySize;
    }

    protected void setTextureSize(int width, int height) {
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public abstract Spell getSpell();

    public abstract ResourceLocation getTexture();

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int left = this.field_146294_l / 2 - this.xSize / 2;
        int top = this.field_146295_m / 2 - this.ySize / 2;
        this.func_146276_q_();
        this.drawBackgroundLayer(left, top, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawForegroundLayer(left, top, mouseX, mouseY);
    }

    protected void drawBackgroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(this.getSpell(), null);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(discovered ? this.getSpell().getIcon() : Spells.none.getIcon());
        DrawingUtils.drawTexturedRect(left + 146, top + 20, 0, 0, 128, 128, 128, 128);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.getTexture());
        DrawingUtils.drawTexturedRect(left, top, 0, 0, this.xSize, this.ySize, this.textureWidth, this.textureHeight);
    }

    protected void drawForegroundLayer(int left, int top, int mouseX, int mouseY) {
        boolean discovered = Wizardry.proxy.shouldDisplayDiscovered(this.getSpell(), null);
        if (discovered) {
            this.field_146289_q.func_78276_b(this.getSpell().getDisplayName(), left + 17, top + 15, 0);
            this.field_146289_q.func_78276_b(this.getSpell().getType().getDisplayName(), left + 17, top + 26, 0x777777);
        } else {
            this.field_146297_k.field_71464_q.func_78276_b(SpellGlyphData.getGlyphName(this.getSpell(), (World)this.field_146297_k.field_71441_e), left + 17, top + 15, 0);
            this.field_146297_k.field_71464_q.func_78276_b(this.getSpell().getType().getDisplayName(), left + 17, top + 26, 0x777777);
        }
        String tier = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.tier", (Object[])new Object[]{this.getSpell().getTier() == Tier.NOVICE ? "\u00a77" + this.getSpell().getTier().getDisplayName() : this.getSpell().getTier().getDisplayNameWithFormatting()});
        this.field_146289_q.func_78276_b(tier, left + 17, top + 45, 0);
        String element = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.element", (Object[])new Object[]{this.getSpell().getElement().getFormattingCode() + this.getSpell().getElement().getDisplayName()});
        if (!discovered) {
            element = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.element_undiscovered", (Object[])new Object[0]);
        }
        this.field_146289_q.func_78276_b(element, left + 17, top + 57, 0);
        String manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost", (Object[])new Object[]{this.getSpell().getCost()});
        if (this.getSpell().isContinuous) {
            manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost_continuous", (Object[])new Object[]{this.getSpell().getCost()});
        }
        if (!discovered) {
            manaCost = I18n.func_135052_a((String)"gui.ebwizardry:spell_book.mana_cost_undiscovered", (Object[])new Object[0]);
        }
        this.field_146289_q.func_78276_b(manaCost, left + 17, top + 69, 0);
        if (discovered) {
            this.field_146289_q.func_78279_b(this.getSpell().getDescription(), left + 17, top + 83, 118, 0);
        } else {
            this.field_146297_k.field_71464_q.func_78279_b(SpellGlyphData.getGlyphDescription(this.getSpell(), (World)this.field_146297_k.field_71441_e), left + 17, top + 83, 118, 0);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)WizardrySounds.MISC_BOOK_OPEN, (float)1.0f));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return Wizardry.settings.booksPauseGame;
    }
}

