/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.audio;

import electroblob.wizardry.client.audio.MovingSoundEntity;
import electroblob.wizardry.client.audio.SoundLoop;
import electroblob.wizardry.data.DispenserCastingData;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import net.minecraft.client.audio.PositionedSound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SoundLoopSpell
extends SoundLoop {
    private final Spell spell;

    public SoundLoopSpell(SoundEvent start, SoundEvent loop, SoundEvent end, float volume, SoundLoop.ISoundFactory factory, Spell spell) {
        super(start, loop, end, WizardrySounds.SPELLS, volume, factory);
        this.spell = spell;
    }

    @Override
    public void func_73660_a() {
        if (this.stillCasting(this.spell)) {
            super.func_73660_a();
        } else {
            this.endLoop();
        }
    }

    protected abstract boolean stillCasting(Spell var1);

    public static class SoundLoopSpellPosTimed
    extends SoundLoopSpellPosition {
        private int timeLeft;

        public SoundLoopSpellPosTimed(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, int duration, double x, double y, double z, float sndVolume, float sndPitch) {
            super(start, loop, end, spell, x, y, z, sndVolume, sndPitch);
            this.timeLeft = duration;
        }

        @Override
        public void func_73660_a() {
            super.func_73660_a();
            --this.timeLeft;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return this.timeLeft > 0;
        }
    }

    public static class SoundLoopSpellDispenser
    extends SoundLoopSpellPosition {
        private final TileEntityDispenser source;

        public SoundLoopSpellDispenser(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, World world, double x, double y, double z, float sndVolume, float sndPitch) {
            super(start, loop, end, spell, x, y, z, sndVolume, sndPitch);
            TileEntity tileentity = world.func_175625_s(new BlockPos(x, y, z));
            if (!(tileentity instanceof TileEntityDispenser)) {
                throw new NullPointerException(String.format("Playing continuous spell sound: no dispenser found at %s, %s, %s", x, y, z));
            }
            this.source = (TileEntityDispenser)tileentity;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return DispenserCastingData.get(this.source).currentlyCasting() == spell;
        }
    }

    public static abstract class SoundLoopSpellPosition
    extends SoundLoopSpell {
        public SoundLoopSpellPosition(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, final double x, final double y, final double z, float sndVolume, final float sndPitch) {
            super(start, loop, end, sndVolume, (sound, category, v, r) -> new PositionedSound(sound, category){
                {
                    super(x0, x1);
                    this.field_147660_d = (float)x;
                    this.field_147661_e = (float)y;
                    this.field_147658_f = (float)z;
                    this.field_147659_g = r;
                    this.field_147662_b = v;
                    this.field_147663_c = sndPitch;
                }
            }, spell);
        }
    }

    public static class SoundLoopSpellEntity
    extends SoundLoopSpell {
        private final EntityLivingBase source;

        public SoundLoopSpellEntity(SoundEvent start, SoundEvent loop, SoundEvent end, Spell spell, EntityLivingBase source, float volume, float pitch) {
            super(start, loop, end, volume, (sound, category, v, repeat) -> new MovingSoundEntity<EntityLivingBase>(source, sound, category, v, pitch, repeat), spell);
            this.source = source;
        }

        @Override
        protected boolean stillCasting(Spell spell) {
            return EntityUtils.isCasting(this.source, spell);
        }
    }
}

