/*
 * Decompiled with CFR 0.152.
 */
package electroblob.wizardry.client.animation;

import electroblob.wizardry.client.animation.Animation;
import electroblob.wizardry.client.animation.ModelRendererExtended;
import electroblob.wizardry.client.animation.PlayerAnimator;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Grapple;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.InventoryUtils;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public abstract class ActionAnimation
extends Animation {
    private final EnumAction action;

    public ActionAnimation(EnumAction action) {
        super(action.name());
        this.action = action;
    }

    @Override
    public boolean shouldDisplay(EntityPlayer player, boolean firstPerson) {
        return !firstPerson && player.func_184612_cw() > 0 && player.func_184607_cu().func_77975_n() == this.action;
    }

    public static void register() {
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.POINT){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                if (player.func_184607_cu() != player.func_184586_b(player.func_184600_cs())) {
                    return;
                }
                EnumHandSide side = InventoryUtils.getSideForHand((EntityLivingBase)player, player.func_184600_cs());
                float pitch = (float)Math.toRadians(player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks);
                float yaw = (float)Math.toRadians(player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks) - (float)Math.toRadians(player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks);
                float x = -1.5707964f + pitch + 0.2f;
                float y = (side == EnumHandSide.RIGHT ? -0.25f : 0.25f) + yaw;
                ModelRendererExtended arm = (ModelRendererExtended)1.getArmForSide(model, side);
                arm.setRotation(x, y, 0.0f);
            }
        });
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.POINT_UP){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                if (player.func_184607_cu() != player.func_184586_b(player.func_184600_cs())) {
                    return;
                }
                EnumHandSide side = InventoryUtils.getSideForHand((EntityLivingBase)player, player.func_184600_cs());
                ModelRendererExtended arm = (ModelRendererExtended)2.getArmForSide(model, side);
                arm.addRotation(-2.2f, side == EnumHandSide.RIGHT ? 0.2f : -0.2f, 0.0f);
            }
        });
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.POINT_DOWN){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                float tick = (float)player.func_184612_cw() + partialTicks;
                float y = Math.min(0.4f + tick * 0.05f, 0.7f);
                EnumHandSide side = InventoryUtils.getSideForHand((EntityLivingBase)player, player.func_184600_cs());
                ModelRendererExtended arm = (ModelRendererExtended)3.getArmForSide(model, side);
                arm.addRotation(-0.2f, side == EnumHandSide.RIGHT ? y : -y, 0.0f);
            }
        });
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.SUMMON){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                float tick = (float)player.func_184612_cw() + partialTicks;
                float x = -Math.min(0.4f + tick * 0.2f, 2.0f);
                ((ModelRendererExtended)4.getArmForSide(model, EnumHandSide.RIGHT)).addRotation(x, 1.2f, 0.0f);
                ((ModelRendererExtended)4.getArmForSide(model, EnumHandSide.LEFT)).addRotation(x, -1.2f, 0.0f);
            }
        });
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.GRAPPLE){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                WizardData data = WizardData.get(player);
                RayTraceResult hit = data.getVariable(Grapple.TARGET_KEY);
                if (hit == null || hit.field_72313_a == RayTraceResult.Type.MISS) {
                    return;
                }
                Vec3d target = hit.field_72307_f;
                if (hit.field_72308_g instanceof EntityLivingBase) {
                    target = GeometryUtils.getCentre(hit.field_72308_g);
                }
                EnumHandSide side = InventoryUtils.getSideForHand((EntityLivingBase)player, player.func_184600_cs());
                ModelRendererExtended arm = (ModelRendererExtended)5.getArmForSide(model, side);
                Vec3d direction = target.func_178788_d(player.func_174824_e(partialTicks));
                float yaw = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
                float pitch = (float)MathHelper.func_181159_b((double)MathHelper.func_76133_a((double)(direction.field_72450_a * direction.field_72450_a + direction.field_72449_c * direction.field_72449_c)), (double)direction.field_72448_b);
                float x = pitch - 2.8274333f;
                float y = -((float)Math.toRadians(yaw)) - (float)MathHelper.func_181159_b((double)direction.field_72450_a, (double)direction.field_72449_c);
                y += side == EnumHandSide.RIGHT ? -0.25f : 0.25f;
                if (Math.abs(pitch) < 0.2f) {
                    y = arm.field_78796_g;
                }
                arm.setRotation(x, y, 0.0f);
            }
        });
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.IMBUE){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                float tick = (float)player.func_184612_cw() + partialTicks;
                float z = Math.max(1.5f - tick * 0.1f, 0.8f);
                EnumHandSide side = InventoryUtils.getSideForHand((EntityLivingBase)player, player.func_184600_cs());
                ModelRendererExtended arm = (ModelRendererExtended)6.getArmForSide(model, side);
                arm.addRotation(-1.2f, side == EnumHandSide.RIGHT ? -0.2f : 0.2f, side == EnumHandSide.RIGHT ? z : -z);
                if (!player.func_184586_b(InventoryUtils.getHandForSide((EntityLivingBase)player, side.func_188468_a())).func_190926_b()) {
                    ((ModelRendererExtended)6.getArmForSide(model, side.func_188468_a())).addRotation(-0.8f, side == EnumHandSide.LEFT ? 0.3f : -0.3f, 0.0f);
                }
            }
        });
        PlayerAnimator.registerAnimation(new ActionAnimation(SpellActions.THRUST){

            @Override
            public void setRotationAngles(EntityPlayer player, ModelBiped model, float partialTicks, boolean firstPerson) {
                if (player.func_184607_cu() != player.func_184586_b(player.func_184600_cs())) {
                    return;
                }
                EnumHandSide side = InventoryUtils.getSideForHand((EntityLivingBase)player, player.func_184600_cs());
                ModelRendererExtended arm = (ModelRendererExtended)7.getArmForSide(model, side);
                float y = side == EnumHandSide.RIGHT ? -0.6f : 0.6f;
                arm.addRotation(-1.2f, y, 0.0f);
                if (player.func_184586_b(InventoryUtils.getHandForSide((EntityLivingBase)player, side.func_188468_a())).func_190926_b()) {
                    ModelRendererExtended otherArm = (ModelRendererExtended)7.getArmForSide(model, side.func_188468_a());
                    otherArm.setRotation(arm.field_78795_f - 1.2f, -arm.field_78796_g - y, otherArm.field_78808_h);
                }
            }
        });
    }
}

