/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.registry;

import com.google.common.collect.Lists;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.registry.FluidsRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeRegistry {
    private static Map<String, Boolean> usedRecipeNames = new HashMap<String, Boolean>();
    public static List<IRecipe> recipes = new ArrayList<IRecipe>();
    ResourceLocation group = new ResourceLocation("cyclicmagic", "recipes");

    public static void register(IRecipe recipeHydrate) {
        recipes.add(recipeHydrate);
    }

    public static void add(IRecipe r, ResourceLocation location) {
        r.setRegistryName(location);
        recipes.add(r);
    }

    private static IRecipe addShapelessOreRecipe(ItemStack stack, Object ... recipeComponents) {
        ResourceLocation location = Util1pt12.buildName(stack);
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(location, stack, recipeComponents);
        RecipeRegistry.add((IRecipe)recipe, location);
        return recipe;
    }

    public static IRecipe addShapelessRecipe(ItemStack output, Object ... recipeComponents) {
        ArrayList list = Lists.newArrayList();
        for (Object object : recipeComponents) {
            if (object instanceof String) {
                return RecipeRegistry.addShapelessOreRecipe(output, recipeComponents);
            }
            if (object instanceof ItemStack) {
                list.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                list.add(new ItemStack((Item)object));
                continue;
            }
            if (!(object instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add(new ItemStack((Block)object));
        }
        ResourceLocation location = Util1pt12.buildName(output);
        ShapelessRecipes recipe = new ShapelessRecipes(location.func_110624_b(), output, Util1pt12.convertToNonNullList(recipeComponents));
        RecipeRegistry.add((IRecipe)recipe, location);
        return recipe;
    }

    private static IRecipe _addShapedRecipe(ItemStack output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
        RecipeRegistry.add((IRecipe)recipe, Util1pt12.buildName(output));
        return recipe;
    }

    public static IRecipe addShapedRecipe(ItemStack output, Object ... recipeComponents) {
        for (Object object : recipeComponents) {
            if (!(object instanceof String)) continue;
            return RecipeRegistry.addShapedOreRecipe(output, recipeComponents);
        }
        return RecipeRegistry._addShapedRecipe(output, recipeComponents);
    }

    public static IRecipe addShapedOreRecipe(ItemStack output, Object ... recipeComponents) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("cannot add recipe for air");
        }
        ResourceLocation location = Util1pt12.buildName(output);
        ShapedOreRecipe recipe = new ShapedOreRecipe(location, output, recipeComponents);
        RecipeRegistry.add((IRecipe)recipe, Util1pt12.buildName(output));
        return recipe;
    }

    @SubscribeEvent
    public static void onRegisterRecipe(RegistryEvent.Register<IRecipe> event) {
        FluidsRegistry.addPoisonRecipe();
        event.getRegistry().registerAll((IForgeRegistryEntry[])recipes.toArray(new IRecipe[0]));
    }

    public static BrewingRecipe addBrewingRecipe(ItemStack input, ItemStack ingredient, ItemStack output) {
        if (input.func_190926_b() || input.func_77973_b() == null) {
            return null;
        }
        BrewingRecipe recipe = new BrewingRecipe(input, ingredient, output);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)recipe);
        if (ModCyclic.logger.runUnitTests()) {
            ItemStack output0 = BrewingRecipeRegistry.getOutput((ItemStack)input, (ItemStack)ingredient);
            if (output0.func_77973_b() == output.func_77973_b()) {
                ModCyclic.logger.logTestResult("Brewing Recipe succefully registered and working: " + output.func_77977_a());
            } else {
                ModCyclic.logger.logTestResult("Brewing Recipe FAILED to register" + output.func_77977_a());
            }
        }
        return recipe;
    }

    public static class Util1pt12 {
        public static ResourceLocation buildName(ItemStack output) {
            ResourceLocation firstTry = new ResourceLocation("cyclicmagic", output.func_77977_a());
            int limit = 999;
            int index = 0;
            while (usedRecipeNames.containsKey(firstTry.toString()) || index > limit) {
                firstTry = new ResourceLocation("cyclicmagic", firstTry.func_110623_a() + "_" + ++index);
            }
            usedRecipeNames.put(firstTry.toString(), true);
            return firstTry;
        }

        private static NonNullList<Ingredient> convertToNonNullList(Object[] input) {
            NonNullList list = NonNullList.func_191196_a();
            for (Object any : input) {
                if (any instanceof Ingredient) {
                    list.add((Object)((Ingredient)any));
                    continue;
                }
                Ingredient ing = CraftingHelper.getIngredient((Object)any);
                if (ing == null) {
                    ing = Ingredient.field_193370_a;
                }
                list.add((Object)ing);
            }
            return list;
        }
    }
}

