/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.storagesack;

import com.lothrazar.cyclicmagic.util.UtilNBT;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public enum StorageActionType {
    NOTHING,
    MERGE,
    DEPOSIT;

    private static final String NBT_OPEN = "isOpen";
    private static final String NBT_COLOUR = "COLOUR";
    private static final String NBT = "build";
    private static final String NBTTIMEOUT = "timeout";

    public static int getTimeout(ItemStack wand) {
        return UtilNBT.getItemStackNBT(wand).func_74762_e(NBTTIMEOUT);
    }

    public static void setTimeout(ItemStack wand) {
        UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, 15);
    }

    public static void tickTimeout(ItemStack wand) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        int t = tags.func_74762_e(NBTTIMEOUT);
        if (t > 0) {
            UtilNBT.getItemStackNBT(wand).func_74768_a(NBTTIMEOUT, t - 1);
        }
    }

    public static int get(ItemStack wand) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        return tags.func_74762_e(NBT);
    }

    public static String getName(ItemStack wand) {
        try {
            NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
            return "item.storage_bag." + StorageActionType.values()[tags.func_74762_e(NBT)].toString().toLowerCase();
        }
        catch (Exception e) {
            return "item.storage_bag." + NOTHING.toString().toLowerCase();
        }
    }

    public static void toggle(ItemStack wand) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        int type = tags.func_74762_e(NBT);
        if (++type > DEPOSIT.ordinal()) {
            type = NOTHING.ordinal();
        }
        tags.func_74768_a(NBT, type);
        wand.func_77982_d(tags);
    }

    public static int getColour(ItemStack wand) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        if (!tags.func_74764_b(NBT_COLOUR)) {
            return EnumDyeColor.BROWN.func_193350_e();
        }
        return tags.func_74762_e(NBT_COLOUR);
    }

    public static boolean getIsOpen(ItemStack wand) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        if (!tags.func_74764_b(NBT_OPEN)) {
            return false;
        }
        return tags.func_74767_n(NBT_OPEN);
    }

    public static void setIsOpen(ItemStack wand, boolean s) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        tags.func_74757_a(NBT_OPEN, s);
    }

    public static void setColour(ItemStack wand, int color) {
        NBTTagCompound tags = UtilNBT.getItemStackNBT(wand);
        tags.func_74768_a(NBT_COLOUR, color);
        wand.func_77982_d(tags);
    }
}

