/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.mobcapture;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.entity.EntityThrowableDispensable;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.core.BaseItemProjectile;
import com.lothrazar.cyclicmagic.item.mobcapture.EntityMagicNetEmpty;
import com.lothrazar.cyclicmagic.item.mobcapture.EntityMagicNetFull;
import com.lothrazar.cyclicmagic.module.MultiContent;
import com.lothrazar.cyclicmagic.registry.EntityProjectileRegistry;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilPlayer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemProjectileMagicNet
extends BaseItemProjectile
implements IContent,
IHasRecipe {
    public static final String NBT_ENTITYID = "id";
    private boolean enabled;

    @Override
    public EntityThrowableDispensable getThrownEntity(World world, ItemStack held, double x, double y, double z) {
        if (this.hasEntity(held)) {
            ItemStack heldCopy = held.func_77946_l();
            held.func_77978_p().func_82580_o(NBT_ENTITYID);
            held.func_77982_d(null);
            EntityMagicNetFull ent = new EntityMagicNetFull(world, x, y, z);
            ent.setCaptured(heldCopy);
            return ent;
        }
        EntityMagicNetEmpty ent = new EntityMagicNetEmpty(world, x, y, z);
        return ent;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this, 1), "lal", "qiq", "lal", Character.valueOf('i'), "ingotIron", Character.valueOf('a'), new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE), Character.valueOf('l'), "dyeCyan", Character.valueOf('q'), new ItemStack(Items.field_151126_ay));
    }

    public boolean hasEntity(ItemStack held) {
        return held.func_77978_p() != null && held.func_77978_p().func_74764_b(NBT_ENTITYID);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.hasEntity(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        if (this.func_77636_d(stack)) {
            tooltip.add(stack.func_77978_p().func_74779_i(NBT_ENTITYID));
        } else {
            super.func_77624_a(stack, playerIn, tooltip, advanced);
        }
    }

    @Override
    public void onItemThrow(ItemStack held, World world, EntityPlayer player, EnumHand hand) {
        if (this.hasEntity(held)) {
            this.doThrow(world, player, hand, new EntityMagicNetFull(world, (EntityLivingBase)player, held.func_77946_l()));
            held.func_77978_p().func_82580_o(NBT_ENTITYID);
            held.func_77982_d(null);
        } else {
            this.doThrow(world, player, hand, new EntityMagicNetEmpty(world, (EntityLivingBase)player));
        }
        UtilPlayer.decrStackSize(player, hand);
    }

    @Override
    public SoundEvent getSound() {
        return SoundEvents.field_187511_aA;
    }

    @Override
    public String getContentName() {
        return "magic_net";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName(), GuideCategory.ITEMTHROW);
        EntityMagicNetEmpty.renderSnowball = this;
        EntityProjectileRegistry.registerModEntity(EntityMagicNetFull.class, "magicnetfull", 1011);
        EntityProjectileRegistry.registerModEntity(EntityMagicNetEmpty.class, "magicnetempty", 1012);
        MultiContent.projectiles.add(this);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("MonsterBall", "cyclicmagic.content", true, this.getContentName() + " Set false to delete - requires restart");
        String category = "modpacks." + this.getContentName();
        String[] deflist = new String[]{"minecraft:wither", "minecraft:ender_dragon", "minecraft:ender_crystal"};
        Object[] blacklist = config.getStringList("CaptureBlacklist", category, deflist, "Entities that cannot be captured.  (even without this, players and non-living entities do not work)");
        EntityMagicNetEmpty.blacklistIds = NonNullList.func_193580_a((Object)"", (Object[])blacklist);
    }
}

