/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.homingmissile;

import com.lothrazar.cyclicmagic.entity.RenderBall;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import java.util.UUID;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class EntityHomingProjectile
extends EntityThrowable {
    private static final int MAX_LIFETIME = 120;
    private static final int TIME_UNTIL_HOMING = 8;
    private static final double SPEED = 0.95;
    private int lifetime = 120;
    private UUID targetId = null;
    private EntityLivingBase targetEntity;
    private float damage = 6.0f;

    public EntityHomingProjectile(World worldIn) {
        super(worldIn);
        this.init();
    }

    public EntityHomingProjectile(World worldIn, EntityLivingBase thrower) {
        super(worldIn, thrower);
        this.init();
    }

    private void init() {
        this.func_189654_d(true);
        this.field_70178_ae = true;
        this.func_70105_a(0.1f, 0.1f);
    }

    public void setTarget(EntityLivingBase target) {
        this.targetId = target.func_110124_au();
        this.targetEntity = target;
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && mop.field_72308_g != null && mop.field_72308_g instanceof EntityLivingBase && mop.field_72308_g.func_110124_au().compareTo(this.targetId) == 0) {
            mop.field_72308_g.func_70097_a(DamageSource.field_76377_j, this.damage);
            this.func_70106_y();
            UtilParticle.spawnParticle(this.field_70170_p, EnumParticleTypes.CRIT_MAGIC, this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.func_82142_c(true);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.lifetime;
        if (this.lifetime > 112) {
            return;
        }
        if (this.lifetime == 0 || this.targetId == null || this.targetEntity == null || this.targetEntity.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.field_70170_p.field_72995_K && (this.targetEntity == null || this.targetEntity.func_180425_c().equals((Object)this.func_180425_c()))) {
            this.func_70106_y();
            return;
        }
        this.moveTowardsTarget();
    }

    private void moveTowardsTarget() {
        this.field_70177_z = (float)Math.toRadians(UtilEntity.yawDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v));
        this.field_70125_A = (float)Math.toRadians(UtilEntity.pitchDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v));
        Vec3d moveVec = UtilEntity.lookVector(this.field_70177_z, this.field_70125_A).func_186678_a(0.95);
        this.field_70159_w = 0.5 * this.field_70159_w + 0.5 * moveVec.field_72450_a;
        this.field_70181_x = 0.5 * this.field_70181_x + 0.5 * moveVec.field_72448_b;
        this.field_70179_y = 0.5 * this.field_70179_y + 0.5 * moveVec.field_72449_c;
    }

    public static class FactoryMissile
    implements IRenderFactory<EntityHomingProjectile> {
        public Render<? super EntityHomingProjectile> createRenderFor(RenderManager rm) {
            return new RenderBall(rm, "magic_missile", false);
        }
    }
}

