/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildershape;

import com.lothrazar.cyclicmagic.block.buildershape.BlockStructureBuilder;
import com.lothrazar.cyclicmagic.block.buildershape.ContainerBuilder;
import com.lothrazar.cyclicmagic.block.buildershape.StructureBuilderType;
import com.lothrazar.cyclicmagic.block.buildershape.TileEntityStructureBuilder;
import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.gui.button.ButtonTileEntityField;
import com.lothrazar.cyclicmagic.gui.button.ButtonTriggerWrapper;
import com.lothrazar.cyclicmagic.gui.component.EnergyBar;
import com.lothrazar.cyclicmagic.gui.component.GuiSliderInteger;
import com.lothrazar.cyclicmagic.util.Const;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.io.IOException;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class GuiBuilder
extends GuiBaseContainer {
    private TileEntityStructureBuilder tile;
    private int yOffset = 18;
    private GuiSliderInteger sliderHeight;
    private GuiSliderInteger sliderSize;

    public GuiBuilder(InventoryPlayer inventoryPlayer, TileEntityStructureBuilder tileEntity) {
        super(new ContainerBuilder(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
        this.setScreenSize(Const.ScreenSize.LARGE);
        this.fieldRedstoneBtn = TileEntityStructureBuilder.Fields.REDSTONE.ordinal();
        this.fieldPreviewBtn = TileEntityStructureBuilder.Fields.RENDERPARTICLES.ordinal();
        this.energyBar = new EnergyBar((GuiBaseContainer)this, BlockStructureBuilder.FUEL_COST);
        this.energyBar.setWidth(10).setY(4).setX(160).setHeight(42);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int id = 1;
        int width = 102;
        int h = 10;
        int x = this.field_147003_i + 52;
        int y = this.field_147009_r + 15;
        this.sliderHeight = new GuiSliderInteger(this.tile, ++id, x, y, width, h, 1, TileEntityStructureBuilder.maxHeight, TileEntityStructureBuilder.Fields.HEIGHT.ordinal());
        this.sliderHeight.setTooltip("slider.height.tooltip");
        this.func_189646_b(this.sliderHeight);
        this.sliderSize = new GuiSliderInteger(this.tile, ++id, x, y += 16, width, h, 1, TileEntityStructureBuilder.maxSize, TileEntityStructureBuilder.Fields.SIZE.ordinal());
        this.sliderSize.setTooltip("slider.size.tooltip");
        this.func_189646_b(this.sliderSize);
        ++id;
        x = this.field_147003_i + 8 + h;
        y = this.field_147009_r + this.yOffset + 8;
        h = width = 18;
        x = this.field_147003_i + 4;
        y = this.field_147009_r + 50;
        TileEntityStructureBuilder.Fields fld = TileEntityStructureBuilder.Fields.BUILDTYPE;
        int numInRow = 0;
        for (StructureBuilderType shape : StructureBuilderType.SORTED) {
            if (++numInRow == 9) {
                x = this.field_147003_i + 4;
                y += h + 4;
            }
            ButtonTileEntityField btnShape = new ButtonTileEntityField(id++, x, y, this.tile.func_174877_v(), fld.ordinal(), shape.ordinal(), width, h);
            String n = UtilChat.lang("buildertype." + shape.name().toLowerCase() + ".name");
            this.func_189646_b(btnShape).setTooltip((String)n).field_146126_j = shape.shortcode();
            btnShape.buttonMode = ButtonTileEntityField.ButtonMode.SET;
            x += width + 2;
            this.registerButtonDisableTrigger((GuiButton)btnShape, ButtonTriggerWrapper.ButtonTriggerType.EQUAL, fld.ordinal(), shape.ordinal());
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.sliderHeight.keyTyped(typedChar, keyCode);
        this.sliderSize.keyTyped(typedChar, keyCode);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.sliderHeight.updateScreen();
        this.sliderSize.updateScreen();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String label = UtilChat.lang("buildertype." + this.tile.getBuildTypeEnum().name().toLowerCase() + ".name");
        this.drawString(label, 66, 76);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        boolean u = false;
        boolean v = false;
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT);
        for (int k = 0; k < this.tile.func_70302_i_() - 1; ++k) {
            Gui.func_146110_a((int)(this.field_147003_i + 8 - 1 + k * 18), (int)(this.field_147009_r + 94 - 1), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT_GPS);
        Gui.func_146110_a((int)(this.field_147003_i + 25), (int)(this.field_147009_r + 28), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
    }
}

