/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.builderpattern;

import com.lothrazar.cyclicmagic.block.builderpattern.BlockPatternBuilder;
import com.lothrazar.cyclicmagic.block.builderpattern.ContainerPattern;
import com.lothrazar.cyclicmagic.block.builderpattern.TileEntityPatternBuilder;
import com.lothrazar.cyclicmagic.gui.GuiBaseContainer;
import com.lothrazar.cyclicmagic.gui.button.ButtonTileEntityField;
import com.lothrazar.cyclicmagic.gui.component.EnergyBar;
import com.lothrazar.cyclicmagic.util.Const;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GuiPattern
extends GuiBaseContainer {
    static final int GUI_ROWS = 2;
    private TileEntityPatternBuilder tile;
    private ButtonTileEntityField btnRotation;
    private ButtonTileEntityField btnFlipZ;
    private ButtonTileEntityField btnFlipY;
    private ButtonTileEntityField btnFlipX;
    private ButtonTileEntityField btnRender;

    public GuiPattern(InventoryPlayer inventoryPlayer, TileEntityPatternBuilder tileEntity) {
        super(new ContainerPattern(inventoryPlayer, tileEntity), tileEntity);
        this.tile = tileEntity;
        this.setScreenSize(Const.ScreenSize.LARGE);
        this.field_146999_f = this.getScreenSize().width();
        this.field_147000_g = this.getScreenSize().height();
        this.fieldRedstoneBtn = TileEntityPatternBuilder.Fields.REDSTONE.ordinal();
        this.energyBar = new EnergyBar((GuiBaseContainer)this, BlockPatternBuilder.FUEL_COST);
        this.energyBar.setX(158).setY(4).setHeight(42);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int id = 2;
        int x = this.field_147003_i + 4;
        int y = this.field_147009_r + 4 + 22;
        this.btnRender = new ButtonTileEntityField(id++, x, y, this.tile.func_174877_v(), TileEntityPatternBuilder.Fields.RENDERPARTICLES.ordinal());
        this.btnRender.field_146121_g = 18;
        this.btnRender.field_146120_f = 18;
        this.func_189646_b(this.btnRender);
        this.btnRotation = new ButtonTileEntityField(id++, this.field_147003_i + 26, this.field_147009_r + 15, this.tile.func_174877_v(), TileEntityPatternBuilder.Fields.ROTATION.ordinal(), 1, 40, 16);
        this.btnRotation.setTooltip("tile.builder_pattern.rotation");
        this.func_189646_b(this.btnRotation);
        this.btnFlipX = new ButtonTileEntityField(id++, this.btnRotation.field_146128_h + this.btnRotation.field_146120_f + 4, this.field_147009_r + 15, this.tile.func_174877_v(), TileEntityPatternBuilder.Fields.FLIPX.ordinal(), 1, 20, 16);
        this.btnFlipX.setTooltip("tile.builder_pattern.flipaxis");
        this.func_189646_b(this.btnFlipX);
        this.btnFlipY = new ButtonTileEntityField(id++, this.btnFlipX.field_146128_h + this.btnFlipX.field_146120_f + 4, this.btnFlipX.field_146129_i, this.tile.func_174877_v(), TileEntityPatternBuilder.Fields.FLIPY.ordinal(), 1, 20, 16);
        this.btnFlipY.setTooltip("tile.builder_pattern.flipaxis");
        this.func_189646_b(this.btnFlipY);
        this.btnFlipZ = new ButtonTileEntityField(id++, this.btnFlipY.field_146128_h + this.btnFlipY.field_146120_f + 4, this.btnFlipY.field_146129_i, this.tile.func_174877_v(), TileEntityPatternBuilder.Fields.FLIPZ.ordinal(), 1, 20, 16);
        this.btnFlipZ.setTooltip("tile.builder_pattern.flipaxis");
        this.func_189646_b(this.btnFlipZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void func_146979_b(int mouseX, int mouseY) {
        this.btnRotation.field_146126_j = this.tile.getRotationName();
        int render = this.tile.getField(TileEntityPatternBuilder.Fields.RENDERPARTICLES);
        if (render == 0) {
            this.btnRender.setTextureIndex(-1);
        } else if (render == 1) {
            this.btnRender.setTextureIndex(render + 2);
        } else if (render == 2) {
            this.btnRender.setTextureIndex(render);
        }
        this.btnRender.setTooltip(this.tile.func_70005_c_() + ".preview" + this.tile.getField(TileEntityPatternBuilder.Fields.RENDERPARTICLES));
        this.btnFlipX.field_146126_j = (this.tile.getField(TileEntityPatternBuilder.Fields.FLIPX) == 1 ? "^" : "") + "X";
        this.btnFlipY.field_146126_j = (this.tile.getField(TileEntityPatternBuilder.Fields.FLIPY) == 1 ? "^" : "") + "Y";
        this.btnFlipZ.field_146126_j = (this.tile.getField(TileEntityPatternBuilder.Fields.FLIPZ) == 1 ? "^" : "") + "Z";
        this.drawString("tile.builder_pattern.source_gps_label", 30, 40);
        this.drawString("tile.builder_pattern.target_gps_label", 110, 40);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        boolean u = false;
        boolean v = false;
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT);
        int row = 0;
        int col = 0;
        for (int i = 0; i < this.tile.func_70302_i_() - 3; ++i) {
            row = i / 2;
            col = i % 2;
            Gui.func_146110_a((int)(this.field_147003_i + 8 - 1 + row * 18), (int)(this.field_147009_r + 90 - 1 + col * 18), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
        }
        this.field_146297_k.func_110434_K().func_110577_a(Const.Res.SLOT_GPS);
        int hgt = 50;
        Gui.func_146110_a((int)(this.field_147003_i + 25), (int)(this.field_147009_r + hgt + 15), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
        Gui.func_146110_a((int)(this.field_147003_i + 45), (int)(this.field_147009_r + hgt), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
        Gui.func_146110_a((int)(this.field_147003_i + 120), (int)(this.field_147009_r + hgt), (float)((float)u), (float)((float)v), (int)18, (int)18, (float)18.0f, (float)18.0f);
    }
}

