/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.surface;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.Widget;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class WidgetCollection {
    public Map<Integer, IRenderableWidget> renderables = new ConcurrentHashMap<Integer, IRenderableWidget>();
    public Map<Integer, IRenderableWidget> renderablesWorld = new ConcurrentHashMap<Integer, IRenderableWidget>();

    public Map<Integer, IRenderableWidget> getWidgetsWorld() {
        return this.renderablesWorld;
    }

    public Map<Integer, IRenderableWidget> getWidgetsOverlay() {
        return this.renderables;
    }

    public void updateWidgets(Set<Map.Entry<Integer, Widget>> widgets) {
        for (Map.Entry<Integer, Widget> widget : widgets) {
            IRenderableWidget r = widget.getValue().getRenderable();
            switch (r.getRenderType()) {
                case GameOverlayLocated: {
                    this.renderables.put(widget.getKey(), r);
                    break;
                }
                case WorldLocated: {
                    this.renderablesWorld.put(widget.getKey(), r);
                }
            }
        }
    }

    public void removeWidgets(List<Integer> ids) {
        for (Integer id : ids) {
            this.renderables.remove(id);
            this.renderablesWorld.remove(id);
        }
    }

    public void removeAllWidgets() {
        this.renderables.clear();
        this.renderablesWorld.clear();
    }

    public int getWidgetCount(RenderType renderEvent) {
        if (renderEvent == null) {
            return this.getWidgetsOverlay().size() + this.getWidgetsWorld().size();
        }
        switch (renderEvent) {
            case WorldLocated: {
                return this.getWidgetsWorld().size();
            }
            case GameOverlayLocated: {
                return this.getWidgetsOverlay().size();
            }
        }
        return 0;
    }
}

