/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.core.modifiers;

import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import ben_mkiv.rendertoolkit.common.widgets.core.Easing;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IEasing;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.client.renderer.GlStateManager;

public class WidgetModifierColor
extends WidgetModifier
implements IEasing {
    private float r;
    private float g;
    private float b;
    private float alpha;
    private float red;
    private float green;
    private float blue;
    private float Alpha;

    @Override
    public void addEasing(String type, String typeIO, float duration, String list, float min, float max, String mode) {
        min = Math.max(0.0f, Math.min(min, 1.0f));
        max = Math.max(0.0f, Math.min(max, 1.0f));
        switch (list.toLowerCase()) {
            case "red": 
            case "r": {
                super.addEasing(type, typeIO, duration, "r", min, max, mode);
                return;
            }
            case "green": 
            case "g": {
                super.addEasing(type, typeIO, duration, "g", min, max, mode);
                return;
            }
            case "blue": 
            case "b": {
                super.addEasing(type, typeIO, duration, "b", min, max, mode);
                return;
            }
            case "alpha": 
            case "a": {
                super.addEasing(type, typeIO, duration, "a", min, max, mode);
                return;
            }
        }
    }

    @Override
    public void removeEasing(String list) {
        switch (list.toLowerCase()) {
            case "red": 
            case "r": {
                super.removeEasing("r");
                return;
            }
            case "green": 
            case "g": {
                super.removeEasing("g");
                return;
            }
            case "blue": 
            case "b": {
                super.removeEasing("b");
                return;
            }
            case "alpha": 
            case "a": {
                super.removeEasing("a");
                return;
            }
        }
    }

    @Override
    public void update(float[] values) {
        if (values.length < 3) {
            return;
        }
        this.r = Math.max(0.0f, Math.min(values[0], 1.0f));
        this.g = Math.max(0.0f, Math.min(values[1], 1.0f));
        this.b = Math.max(0.0f, Math.min(values[2], 1.0f));
        this.alpha = values.length >= 4 ? Math.max(0.0f, Math.min(values[3], 1.0f)) : 1.0f;
        this.applyEasings();
    }

    public WidgetModifierColor(float r, float g, float b, float alpha) {
        this.setColor(r, g, b, alpha);
    }

    @Override
    public void apply(long conditionStates) {
        if (!this.shouldApplyModifier(conditionStates)) {
            return;
        }
        this.applyEasings();
        if (this.Alpha < 1.0f) {
            GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.Alpha);
        } else {
            GlStateManager.func_179124_c((float)this.red, (float)this.green, (float)this.blue);
        }
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        buff.writeFloat(this.r);
        buff.writeFloat(this.g);
        buff.writeFloat(this.b);
        buff.writeFloat(this.alpha);
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.setColor(buff.readFloat(), buff.readFloat(), buff.readFloat(), buff.readFloat());
    }

    private void setColor(float r, float g, float b, float alpha) {
        this.r = Math.max(0.0f, Math.min(r, 1.0f));
        this.g = Math.max(0.0f, Math.min(g, 1.0f));
        this.b = Math.max(0.0f, Math.min(b, 1.0f));
        this.alpha = Math.max(0.0f, Math.min(alpha, 1.0f));
    }

    @Override
    public WidgetModifier.WidgetModifierType getType() {
        return WidgetModifier.WidgetModifierType.COLOR;
    }

    private void applyEasings() {
        this.red = Easing.applyEasing((ArrayList)this.easings.get("r"), this.r);
        this.green = Easing.applyEasing((ArrayList)this.easings.get("g"), this.g);
        this.blue = Easing.applyEasing((ArrayList)this.easings.get("b"), this.b);
        this.Alpha = Easing.applyEasing((ArrayList)this.easings.get("a"), this.alpha);
    }

    @Override
    public Object[] getValues() {
        this.applyEasings();
        return new Object[]{Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.Alpha)};
    }
}

