/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.core;

import ben_mkiv.commons0815.penner.easing.Back;
import ben_mkiv.commons0815.penner.easing.Bounce;
import ben_mkiv.commons0815.penner.easing.Circ;
import ben_mkiv.commons0815.penner.easing.Cubic;
import ben_mkiv.commons0815.penner.easing.Elastic;
import ben_mkiv.commons0815.penner.easing.Expo;
import ben_mkiv.commons0815.penner.easing.Linear;
import ben_mkiv.commons0815.penner.easing.Quad;
import ben_mkiv.commons0815.penner.easing.Quart;
import ben_mkiv.commons0815.penner.easing.Quint;
import ben_mkiv.commons0815.penner.easing.Sine;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;

public class Easing {
    public static float applyEasing(ArrayList easingList, float value) {
        if (easingList == null) {
            return value;
        }
        float timeNow = (float)System.nanoTime() / 1000000.0f;
        if (((Float)easingList.get(6)).floatValue() == 0.0f) {
            easingList.set(6, Float.valueOf(timeNow));
        }
        float time = timeNow - ((Float)easingList.get(6)).floatValue();
        float duration = ((Float)easingList.get(2)).floatValue();
        EasingType type = (EasingType)((Object)easingList.get(0));
        EasingTypeIO typeIO = (EasingTypeIO)((Object)easingList.get(1));
        EasingTypeMode mode = (EasingTypeMode)((Object)easingList.get(5));
        value = Easing.ease(time, duration, type, typeIO, ((Float)easingList.get(3)).floatValue(), ((Float)easingList.get(4)).floatValue(), mode);
        return value;
    }

    public static ArrayList setEasing(EasingType type, EasingTypeIO typeIO, float duration, float min, float max, EasingTypeMode mode) {
        ArrayList<Object> newList = new ArrayList<Object>();
        newList.add((Object)type);
        newList.add((Object)typeIO);
        newList.add(Float.valueOf(duration));
        newList.add(Float.valueOf(min));
        newList.add(Float.valueOf(max));
        newList.add((Object)mode);
        newList.add(Float.valueOf(0.0f));
        return newList;
    }

    public static float ease(float currentTime, float totalTime, EasingType easingType, EasingTypeIO easingTypeIO, float min, float max, EasingTypeMode mode) {
        switch (mode) {
            case LOOP: {
                float loopTime = totalTime * 2.0f;
                if (currentTime > loopTime) {
                    currentTime %= loopTime;
                }
                if (!(currentTime > totalTime)) break;
                currentTime = totalTime - (currentTime - totalTime);
                break;
            }
            case REPEAT: {
                if (!(currentTime > totalTime)) break;
                currentTime %= totalTime;
                break;
            }
            default: {
                if (!(currentTime > totalTime)) break;
                currentTime = totalTime;
            }
        }
        switch (easingTypeIO) {
            case IN: {
                return Easing.easeIn(currentTime, totalTime, min, max, easingType);
            }
            case OUT: {
                return Easing.easeOut(currentTime, totalTime, min, max, easingType);
            }
            case INOUT: {
                return Easing.easeInOut(currentTime, totalTime, min, max, easingType);
            }
        }
        return 0.0f;
    }

    public static float easeOut(float currentTime, float totalTime, float min, float max, EasingType easingType) {
        switch (easingType) {
            case BACK: {
                return Back.easeOut(currentTime, min, max, totalTime);
            }
            case BOUNCE: {
                return Bounce.easeOut(currentTime, min, max, totalTime);
            }
            case CIRC: {
                return Circ.easeOut(currentTime, min, max, totalTime);
            }
            case CUBIC: {
                return Cubic.easeOut(currentTime, min, max, totalTime);
            }
            case ELASTIC: {
                return Elastic.easeOut(currentTime, min, max, totalTime);
            }
            case EXPO: {
                return Expo.easeOut(currentTime, min, max, totalTime);
            }
            case LINEAR: {
                return Linear.easeOut(currentTime, min, max, totalTime);
            }
            case QUAD: {
                return Quad.easeOut(currentTime, min, max, totalTime);
            }
            case QUART: {
                return Quart.easeOut(currentTime, min, max, totalTime);
            }
            case QUINT: {
                return Quint.easeOut(currentTime, min, max, totalTime);
            }
            case SINE: {
                return Sine.easeOut(currentTime, min, max, totalTime);
            }
        }
        return 0.0f;
    }

    public static float easeIn(float currentTime, float totalTime, float min, float max, EasingType easingType) {
        switch (easingType) {
            case BACK: {
                return Back.easeIn(currentTime, min, max, totalTime);
            }
            case BOUNCE: {
                return Bounce.easeIn(currentTime, min, max, totalTime);
            }
            case CIRC: {
                return Circ.easeIn(currentTime, min, max, totalTime);
            }
            case CUBIC: {
                return Cubic.easeIn(currentTime, min, max, totalTime);
            }
            case ELASTIC: {
                return Elastic.easeIn(currentTime, min, max, totalTime);
            }
            case EXPO: {
                return Expo.easeIn(currentTime, min, max, totalTime);
            }
            case LINEAR: {
                return Linear.easeIn(currentTime, min, max, totalTime);
            }
            case QUAD: {
                return Quad.easeIn(currentTime, min, max, totalTime);
            }
            case QUART: {
                return Quart.easeIn(currentTime, min, max, totalTime);
            }
            case QUINT: {
                return Quint.easeIn(currentTime, min, max, totalTime);
            }
            case SINE: {
                return Sine.easeIn(currentTime, min, max, totalTime);
            }
        }
        return 0.0f;
    }

    public static float easeInOut(float currentTime, float totalTime, float min, float max, EasingType easingType) {
        switch (easingType) {
            case BACK: {
                return Back.easeInOut(currentTime, min, max, totalTime);
            }
            case BOUNCE: {
                return Bounce.easeInOut(currentTime, min, max, totalTime);
            }
            case CIRC: {
                return Circ.easeInOut(currentTime, min, max, totalTime);
            }
            case CUBIC: {
                return Cubic.easeInOut(currentTime, min, max, totalTime);
            }
            case ELASTIC: {
                return Elastic.easeInOut(currentTime, min, max, totalTime);
            }
            case EXPO: {
                return Expo.easeInOut(currentTime, min, max, totalTime);
            }
            case LINEAR: {
                return Linear.easeInOut(currentTime, min, max, totalTime);
            }
            case QUAD: {
                return Quad.easeInOut(currentTime, min, max, totalTime);
            }
            case QUART: {
                return Quart.easeInOut(currentTime, min, max, totalTime);
            }
            case QUINT: {
                return Quint.easeInOut(currentTime, min, max, totalTime);
            }
            case SINE: {
                return Sine.easeInOut(currentTime, min, max, totalTime);
            }
        }
        return 0.0f;
    }

    public static ArrayList readEasing(ByteBuf buff) {
        ArrayList newList = new ArrayList();
        if (buff.readBoolean()) {
            newList = Easing.setEasing(EasingType.values()[buff.readInt()], EasingTypeIO.values()[buff.readInt()], buff.readFloat(), buff.readFloat(), buff.readFloat(), EasingTypeMode.values()[buff.readInt()]);
        }
        return newList;
    }

    public static void writeEasing(ByteBuf buff, ArrayList list) {
        buff.writeBoolean(list.size() == 7);
        if (list.size() != 7) {
            return;
        }
        buff.writeInt(((EasingType)((Object)list.get(0))).ordinal());
        buff.writeInt(((EasingTypeIO)((Object)list.get(1))).ordinal());
        buff.writeFloat(((Float)list.get(2)).floatValue());
        buff.writeFloat(((Float)list.get(3)).floatValue());
        buff.writeFloat(((Float)list.get(4)).floatValue());
        buff.writeInt(((EasingTypeMode)((Object)list.get(5))).ordinal());
    }

    public static enum EasingTypeMode {
        DEFAULT,
        LOOP,
        REPEAT;

    }

    public static enum EasingTypeIO {
        IN,
        OUT,
        INOUT;

    }

    public static enum EasingType {
        BACK,
        BOUNCE,
        CIRC,
        CUBIC,
        ELASTIC,
        EXPO,
        LINEAR,
        QUAD,
        QUART,
        QUINT,
        SINE;

    }
}

