/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.face;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetType;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IAlignable;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IAutoTranslateable;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class Box2D
extends WidgetGLOverlay
implements IAutoTranslateable,
IAlignable {
    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        this.writeDataSIZE(buff);
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        this.readDataSIZE(buff);
    }

    @Override
    public WidgetType getType() {
        return WidgetType.BOX2D;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableBox2DWidget();
    }

    @SideOnly(value=Side.CLIENT)
    public class RenderableBox2DWidget
    extends WidgetGLOverlay.RenderableGLWidget {
        public RenderableBox2DWidget() {
            super(Box2D.this);
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            this.preRender(conditionStates);
            this.applyModifiers(conditionStates);
            this.applyAlignments();
            float[] col1 = this.getCurrentColorFloat(conditionStates, 1);
            float[] col2 = this.getCurrentColorFloat(conditionStates, 0);
            Tessellator tessellator = Tessellator.func_178181_a();
            this.createGradient(tessellator.func_178180_c(), col1, col1, col2, col2);
            tessellator.func_78381_a();
            this.postRender();
        }

        public void createGradient(BufferBuilder buff, float[] col1, float[] col2, float[] col3, float[] col4) {
            buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buff.func_181662_b(0.0, 0.0, 0.0).func_181666_a(col1[0], col1[1], col1[2], col1[3]).func_181675_d();
            buff.func_181662_b(0.0, (double)Box2D.this.height, 0.0).func_181666_a(col2[0], col2[1], col2[2], col2[3]).func_181675_d();
            buff.func_181662_b((double)Box2D.this.width, (double)Box2D.this.height, 0.0).func_181666_a(col3[0], col3[1], col3[2], col3[3]).func_181675_d();
            buff.func_181662_b((double)Box2D.this.width, 0.0, 0.0).func_181666_a(col4[0], col4[1], col4[2], col4[3]).func_181675_d();
        }

        public void drawUVMappedRect(BufferBuilder buff, float minU, float maxU, float minV, float maxV) {
            buff.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buff.func_181662_b(0.0, 0.0, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
            buff.func_181662_b(0.0, (double)Box2D.this.height, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            buff.func_181662_b((double)Box2D.this.width, (double)Box2D.this.height, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
            buff.func_181662_b((double)Box2D.this.width, 0.0, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        }

        public void applyAlignments() {
            switch (this.getHorizontalAlign()) {
                case CENTER: {
                    GL11.glTranslatef((float)(Box2D.this.width / 2.0f), (float)0.0f, (float)0.0f);
                    break;
                }
                case LEFT: {
                    GL11.glTranslatef((float)(-Box2D.this.width), (float)0.0f, (float)0.0f);
                }
            }
            switch (this.getVerticalAlign()) {
                case MIDDLE: {
                    GL11.glTranslatef((float)0.0f, (float)(-Box2D.this.height / 2.0f), (float)0.0f);
                    break;
                }
                case TOP: {
                    GL11.glTranslatef((float)0.0f, (float)(-Box2D.this.height), (float)0.0f);
                }
            }
        }
    }
}

