/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets.component.common;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLOverlay;
import ben_mkiv.rendertoolkit.common.widgets.WidgetGLWorld;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IFluid;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class FluidWidget
extends WidgetGLWorld
implements IFluid {
    private FluidStack fluidStack = null;

    public FluidWidget() {
        this.height = 16.0f;
        this.width = 16.0f;
    }

    @Override
    public void writeData(ByteBuf buff) {
        super.writeData(buff);
        if (this.fluidStack != null) {
            ByteBufUtils.writeTag((ByteBuf)buff, (NBTTagCompound)this.fluidStack.writeToNBT(new NBTTagCompound()));
        } else {
            ByteBufUtils.writeTag((ByteBuf)buff, (NBTTagCompound)new NBTTagCompound());
        }
    }

    @Override
    public void readData(ByteBuf buff) {
        super.readData(buff);
        NBTTagCompound fluid = ByteBufUtils.readTag((ByteBuf)buff);
        if (new NBTTagCompound().equals((Object)fluid)) {
            this.setFluid(null);
        } else {
            this.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluid));
        }
    }

    @Override
    public void setFluid(FluidStack newStack) {
        this.fluidStack = newStack;
    }

    @Override
    public Fluid getFluid() {
        return this.fluidStack != null ? this.fluidStack.getFluid() : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderableWidget getRenderable() {
        return new RenderableFluidIcon();
    }

    public class RenderableFluidIcon
    extends WidgetGLOverlay.RenderableGLWidget {
        Minecraft mc;

        public RenderableFluidIcon() {
            super(FluidWidget.this);
            this.mc = Minecraft.func_71410_x();
        }

        @Override
        public void render(EntityPlayer player, Vec3d renderOffset, long conditionStates) {
            if (FluidWidget.this.getFluid() == null) {
                return;
            }
            TextureAtlasSprite fluidSprite = this.getStillFluidSprite(FluidWidget.this.getFluid());
            int alphaColor = this.preRender(conditionStates);
            this.applyModifiers(conditionStates);
            if (FluidWidget.this.rendertype == RenderType.WorldLocated) {
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (FluidWidget.this.faceWidgetToPlayer) {
                    GlStateManager.func_179114_b((float)player.field_70177_z, (float)0.0f, (float)-1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            } else {
                this.applyAlignments();
            }
            TextureManager tm = this.mc.func_110434_K();
            tm.func_110577_a(TextureMap.field_110575_b);
            tm.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferBuilder.func_181662_b(renderOffset.field_72450_a, renderOffset.field_72448_b + (double)FluidWidget.this.height, 1.0).func_187315_a((double)fluidSprite.func_94209_e(), (double)fluidSprite.func_94210_h()).func_181675_d();
            bufferBuilder.func_181662_b(renderOffset.field_72450_a + (double)FluidWidget.this.width, renderOffset.field_72448_b + (double)FluidWidget.this.height, 1.0).func_187315_a((double)fluidSprite.func_94212_f(), (double)fluidSprite.func_94210_h()).func_181675_d();
            bufferBuilder.func_181662_b(renderOffset.field_72450_a + (double)FluidWidget.this.width, renderOffset.field_72448_b, 1.0).func_187315_a((double)fluidSprite.func_94212_f(), (double)fluidSprite.func_94206_g()).func_181675_d();
            bufferBuilder.func_181662_b(renderOffset.field_72450_a, renderOffset.field_72448_b, 1.0).func_187315_a((double)fluidSprite.func_94209_e(), (double)fluidSprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
            this.postRender();
        }

        private void setGLColorFromInt(int color) {
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
        }

        private TextureAtlasSprite getStillFluidSprite(Fluid fluid) {
            if (fluid.getStill() != null) {
                return this.mc.func_147117_R().getTextureExtry(fluid.getStill().toString());
            }
            return this.mc.func_147117_R().func_174944_f();
        }

        private void applyAlignments() {
            switch (this.getHorizontalAlign()) {
                case CENTER: {
                    GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)0.0f);
                    break;
                }
                case RIGHT: {
                    GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                }
            }
            switch (this.getVerticalAlign()) {
                case MIDDLE: {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
                    break;
                }
                case BOTTOM: {
                    GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                }
            }
        }
    }
}

