/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.widgets;

import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IPrivate;
import ben_mkiv.rendertoolkit.common.widgets.core.attribute.IResizable;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class WidgetGLOverlay
extends Widget
implements IResizable,
IPrivate {
    public RenderType rendertype = RenderType.GameOverlayLocated;
    private Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
    private Vector3f margin = new Vector3f(0.0f, 0.0f, 0.0f);
    public float width = 1.0f;
    public float height = 1.0f;
    protected VAlignment valign = VAlignment.BOTTOM;
    protected HAlignment halign = HAlignment.RIGHT;
    boolean isThroughVisibility = false;
    private boolean isLookingAtEnable = false;
    public boolean cullFaces = true;
    public boolean faceWidgetToPlayer = false;
    private Vec3d lookAt = new Vec3d(0.0, 0.0, 0.0);
    private int viewDistance = 64;
    private long age = 0L;

    protected WidgetGLOverlay() {
    }

    @Override
    public void writeData(ByteBuf buff) {
        this.WidgetModifierList.writeData(buff);
        buff.writeInt(this.viewDistance);
        buff.writeDouble(this.lookAt.field_72450_a);
        buff.writeDouble(this.lookAt.field_72448_b);
        buff.writeDouble(this.lookAt.field_72449_c);
        buff.writeFloat(this.pos.x);
        buff.writeFloat(this.pos.y);
        buff.writeFloat(this.pos.z);
        buff.writeInt(this.valign.ordinal());
        buff.writeInt(this.halign.ordinal());
        buff.writeBoolean(this.isLookingAtEnable);
        buff.writeBoolean(this.cullFaces);
    }

    @Override
    public void readData(ByteBuf buff) {
        this.WidgetModifierList.readData(buff);
        this.viewDistance = buff.readInt();
        this.lookAt = new Vec3d(buff.readDouble(), buff.readDouble(), buff.readDouble());
        this.pos = new Vector3f(buff.readFloat(), buff.readFloat(), buff.readFloat());
        this.valign = VAlignment.values()[buff.readInt()];
        this.halign = HAlignment.values()[buff.readInt()];
        this.isLookingAtEnable = buff.readBoolean();
        this.cullFaces = buff.readBoolean();
    }

    protected void writeDataSIZE(ByteBuf buff) {
        buff.writeFloat(this.width);
        buff.writeFloat(this.height);
    }

    protected void readDataSIZE(ByteBuf buff) {
        this.width = buff.readFloat();
        this.height = buff.readFloat();
    }

    @Override
    public void setSize(double w, double h) {
        this.width = (float)w;
        this.height = (float)h;
    }

    public Vector3f getPosition() {
        return this.pos;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public int getDistanceView() {
        return this.viewDistance;
    }

    public void setDistanceView(int distance) {
        this.viewDistance = distance;
    }

    public void setLookingAt(double x, double y, double z) {
        this.lookAt = new Vec3d(x, y, z);
    }

    public boolean isLookingAtEnable() {
        return this.isLookingAtEnable;
    }

    public void setLookingAtEnable(boolean enable) {
        this.isLookingAtEnable = enable;
    }

    public void setFaceWidgetToPlayer(boolean enable) {
        this.faceWidgetToPlayer = enable;
    }

    public double getLookingAtX() {
        return this.lookAt.field_72450_a;
    }

    public double getLookingAtY() {
        return this.lookAt.field_72448_b;
    }

    public double getLookingAtZ() {
        return this.lookAt.field_72449_c;
    }

    public void setVerticalAlignment(String align) {
        this.valign = VAlignment.valueOf(align.toUpperCase());
    }

    public void setHorizontalAlignment(String align) {
        this.halign = HAlignment.valueOf(align.toUpperCase());
    }

    @SideOnly(value=Side.CLIENT)
    public abstract class RenderableGLWidget
    implements IRenderableWidget {
        boolean doBlending;
        boolean doTexture;
        boolean doSmoothShade;
        boolean doAlpha;

        void setRenderFlags() {
            this.doBlending = false;
            this.doTexture = false;
            this.doSmoothShade = false;
            if (WidgetGLOverlay.this.isThroughVisibility) {
                GlStateManager.func_179097_i();
            } else {
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179140_f();
            block10: for (WidgetModifier modifier : WidgetGLOverlay.this.WidgetModifierList.modifiers) {
                switch (modifier.getType()) {
                    case COLOR: {
                        if (((Float)modifier.getValues()[3]).floatValue() == 1.0f) continue block10;
                        this.doAlpha = true;
                        this.doBlending = true;
                        GlStateManager.func_179126_j();
                        GlStateManager.func_179132_a((boolean)true);
                        continue block10;
                    }
                    case TEXTURE: {
                        this.doTexture = true;
                        continue block10;
                    }
                }
            }
            switch (WidgetGLOverlay.this.getType()) {
                case BOX2D: {
                    this.doAlpha = true;
                    this.doBlending = true;
                    this.doSmoothShade = true;
                    break;
                }
                case TEXT2D: 
                case TEXT3D: {
                    this.doAlpha = true;
                    this.doBlending = true;
                    this.doTexture = true;
                    break;
                }
                case FLUID2D: 
                case ENTITY2D: 
                case OCSCREEN2D: 
                case OCSCREEN3D: 
                case ITEM2D: {
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179132_a((boolean)true);
                }
                case ITEM3D: {
                    this.doAlpha = true;
                    this.doBlending = true;
                    this.doTexture = true;
                }
            }
            if (this.doTexture) {
                GlStateManager.func_179098_w();
            } else {
                GlStateManager.func_179090_x();
            }
            if (this.doBlending) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
            } else {
                GlStateManager.func_179084_k();
            }
            GlStateManager.func_179103_j((int)(this.doSmoothShade ? 7425 : 7424));
            if (this.doAlpha) {
                GlStateManager.func_179141_d();
            } else {
                GlStateManager.func_179118_c();
            }
        }

        public int preRender(long conditionStates) {
            WidgetGLOverlay.this.age++;
            this.setRenderFlags();
            if (WidgetGLOverlay.this.age % 50L == 0L) {
                this.updateRenderPosition(conditionStates);
            }
            if (!WidgetGLOverlay.this.cullFaces) {
                GlStateManager.func_179129_p();
            }
            return WidgetGLOverlay.this.WidgetModifierList.getCurrentColor(conditionStates, 0);
        }

        void updateRenderPosition(long conditionStates) {
            this.updateRenderPosition(conditionStates, new Vec3d(0.0, 0.0, 0.0));
        }

        void updateRenderPosition(long conditionStates, Vec3d renderOrigin) {
            Vec3d renderPosition = WidgetGLOverlay.this.WidgetModifierList.getRenderPosition(conditionStates, renderOrigin, ClientSurface.resolution.func_78326_a(), ClientSurface.resolution.func_78328_b(), 1);
            WidgetGLOverlay.this.pos = new Vector3f((float)renderPosition.field_72450_a, (float)renderPosition.field_72448_b, (float)renderPosition.field_72449_c);
            WidgetGLOverlay.this.pos.add((Tuple3f)WidgetGLOverlay.this.margin);
        }

        public int applyModifiers(long conditionStates) {
            WidgetGLOverlay.this.WidgetModifierList.apply(conditionStates);
            return WidgetGLOverlay.this.WidgetModifierList.getCurrentColor(WidgetGLOverlay.this.WidgetModifierList.lastConditionStates, 0);
        }

        protected void addPlayerRotation(EntityPlayer player) {
            if (!WidgetGLOverlay.this.faceWidgetToPlayer) {
                return;
            }
            GL11.glRotated((double)player.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(-player.field_70125_A), (double)1.0, (double)0.0, (double)0.0);
        }

        public void removePlayerRotation(EntityPlayer player) {
            if (!WidgetGLOverlay.this.faceWidgetToPlayer) {
                return;
            }
            GL11.glRotated((double)player.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-player.field_70177_z), (double)0.0, (double)1.0, (double)0.0);
        }

        public void addPlayerRotation(EntityPlayer player, Vec3d lookingAtVector) {
            if (!WidgetGLOverlay.this.faceWidgetToPlayer) {
                return;
            }
            GL11.glRotated((double)player.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
            if (lookingAtVector.field_72448_b > player.func_174791_d().field_72448_b + (double)1.8f) {
                GL11.glRotated((double)(-player.field_70125_A), (double)1.0, (double)0.0, (double)0.0);
            } else {
                GL11.glRotated((double)player.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
            }
        }

        public void removePlayerRotation(EntityPlayer player, Vec3d lookingAtVector) {
            if (!WidgetGLOverlay.this.faceWidgetToPlayer) {
                return;
            }
            if (lookingAtVector.field_72448_b > player.func_174791_d().field_72448_b + (double)1.8f) {
                GL11.glRotated((double)player.field_70125_A, (double)1.0, (double)0.0, (double)0.0);
            } else {
                GL11.glRotated((double)(-player.field_70125_A), (double)1.0, (double)0.0, (double)0.0);
            }
            GL11.glRotated((double)(-player.field_70177_z), (double)0.0, (double)1.0, (double)0.0);
        }

        protected void applyModifierList(long conditionStates, ArrayList<WidgetModifier.WidgetModifierType> modifierTypes) {
            for (WidgetModifier m : WidgetGLOverlay.this.WidgetModifierList.modifiers) {
                for (WidgetModifier.WidgetModifierType t : modifierTypes) {
                    if (!t.equals((Object)m.getType())) continue;
                    m.apply(conditionStates);
                }
            }
        }

        public void revokeModifierList(ArrayList<WidgetModifier.WidgetModifierType> modifierTypes) {
            WidgetGLOverlay.this.WidgetModifierList.revoke(WidgetGLOverlay.this.WidgetModifierList.lastConditionStates, modifierTypes);
        }

        public void revokeModifiers() {
            WidgetGLOverlay.this.WidgetModifierList.revoke(WidgetGLOverlay.this.WidgetModifierList.lastConditionStates);
        }

        protected float[] getCurrentColorFloat(long conditionStates, int index) {
            return WidgetGLOverlay.this.WidgetModifierList.getCurrentColorFloat(conditionStates, index);
        }

        public void postRender() {
            if (!WidgetGLOverlay.this.cullFaces) {
                GlStateManager.func_179089_o();
            }
        }

        @Override
        public boolean shouldWidgetBeRendered(EntityPlayer player) {
            return this.shouldWidgetBeRendered(player, new Vector3f(0.0f, 0.0f, 0.0f));
        }

        @Override
        public boolean shouldWidgetBeRendered(EntityPlayer player, Vector3f offset) {
            if (this.getRenderType().equals((Object)RenderType.WorldLocated)) {
                if (offset.equals((Tuple3f)ClientSurface.vec3f000)) {
                    return true;
                }
                offset.add((Tuple3f)WidgetGLOverlay.this.pos);
                Vec3d vec3d = new Vec3d((double)offset.x, (double)offset.y, (double)offset.z);
                if (Minecraft.func_71410_x().field_71439_g.func_174791_d().func_72438_d(vec3d) > (double)WidgetGLOverlay.this.viewDistance) {
                    return false;
                }
            }
            RayTraceResult pos = ClientSurface.getBlockCoordsLookingAt(player);
            if (WidgetGLOverlay.this.isLookingAtEnable && (pos == null || (double)pos.func_178782_a().func_177958_n() != ((WidgetGLOverlay)WidgetGLOverlay.this).lookAt.field_72450_a || (double)pos.func_178782_a().func_177956_o() != ((WidgetGLOverlay)WidgetGLOverlay.this).lookAt.field_72448_b || (double)pos.func_178782_a().func_177952_p() != ((WidgetGLOverlay)WidgetGLOverlay.this).lookAt.field_72449_c)) {
                return false;
            }
            return this.isVisible();
        }

        @Override
        public UUID getWidgetOwner() {
            return WidgetGLOverlay.this.getOwnerUUID();
        }

        @Override
        public RenderType getRenderType() {
            return WidgetGLOverlay.this.rendertype;
        }

        protected VAlignment getVerticalAlign() {
            return WidgetGLOverlay.this.valign;
        }

        protected HAlignment getHorizontalAlign() {
            return WidgetGLOverlay.this.halign;
        }

        @Override
        public boolean isVisible() {
            return WidgetGLOverlay.this.isVisible;
        }

        @Override
        public boolean isLookingAtEnabled() {
            return WidgetGLOverlay.this.isLookingAtEnable;
        }

        @Override
        public Vec3d lookingAtVector() {
            return WidgetGLOverlay.this.lookAt;
        }
    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

