/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.entity;

import ben_mkiv.rendertoolkit.bvhParser.Node;
import ben_mkiv.rendertoolkit.bvhParser.Skeleton;
import ben_mkiv.rendertoolkit.common.entity.BonedPart;
import ben_mkiv.rendertoolkit.common.entity.ModelOBJ;
import java.util.HashMap;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.obj.OBJModel;
import org.lwjgl.util.vector.Quaternion;

public abstract class ModelOBJBVH
extends ModelOBJ {
    public HashMap<String, BonedPart> parts = new HashMap();

    public ModelOBJBVH(ResourceLocation objFile, ResourceLocation bvhFile) {
        super(objFile, false);
        String name;
        Skeleton skeleton;
        try {
            System.out.println("loading bvh skeleton nodes from " + bvhFile.toString());
            skeleton = new Skeleton(bvhFile);
        }
        catch (Exception ex) {
            System.out.println("couldnt load bvh data from " + bvhFile.toString());
            return;
        }
        if (skeleton.getRootNode() == null) {
            System.out.println("missing bvh root");
            return;
        }
        for (OBJModel.Group group : this.model.getMatLib().getGroups().values()) {
            name = group.getName();
            Node bone = null;
            for (Node node : skeleton.getRootNode().getChildrens()) {
                if (!node.getName().equals(name)) continue;
                bone = node;
                break;
            }
            if (bone == null) continue;
            Vector4f offset = new Vector4f(bone.getOffset());
            for (OBJModel.Face face : group.getFaces()) {
                for (OBJModel.Vertex v : face.getVertices()) {
                    Vector4f tmpV = v.getPos();
                    tmpV.sub((Tuple4f)offset);
                    v.setPos(tmpV);
                }
            }
        }
        this.loadModelGroups();
        for (Node node : skeleton.getRootNode().getChildrens()) {
            name = node.getName();
            if (!this.modelParts.containsKey(name)) continue;
            this.parts.put(name, new BonedPart((IBakedModel)this.modelParts.get(name), (OBJModel.OBJState)this.IModelParts.get(name), node));
            System.out.println("added boned part: " + node.getName());
        }
    }

    public static void renderPart(BonedPart part) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)part.getPosition().field_72450_a, (double)part.getPosition().field_72448_b, (double)part.getPosition().field_72449_c);
        GlStateManager.func_187444_a((Quaternion)part.getRotation());
        ModelOBJBVH.renderPart(part.getModel());
        GlStateManager.func_179121_F();
    }
}

