/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.common.entity;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;

public class ModelOBJ {
    protected OBJModel model;
    public HashMap<String, IBakedModel> modelParts = new HashMap();
    public HashMap<String, OBJModel.OBJState> IModelParts = new HashMap();
    private static Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        @Override
        public TextureAtlasSprite apply(ResourceLocation location) {
            return DummyAtlasTexture.instance;
        }
    };

    public ModelOBJ(ResourceLocation objFile, boolean bakeModelGroups) {
        try {
            System.out.println("loading object model from " + objFile.toString());
            this.model = (OBJModel)OBJLoader.INSTANCE.loadModel(objFile);
        }
        catch (Exception ex) {
            System.out.println("couldnt load object model from " + objFile.toString());
            return;
        }
        if (bakeModelGroups) {
            this.loadModelGroups();
        }
    }

    public static void renderPart(IBakedModel part) {
        if (part == null) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        buff.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad bakedQuad : part.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((BufferBuilder)buff, (BakedQuad)bakedQuad, (int)-1);
        }
        tessellator.func_78381_a();
    }

    public void loadModelGroups() {
        for (String groupName : this.model.getMatLib().getGroups().keySet()) {
            this.IModelParts.put(groupName, this.getPartIModelState(groupName));
            this.modelParts.put(groupName, this.getPartBakedModel(groupName));
        }
    }

    public IBakedModel getPartBakedModel(String groupName) {
        if (!this.IModelParts.containsKey(groupName)) {
            this.IModelParts.put(groupName, this.getPartIModelState(groupName));
        }
        return this.model.bake((IModelState)this.IModelParts.get(groupName), Attributes.DEFAULT_BAKED_FORMAT, textureGetter);
    }

    public OBJModel.OBJState getPartIModelState(String groupName) {
        return new OBJModel.OBJState((List)ImmutableList.of((Object)groupName), false, this.model.getDefaultState());
    }

    private static class DummyAtlasTexture
    extends TextureAtlasSprite {
        public static DummyAtlasTexture instance = new DummyAtlasTexture();

        DummyAtlasTexture() {
            super("dummy");
        }
    }
}

