/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client.thermalvision;

import ben_mkiv.rendertoolkit.client.OptifineHelper;
import ben_mkiv.rendertoolkit.client.thermalvision.ThermalEntityRender;
import ben_mkiv.rendertoolkit.client.thermalvision.ThermalEntityRenderer;
import ben_mkiv.rendertoolkit.renderToolkit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ShaderHelper {
    private static boolean isActive = false;
    private static ResourceLocation resourceLocationShaderOverlay = new ResourceLocation("rendertoolkit", "shaders/post/thermal_overlay.json");
    private static ResourceLocation resourceLocationShaderBlur = new ResourceLocation("rendertoolkit", "shaders/post/thermal_blur.json");
    private static ScaledResolution framebufferResolution;
    private static ThermalEntityRender renderEventHandler;
    private static ThermalEntityRenderer thermalEntityRendererOverlay;
    static ThermalEntityRenderer thermalEntityRendererBlur;
    private static long fastRenderNotificationTimeout;

    public static void setupThermalShader(boolean activate) {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        if (activate) {
            if (thermalEntityRendererOverlay == null || thermalEntityRendererBlur == null) {
                ShaderHelper.resetFramebuffers();
            }
            MinecraftForge.EVENT_BUS.register((Object)renderEventHandler);
            if (renderToolkit.Optifine && OptifineHelper.isFastRenderEnabled() && fastRenderNotificationTimeout != -1L) {
                fastRenderNotificationTimeout = System.currentTimeMillis() + 7000L;
            }
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)renderEventHandler);
            if (fastRenderNotificationTimeout != -1L) {
                fastRenderNotificationTimeout = 0L;
            }
        }
        isActive = activate;
    }

    public static void resetFramebuffers() {
        Minecraft mc = Minecraft.func_71410_x();
        framebufferResolution = new ScaledResolution(mc);
        thermalEntityRendererOverlay = new ThermalEntityRenderer(resourceLocationShaderOverlay, mc.func_147110_a());
        thermalEntityRendererBlur = new ThermalEntityRenderer(resourceLocationShaderBlur, new Framebuffer(mc.field_71443_c, mc.field_71440_d, true));
    }

    public static void render(RenderGameOverlayEvent event) {
        if (thermalEntityRendererOverlay == null || thermalEntityRendererBlur == null) {
            return;
        }
        if (event.getResolution().func_78326_a() != framebufferResolution.func_78326_a() || event.getResolution().func_78328_b() != framebufferResolution.func_78328_b()) {
            ShaderHelper.resetFramebuffers();
        }
        if (!(ThermalEntityRender.fastRenderEnabled &= !renderToolkit.Optifine || OptifineHelper.isFastRenderEnabled())) {
            thermalEntityRendererOverlay.func_147706_e().func_148018_a(event.getPartialTicks());
            thermalEntityRendererBlur.func_147706_e().func_148018_a(event.getPartialTicks());
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147110_a().func_147610_a(false);
        GlStateManager.func_179147_l();
        thermalEntityRendererBlur.func_147706_e().func_177066_a("final").func_178038_a(mc.field_71443_c, mc.field_71440_d, false);
        if (!ThermalEntityRender.fastRenderEnabled) {
            thermalEntityRendererBlur.func_147706_e().func_177066_a("in").func_147614_f();
        }
        GlStateManager.func_179084_k();
    }

    public static boolean isActive() {
        return isActive;
    }

    public static void renderFastRenderNotification() {
        if (!ThermalEntityRender.fastRenderEnabled || fastRenderNotificationTimeout <= 0L) {
            return;
        }
        if (System.currentTimeMillis() > fastRenderNotificationTimeout) {
            fastRenderNotificationTimeout = -1L;
        }
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        String text = "ThermalVision is best experienced with Optifine FastRender disabled";
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = res.func_78326_a() / 2 - fr.func_78256_a(text) / 2;
        int y = res.func_78328_b() / 2 - 2 * fr.field_78288_b;
        fr.func_78276_b(text, x, y, 0xFFFFFF);
    }

    static {
        renderEventHandler = new ThermalEntityRender();
        thermalEntityRendererOverlay = null;
        thermalEntityRendererBlur = null;
        fastRenderNotificationTimeout = 0L;
    }
}

