/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client.shaders;

import ben_mkiv.rendertoolkit.client.thermalvision.ShaderHelper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL11;

public final class VazkiiShaderHelper {
    private static final int VERT = 35633;
    private static final int FRAG = 35632;
    static HashSet<ShaderTemplate> shaders = new HashSet();
    private static boolean lighting;

    public static int getShaderIndex(@Nonnull String vertexShaderLocation, @Nonnull String fragmentShaderLocation) {
        for (ShaderTemplate shader : shaders) {
            if (!shader.fragmentShader.equals(fragmentShaderLocation) || !shader.vertexShader.equals(vertexShaderLocation)) continue;
            return shader.index;
        }
        return -1;
    }

    public static void initShader(@Nonnull String vertexShaderLocation, @Nonnull String fragmentShaderLocation, ShaderCallback shaderInitCallback) {
        if (VazkiiShaderHelper.getShaderIndex(vertexShaderLocation, fragmentShaderLocation) != -1) {
            return;
        }
        if (Minecraft.func_71410_x().func_110442_L() instanceof SimpleReloadableResourceManager) {
            ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(manager -> {
                if (VazkiiShaderHelper.useShaders()) {
                    shaders.add(new ShaderTemplate(vertexShaderLocation, fragmentShaderLocation, shaderInitCallback));
                }
            });
        }
    }

    public static void useShader(int shader, ShaderCallback callback) {
        if (!VazkiiShaderHelper.useShaders() || shader == 0) {
            return;
        }
        lighting = GL11.glGetBoolean((int)2896);
        GlStateManager.func_179140_f();
        ARBShaderObjects.glUseProgramObjectARB((int)shader);
        if (callback != null) {
            callback.call(shader);
        }
    }

    public static void releaseShader() {
        if (lighting) {
            GlStateManager.func_179145_e();
        }
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    public static boolean useShaders() {
        return OpenGlHelper.field_148824_g;
    }

    public static int createProgram(String vert, String frag) {
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        if (program == 0) {
            return 0;
        }
        if (!vert.equals("")) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)VazkiiShaderHelper.createShader(vert, 35633));
        }
        if (!frag.equals("")) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)VazkiiShaderHelper.createShader(frag, 35632));
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            System.out.println(VazkiiShaderHelper.getLogInfo(program));
            return 0;
        }
        ARBShaderObjects.glValidateProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35715) == 0) {
            System.out.println(VazkiiShaderHelper.getLogInfo(program));
            return 0;
        }
        return program;
    }

    private static int createShader(String filename, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)VazkiiShaderHelper.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + VazkiiShaderHelper.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private static String getLogInfo(int shader) {
        return ARBShaderObjects.glGetInfoLogARB((int)shader, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716));
    }

    private static String readFileAsString(String filename) throws Exception {
        InputStream in = ShaderHelper.class.getResourceAsStream(filename);
        if (in == null) {
            return "";
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    @FunctionalInterface
    public static interface ShaderCallback {
        public void call(int var1);
    }

    static class ShaderTemplate {
        public String vertexShader;
        public String fragmentShader;
        public int index;

        public ShaderTemplate(String vertexShaderLocation, String fragmentShaderLocation, ShaderCallback callback) {
            this.vertexShader = vertexShaderLocation;
            this.fragmentShader = fragmentShaderLocation;
            callback.call(VazkiiShaderHelper.createProgram(vertexShaderLocation, fragmentShaderLocation));
        }
    }
}

