/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.client.renderer;

import ben_mkiv.rendertoolkit.client.event.ClientEventHandler;
import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.Widget;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientRenderer {
    public static ClientEventHandler eventHandler;
    public Map<Integer, IRenderableWidget> renderables = new ConcurrentHashMap<Integer, IRenderableWidget>();
    public Map<Integer, IRenderableWidget> renderablesWorld = new ConcurrentHashMap<Integer, IRenderableWidget>();
    public static ScaledResolution resolution;
    public static Vec3d renderResolution;

    public void updateWidgets(Set<Map.Entry<Integer, Widget>> widgets) {
        for (Map.Entry<Integer, Widget> widget : widgets) {
            IRenderableWidget r = widget.getValue().getRenderable();
            switch (r.getRenderType()) {
                case GameOverlayLocated: {
                    this.renderables.put(widget.getKey(), r);
                    break;
                }
                case WorldLocated: {
                    this.renderablesWorld.put(widget.getKey(), r);
                }
            }
        }
    }

    public int getWidgetCount() {
        return this.renderables.size() + this.renderablesWorld.size();
    }

    public void removeWidgets(List<Integer> ids) {
        for (Integer id : ids) {
            this.renderables.remove(id);
            this.renderablesWorld.remove(id);
        }
    }

    public void removeAllWidgets() {
        this.renderables.clear();
        this.renderablesWorld.clear();
    }

    public boolean shouldWidgetBeRendered(EntityPlayer player, IRenderableWidget widget) {
        return widget.shouldWidgetBeRendered(player);
    }

    public void preRender(EntityPlayer player) {
    }

    public long getConditionStates(EntityPlayer player) {
        return 0L;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent evt) {
        if (evt.getType() != RenderGameOverlayEvent.ElementType.HELMET) {
            return;
        }
        if (!(evt instanceof RenderGameOverlayEvent.Post)) {
            return;
        }
        if (!this.shouldRenderStart(true)) {
            return;
        }
        if (this.renderables.size() < 1) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.preRender((EntityPlayer)player);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        if (renderResolution != null) {
            GL11.glScaled((double)((double)resolution.func_78326_a() / ClientRenderer.renderResolution.field_72450_a), (double)((double)resolution.func_78328_b() / ClientRenderer.renderResolution.field_72448_b), (double)1.0);
        }
        for (IRenderableWidget renderable : this.renderables.values()) {
            if (!this.shouldWidgetBeRendered((EntityPlayer)player, renderable)) continue;
            GL11.glPushMatrix();
            renderable.render((EntityPlayer)player, this.getRenderOffset(), this.getConditionStates((EntityPlayer)player));
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public boolean shouldRenderStart(boolean renderingOverlay) {
        return renderingOverlay;
    }

    public double[] getEntityPlayerLocation(EntityPlayer e, float partialTicks) {
        double x = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks;
        double y = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks;
        double z = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks;
        return new double[]{x, y, z};
    }

    public Vec3d getRenderOffset() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (this.renderablesWorld.size() < 1) {
            return;
        }
        if (!this.shouldRenderStart(false)) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double[] playerLocation = this.getEntityPlayerLocation((EntityPlayer)player, event.getPartialTicks());
        this.preRender((EntityPlayer)player);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-playerLocation[0]), (double)(-playerLocation[1]), (double)(-playerLocation[2]));
        GL11.glTranslated((double)this.getRenderOffset().field_72450_a, (double)this.getRenderOffset().field_72448_b, (double)this.getRenderOffset().field_72449_c);
        GL11.glDepthMask((boolean)true);
        for (IRenderableWidget renderable : this.renderablesWorld.values()) {
            if (!this.shouldWidgetBeRendered((EntityPlayer)player, renderable)) continue;
            GL11.glPushMatrix();
            renderable.render((EntityPlayer)player, this.getRenderOffset(), this.getConditionStates((EntityPlayer)player));
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    static {
        resolution = new ScaledResolution(Minecraft.func_71410_x());
        renderResolution = null;
    }
}

