/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.bvhParser;

import ben_mkiv.rendertoolkit.bvhParser.BVHParser;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Node {
    private final Type type;
    private String name;
    private final Vector4d offset = new Vector4d();
    private String[] channels;
    private final Node parent;
    private final List<Node> childrens = new ArrayList<Node>();
    private static final Matrix4d transformTmp = new Matrix4d();
    private final Matrix4d transform = new Matrix4d();
    private final Vector4d position = new Vector4d();
    private static final int[] DATA_INDEX = new int[]{0};

    public Node(BVHParser parser) {
        this(parser, Type.ROOT, null);
    }

    public Node(BVHParser parser, Type type, Node parent) {
        this.type = type;
        this.parent = parent;
        switch (type) {
            case ROOT: {
                parser.expect("HIERARCHY");
                this.name = parser.expect("ROOT")[1];
                break;
            }
            case JOINT: {
                this.name = parser.expect("JOINT")[1];
                break;
            }
            case END: {
                this.name = parser.expect("End")[1];
            }
        }
        parser.expect("{");
        this.setOffset(parser.expect("OFFSET"));
        if (parser.getLine().startsWith("CHANNELS")) {
            this.setChannels(parser.expect("CHANNELS"));
        }
        while (parser.getLine().startsWith("JOINT")) {
            this.childrens.add(new Node(parser, Type.JOINT, this));
        }
        if (parser.getLine().startsWith("End")) {
            this.childrens.add(new Node(parser, Type.END, this));
        }
        parser.expect("}");
    }

    private void setOffset(String[] offsetStr) {
        this.offset.setX(Double.parseDouble(offsetStr[1]));
        this.offset.setY(Double.parseDouble(offsetStr[3]));
        this.offset.setZ(-Double.parseDouble(offsetStr[2]));
        this.offset.setW(1.0);
    }

    private void setChannels(String[] channelsTmp) {
        int size = Integer.parseInt(channelsTmp[1]);
        this.channels = new String[size];
        for (int i = 0; i < size; ++i) {
            this.channels[i] = channelsTmp[2 + i].toLowerCase();
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Vector4d getOffset() {
        return this.offset;
    }

    public Vector4d getPosition() {
        return this.position;
    }

    public Matrix4d getTransform() {
        return this.transform;
    }

    public String[] getChannels() {
        return this.channels;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChildrens() {
        return this.childrens;
    }

    public void fillNodesList(List<Node> nodes) {
        if (this.type == Type.ROOT) {
            nodes.clear();
        }
        if (!nodes.contains(this)) {
            nodes.add(this);
        }
        for (Node children : this.childrens) {
            children.fillNodesList(nodes);
        }
    }

    public void setPose(double[] data) {
        this.transform.setIdentity();
        Node.DATA_INDEX[0] = 0;
        this.setPose(data, DATA_INDEX);
    }

    private void setPose(double[] data, int[] dataIndex) {
        if (this.type == Type.ROOT) {
            this.transform.setTranslation(new Vector3d(this.offset.x, this.offset.y, this.offset.z));
        } else {
            this.transform.set(this.parent.getTransform());
            transformTmp.setTranslation(new Vector3d(this.offset.x, this.offset.y, this.offset.z));
            this.transform.mul(transformTmp);
        }
        if (this.channels != null && data != null) {
            for (int c = 0; c < this.channels.length; ++c) {
                String channel = this.channels[c];
                int n = dataIndex[0];
                dataIndex[0] = n + 1;
                double value = data[n];
                if (channel.equals("xposition")) {
                    transformTmp.setTranslation(new Vector3d(value, 0.0, 0.0));
                } else if (channel.equals("yposition")) {
                    transformTmp.setTranslation(new Vector3d(0.0, value, 0.0));
                } else if (channel.equals("zposition")) {
                    transformTmp.transform(new Vector3d(0.0, 0.0, value));
                } else if (channel.equals("zrotation")) {
                    transformTmp.rotX(Math.toRadians(value));
                } else if (channel.equals("yrotation")) {
                    transformTmp.rotY(Math.toRadians(value));
                } else if (channel.equals("xrotation")) {
                    transformTmp.rotZ(Math.toRadians(value));
                }
                this.transform.mul(transformTmp);
            }
        }
        this.position.set(0.0, 0.0, 0.0, 1.0);
        this.transform.transform((Tuple4d)this.position);
        for (Node children : this.childrens) {
            children.setPose(data, dataIndex);
        }
    }

    public static enum Type {
        ROOT,
        JOINT,
        END;

    }
}

