/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.rendertoolkit.bvhParser;

import ben_mkiv.rendertoolkit.bvhParser.BVHParser;

public class Motion {
    private int frameSize;
    private double frameTime;
    private double[][] data;

    public Motion(BVHParser parser) {
        parser.expect("MOTION");
        this.frameSize = Integer.parseInt(parser.expect("Frames:")[1]);
        this.frameTime = Double.parseDouble(parser.expect("Frame Time:")[2]);
        this.data = new double[this.frameSize][];
        for (int f = 0; f < this.frameSize; ++f) {
            String[] values = parser.getLine().split("\\ ");
            this.data[f] = new double[values.length];
            for (int d = 0; d < values.length; ++d) {
                this.data[f][d] = Double.parseDouble(values[d]);
            }
            parser.nextLine();
        }
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public double getFrameTime() {
        return this.frameTime;
    }

    public double[] getData(int frame) {
        return this.data[frame];
    }
}

