/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.commons0815.utils;

import com.google.common.base.Charsets;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class utilsCommon {
    public static ArrayList<BlockPos> getSquareOffsets(int radius) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int row = -radius; row <= radius; ++row) {
            for (int col = -radius; col <= radius; ++col) {
                ArrayList l = new ArrayList();
                list.add(new BlockPos(row, 0, col));
            }
        }
        return list;
    }

    public static TileEntity getTileEntity(int dimensionId, BlockPos pos) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dimensionId);
        if (world == null) {
            return null;
        }
        return world.func_175625_s(pos);
    }

    public static Map<BlockPos, Block> getSquareBlocks(World world, BlockPos pos, int radius) {
        HashMap<BlockPos, Block> list = new HashMap<BlockPos, Block>();
        for (BlockPos val : utilsCommon.getSquareOffsets(radius)) {
            list.put(val, world.func_180495_p(new BlockPos(pos.func_177958_n() + val.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + val.func_177952_p())).func_177230_c());
        }
        return list;
    }

    public static ArrayList<Class> getClassHierarchy(Class p) {
        ArrayList<Class> list = new ArrayList<Class>();
        list.add(p);
        while ((p = p.getSuperclass()) != null) {
            list.add(p);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<String> readResourceLocation(Class modClazz, String location) {
        ArrayList<String> arrayList;
        InputStream is = null;
        try {
            String line;
            is = modClazz.getClassLoader().getResourceAsStream(location);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            arrayList = lines;
            if (is == null) return arrayList;
        }
        catch (Throwable ignored) {
            try {
                ArrayList<String> arrayList2 = null;
                return arrayList2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            is.close();
            return arrayList;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public static ArrayList<String> readResourceLocation(Class modClazz, ResourceLocation rl) {
        return utilsCommon.readResourceLocation(modClazz, rl.func_110623_a());
    }

    public static String StringFromResourceLocation(Class modClazz, ResourceLocation rl) {
        return utilsCommon.list2string(utilsCommon.readResourceLocation(modClazz, rl));
    }

    public static String list2string(ArrayList<String> list) {
        String output = "";
        if (list != null) {
            for (String append : list) {
                output = output + "\n" + append;
            }
        }
        return output;
    }

    public static float clampFloat(float val, float min, float max) {
        return Math.max(min, Math.min(val, max));
    }

    public static int getIntFromColor(float red, float green, float blue, float alpha) {
        return new Color(utilsCommon.clampFloat(red, 0.0f, 1.0f), utilsCommon.clampFloat(green, 0.0f, 1.0f), utilsCommon.clampFloat(blue, 0.0f, 1.0f), utilsCommon.clampFloat(alpha, 0.0f, 1.0f)).getRGB();
    }

    public static int getIntFromColor(float[] color, float alpha) {
        return new Color(color[0], color[1], color[2], alpha).getRGB();
    }

    public static Vector3f getVector3fFromColor(int color) {
        Color col = new Color(color);
        return new Vector3f((float)col.getRed(), (float)col.getGreen(), (float)col.getBlue());
    }

    public static int getIntFromColor(float red, float green, float blue) {
        return utilsCommon.getIntFromColor(red, green, blue, 0.0f);
    }

    public static boolean isIntColorVisible(int color) {
        return (color & 0xFF) > 0;
    }

    public static float deg2rad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static boolean inRange(double x, double y, double z, double sx, double sy, double sz, double r) {
        return (x - sx) * (x - sx) + (y - sy) * (y - sy) + (z - sz) * (z - sz) <= r * r;
    }

    public static boolean inRange(Entity player, double sx, double sy, double sz, double r) {
        return player.func_174791_d().func_72438_d(new Vec3d(sx, sy, sz)) <= r;
    }

    public static boolean inRange(Entity player, Vec3d pos, double r) {
        return player.func_174791_d().func_72438_d(pos) <= r;
    }

    public static boolean isLookingAt(RayTraceResult pos, float[] target) {
        if (pos == null) {
            return false;
        }
        if ((float)pos.func_178782_a().func_177958_n() != target[0]) {
            return false;
        }
        if ((float)pos.func_178782_a().func_177956_o() != target[1]) {
            return false;
        }
        return (float)pos.func_178782_a().func_177952_p() == target[2];
    }

    public static RayTraceResult rayTrace(Entity entity, double range, float tickAge) {
        Vec3d vec3d = entity.func_174824_e(tickAge);
        Vec3d vec3d1 = entity.func_70676_i(tickAge);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * range, vec3d1.field_72448_b * range, vec3d1.field_72449_c * range);
        return entity.func_130014_f_().func_72933_a(vec3d, vec3d2);
    }

    public static int getLightLevelPlayer(EntityPlayer e) {
        return e.field_70170_p.func_175642_b(EnumSkyBlock.SKY, new BlockPos(e.field_70165_t, e.field_70163_u + 1.0, e.field_70161_v));
    }

    public static boolean isPlayerSwimming(EntityPlayer e) {
        return e.field_70170_p.func_180495_p(new BlockPos(e.field_70165_t, e.field_70163_u, e.field_70161_v)).func_185904_a().func_76224_d() || e.field_70170_p.func_180495_p(new BlockPos(e.field_70165_t, e.field_70163_u + 1.0, e.field_70161_v)).func_185904_a().func_76224_d();
    }
}

