/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class IndexedSet<E extends IndexedElement>
extends AbstractList<E>
implements Set<E>,
RandomAccess {
    protected E[] array;
    protected int count;

    public IndexedSet(E[] initArray) {
        this.array = initArray;
    }

    @Override
    public boolean add(E e) {
        if (e.getIdx() >= 0) {
            return false;
        }
        if (this.count == this.array.length) {
            this.array = (IndexedElement[])Arrays.copyOf(this.array, this.array.length << 1);
        }
        this.array[this.count] = e;
        e.setIdx(this.count++);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int n = this.count + c.size();
        if (n > this.array.length) {
            this.array = (IndexedElement[])Arrays.copyOf(this.array, Math.max(n, this.array.length << 1));
        }
        return super.addAll(c);
    }

    @Override
    public void clear() {
        while (this.count > 0) {
            this.array[--this.count].setIdx(-1);
            this.array[this.count] = null;
        }
    }

    @Override
    public boolean contains(Object e) {
        if (e instanceof IndexedElement) {
            int i = ((IndexedElement)e).getIdx();
            return i >= 0 && i < this.count && this.array[i] == e;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof IndexedElement)) {
            return false;
        }
        IndexedElement e = (IndexedElement)o;
        int i = e.getIdx();
        if (i < 0 || i >= this.count || this.array[i] != e) {
            return false;
        }
        e.setIdx(-1);
        E e_ = this.array[--this.count];
        this.array[this.count] = null;
        if (i < this.count) {
            this.array[i] = e_;
            e_.setIdx(i);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            modified |= this.remove(e);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        BitSet register = new BitSet(this.count);
        for (Object o : c) {
            int i;
            if (!(o instanceof IndexedElement) || (i = ((IndexedElement)o).getIdx()) < 0 || i >= this.count || this.array[i] != o) continue;
            register.set(i);
        }
        boolean modified = false;
        int i = register.nextClearBit(0);
        while (i < this.count) {
            modified = true;
            E e = this.array[i];
            e.setIdx(-1);
            e = null;
            for (int j = this.count - 1; j > i; --j) {
                if (register.get(j)) {
                    e = this.array[j];
                    e.setIdx(i);
                    this.array[j] = null;
                    this.count = j;
                    break;
                }
                this.array[j].setIdx(-1);
                this.array[j] = null;
            }
            this.array[i] = e;
            if (e == null) {
                this.count = i;
            }
            i = register.nextClearBit(i + 1);
        }
        return modified;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.array, this.count);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.count) {
            a = Arrays.copyOf(a, this.count);
        }
        System.arraycopy(this.array, 0, a, 0, this.count);
        return a;
    }

    @Override
    public void forEach(Consumer<? super E> op) {
        for (int i = 0; i < this.count; ++i) {
            op.accept(this.array[i]);
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> op) {
        boolean modified = false;
        for (int i = 0; i < this.count; ++i) {
            E e = this.array[i];
            if (!op.test(e)) continue;
            e.setIdx(-1);
            e = this.array[--this.count];
            this.array[this.count] = null;
            if (i < this.count) {
                this.array[i] = e;
                e.setIdx(i);
            }
            modified = true;
        }
        return modified;
    }

    @Override
    public E get(int index) {
        return this.array[index];
    }

    @Override
    public E set(int i, E e) {
        if (e.getIdx() >= 0) {
            throw new IllegalArgumentException("Element must not be contained in an IndexedSet already!");
        }
        E e_ = this.array[i];
        e_.setIdx(-1);
        this.array[i] = e;
        e.setIdx(i);
        return e_;
    }

    @Override
    public void add(int i, E e) {
        int j = this.indexOf(e);
        if (j >= 0) {
            if (j == i) {
                return;
            }
            E e_ = this.array[i];
            e_.setIdx(j);
            this.array[j] = e_;
            e.setIdx(i);
            this.array[i] = e;
        } else if (i == this.count) {
            this.add(e);
        } else {
            this.add(this.set(i, e));
        }
    }

    @Override
    public E remove(int i) {
        E e = this.array[i];
        e.setIdx(-1);
        E e_ = this.array[--this.count];
        this.array[this.count] = null;
        if (i < this.count) {
            this.array[i] = e_;
            e_.setIdx(i);
        }
        return e;
    }

    @Override
    public int indexOf(Object o) {
        int idx;
        if (o instanceof IndexedElement && (idx = ((IndexedElement)o).getIdx()) >= 0 && idx < this.count && this.array[idx] == o) {
            return idx;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public Spliterator<E> spliterator() {
        return super.spliterator();
    }

    public static class Element
    implements IndexedElement {
        private int idx = -1;

        @Override
        public void setIdx(int idx) {
            this.idx = idx;
        }

        @Override
        public int getIdx() {
            return this.idx;
        }
    }

    public static interface IndexedElement {
        @Deprecated
        public void setIdx(int var1);

        public int getIdx();
    }
}

