/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.script.obj;

import cd4017be.lib.script.obj.Array;
import cd4017be.lib.script.obj.IOperand;
import cd4017be.lib.script.obj.Number;
import cd4017be.lib.script.obj.Vector;

public class Text
implements IOperand {
    public String value;

    public Text(String value) {
        this.value = value;
    }

    public Text(String format, IOperand arg) {
        this.value = arg instanceof Array ? String.format(format, (Object[])arg.value()) : String.format(format, arg.value());
    }

    @Override
    public boolean asBool() {
        return !this.value.isEmpty();
    }

    @Override
    public int asIndex() {
        return 0;
    }

    @Override
    public IOperand addR(IOperand x) {
        return new Text(this.value + x.toString());
    }

    @Override
    public IOperand addL(IOperand x) {
        return new Text(x.toString() + this.value);
    }

    @Override
    public IOperand len() {
        return new Number(this.value.length());
    }

    @Override
    public IOperand get(IOperand idx) {
        int l = this.value.length();
        int i0 = idx.asIndex();
        int i1 = l;
        if (idx instanceof Vector) {
            Vector v = (Vector)idx;
            if (v.value.length >= 2) {
                i1 = (int)v.value[1];
            }
        }
        return new Text(this.value.substring(i0 < 0 ? 0 : i0, i1 > l ? l : i1));
    }

    @Override
    public void put(IOperand idx, IOperand val) {
        int i0;
        int l = this.value.length();
        int i1 = i0 = idx.asIndex();
        if (idx instanceof Vector) {
            Vector v = (Vector)idx;
            if (v.value.length >= 2) {
                i1 = (int)v.value[1];
            }
        }
        if (i0 < 0) {
            i0 = 0;
        }
        if (i1 > l) {
            i1 = l;
        }
        this.value = this.value.substring(0, i0).concat(val.toString()).concat(this.value.substring(i1));
    }

    @Override
    public IOperand grR(IOperand x) {
        if (x instanceof Text) {
            String s = ((Text)x).value;
            return this.value.length() > s.length() ? new Number(this.value.indexOf(s) + 1) : Number.FALSE;
        }
        return x.grL(x);
    }

    @Override
    public IOperand nlsR(IOperand x) {
        if (x instanceof Text) {
            return new Number(this.value.indexOf(((Text)x).value) + 1);
        }
        return x.nlsL(x);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Object value() {
        return this.value;
    }
}

