/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.render.model;

import cd4017be.lib.block.MultipartBlock;
import cd4017be.lib.render.IHardCodedModel;
import cd4017be.lib.render.model.BlockMimicModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;

public class MultipartModel
implements IModel,
IHardCodedModel {
    public final IModelProvider[] modelProvider;
    public final Map<IBlockState, ? extends ResourceLocation> baseMap;
    public final Block block;
    public final boolean multiLayer;
    public ItemOverrideList itemHandler = ItemOverrideList.field_188022_a;

    public MultipartModel(MultipartBlock block) {
        this(block, MultipartModel.stateMap(block, block.getBaseState()), block.renderMultilayer(), new IModelProvider[block.numModules]);
        for (int i = 0; i < block.numModules; ++i) {
            Class type = block.moduleType(i);
            if (type == Boolean.class) {
                this.modelProvider[i] = new ProviderList(new ResourceLocation[]{new ModelResourceLocation(block.getRegistryName(), block.moduleVariant(i))});
                continue;
            }
            if (type != IBlockState.class) continue;
            this.modelProvider[i] = BlockMimicModel.provider;
        }
    }

    public static Map<IBlockState, ResourceLocation> stateMap(Block block, IProperty<?> prop) {
        ResourceLocation loc = block.getRegistryName();
        HashMap<IBlockState, ResourceLocation> map = new HashMap<IBlockState, ResourceLocation>();
        if (prop == null) {
            ModelResourceLocation mloc = new ModelResourceLocation(loc, "base");
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                map.put(state, (ResourceLocation)mloc);
            }
        } else {
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                map.put(state, (ResourceLocation)new ModelResourceLocation(loc, "base" + state.func_177229_b(prop)));
            }
        }
        return map;
    }

    public MultipartModel(Block block, Map<IBlockState, ? extends ResourceLocation> baseMap, boolean multiLayer, IModelProvider ... providers) {
        this.block = block;
        this.baseMap = baseMap;
        this.multiLayer = multiLayer;
        this.modelProvider = providers;
    }

    public MultipartModel setProvider(int i, IModelProvider p) {
        this.modelProvider[i] = p;
        return this;
    }

    public MultipartModel setPipeVariants(int n) {
        MultipartBlock block = (MultipartBlock)this.block;
        for (int i = 0; i < block.moduleCount(); ++i) {
            Class type = block.moduleType(i);
            if (type != Byte.class || this.modelProvider[i] != null) continue;
            ResourceLocation[] locs = new ResourceLocation[n];
            for (int j = 0; j < n; ++j) {
                locs[j] = new ModelResourceLocation(block.getRegistryName(), block.moduleVariant(i) + j);
            }
            this.modelProvider[i] = new ProviderList(locs);
        }
        return this;
    }

    public Collection<ResourceLocation> getDependencies() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        set.addAll(this.baseMap.values());
        for (IModelProvider provider : this.modelProvider) {
            Collection<ResourceLocation> c = provider.getDependencies();
            if (c == null) continue;
            set.addAll(c);
        }
        return set;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        for (IModelProvider provider : this.modelProvider) {
            provider.bake(format, textureGetter);
        }
        HashMap<IBlockState, IBakedModel> baked = new HashMap<IBlockState, IBakedModel>();
        for (Map.Entry<IBlockState, ? extends ResourceLocation> e : this.baseMap.entrySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)e.getValue(), (String)"missing");
            baked.put(e.getKey(), model.bake(model.getDefaultState(), format, textureGetter));
        }
        return new BakedMultipart(baked);
    }

    public IModelState getDefaultState() {
        return ModelRotation.X0_Y0;
    }

    @Override
    public void onReload() {
    }

    public static class ProviderList
    implements IModelProvider {
        private final ResourceLocation[] models;
        private final IBakedModel[] baked;

        public ProviderList(ResourceLocation ... models) {
            this.models = models;
            this.baked = new IBakedModel[models.length];
        }

        @Override
        public void getQuads(List<BakedQuad> quads, Object val, BlockRenderLayer layer, IBlockState state, EnumFacing side, long rand) {
            int i;
            if (layer != null && layer != BlockRenderLayer.CUTOUT) {
                return;
            }
            if (val instanceof Number) {
                i = ((Number)val).intValue();
            } else if (val instanceof Enum) {
                i = ((Enum)val).ordinal();
            } else {
                if (val instanceof Boolean && !((Boolean)val).booleanValue()) {
                    return;
                }
                i = 0;
            }
            if (i < 0 || i >= this.baked.length) {
                return;
            }
            quads.addAll(this.baked[i].func_188616_a(state, side, rand));
        }

        @Override
        public Collection<ResourceLocation> getDependencies() {
            return Arrays.asList(this.models);
        }

        @Override
        public void bake(VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
            for (int i = 0; i < this.models.length; ++i) {
                IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.models[i], (String)"missing");
                this.baked[i] = model.bake(model.getDefaultState(), format, textureGetter);
            }
        }
    }

    public static interface IModelProvider {
        @Deprecated
        default public IBakedModel getModelFor(Object val) {
            return null;
        }

        @Deprecated
        default public IBakedModel getModelFor(Object val, @Nonnull BlockRenderLayer layer) {
            return layer == null || layer == BlockRenderLayer.CUTOUT ? this.getModelFor(val) : null;
        }

        default public void getQuads(List<BakedQuad> quads, Object val, @Nonnull BlockRenderLayer layer, IBlockState state, EnumFacing side, long rand) {
            IBakedModel model = this.getModelFor(val, layer);
            if (model != null) {
                quads.addAll(model.func_188616_a(state, side, rand));
            }
        }

        public Collection<ResourceLocation> getDependencies();

        public void bake(VertexFormat var1, Function<ResourceLocation, TextureAtlasSprite> var2);
    }

    public class BakedMultipart
    implements IBakedModel {
        public final Map<IBlockState, IBakedModel> base;
        public final IBakedModel main;

        private BakedMultipart(Map<IBlockState, IBakedModel> base) {
            this.base = base;
            this.main = base.get(MultipartModel.this.block.func_176223_P());
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> list;
            block6: {
                IBakedModel model;
                BlockRenderLayer layer;
                block5: {
                    list = new ArrayList<BakedQuad>();
                    Object object = layer = MultipartModel.this.multiLayer ? MinecraftForgeClient.getRenderLayer() : null;
                    if (!(state instanceof IExtendedBlockState)) break block5;
                    MultipartBlock.IModularTile tile = (MultipartBlock.IModularTile)((IExtendedBlockState)state).getValue(MultipartBlock.moduleRef);
                    if (tile == null || side == null && tile.isOpaque()) break block6;
                    for (int i = 0; i < MultipartModel.this.modelProvider.length; ++i) {
                        MultipartModel.this.modelProvider[i].getQuads(list, tile.getModuleState(i), layer, state, side, rand);
                    }
                    state = ((IExtendedBlockState)state).getClean();
                }
                if ((layer == null || layer == BlockRenderLayer.CUTOUT) && (model = this.base.get(state)) != null) {
                    list.addAll(model.func_188616_a(state, side, rand));
                }
            }
            return list;
        }

        public boolean func_177555_b() {
            return this.main.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.main.func_177556_c();
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.main.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return MultipartModel.this.itemHandler;
        }
    }
}

