/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.jvm_utils;

import cd4017be.lib.jvm_utils.ConstantPool;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ClassAssembler
extends ClassLoader {
    public static final ClassAssembler INSTANCE = new ClassAssembler();
    public static final byte[] DEFAULT_CONSTR;
    public static final byte _nop = 0;
    public static final byte _aconst_null = 1;
    public static final byte _iconst_m1 = 2;
    public static final byte _iconst_0 = 3;
    public static final byte _iconst_1 = 4;
    public static final byte _iconst_2 = 5;
    public static final byte _iconst_3 = 6;
    public static final byte _iconst_4 = 7;
    public static final byte _iconst_5 = 8;
    public static final byte _lconst_0 = 9;
    public static final byte _lconst_1 = 10;
    public static final byte _fconst_0 = 11;
    public static final byte _fconst_1 = 12;
    public static final byte _fconst_2 = 13;
    public static final byte _dconst_0 = 14;
    public static final byte _dconst_1 = 15;
    public static final byte _bipush = 16;
    public static final byte _sipush = 17;
    public static final byte _ldc = 18;
    public static final byte _ldc_w = 19;
    public static final byte _ldc2_w = 20;
    public static final byte _iload = 21;
    public static final byte _lload = 22;
    public static final byte _fload = 23;
    public static final byte _dload = 24;
    public static final byte _aload = 25;
    public static final byte _iload_0 = 26;
    public static final byte _iload_1 = 27;
    public static final byte _iload_2 = 28;
    public static final byte _iload_3 = 29;
    public static final byte _lload_0 = 30;
    public static final byte _lload_1 = 31;
    public static final byte _lload_2 = 32;
    public static final byte _lload_3 = 33;
    public static final byte _fload_0 = 34;
    public static final byte _fload_1 = 35;
    public static final byte _fload_2 = 36;
    public static final byte _fload_3 = 37;
    public static final byte _dload_0 = 38;
    public static final byte _dload_1 = 39;
    public static final byte _dload_2 = 40;
    public static final byte _dload_3 = 41;
    public static final byte _aload_0 = 42;
    public static final byte _aload_1 = 43;
    public static final byte _aload_2 = 44;
    public static final byte _aload_3 = 45;
    public static final byte _iaload = 46;
    public static final byte _laload = 47;
    public static final byte _faload = 48;
    public static final byte _daload = 49;
    public static final byte _aaload = 50;
    public static final byte _baload = 51;
    public static final byte _caload = 52;
    public static final byte _saload = 53;
    public static final byte _istore = 54;
    public static final byte _lstore = 55;
    public static final byte _fstore = 56;
    public static final byte _dstore = 57;
    public static final byte _astore = 58;
    public static final byte _istore_0 = 59;
    public static final byte _istore_1 = 60;
    public static final byte _istore_2 = 61;
    public static final byte _istore_3 = 62;
    public static final byte _lstore_0 = 63;
    public static final byte _lstore_1 = 64;
    public static final byte _lstore_2 = 65;
    public static final byte _lstore_3 = 66;
    public static final byte _fstore_0 = 67;
    public static final byte _fstore_1 = 68;
    public static final byte _fstore_2 = 69;
    public static final byte _fstore_3 = 70;
    public static final byte _dstore_0 = 71;
    public static final byte _dstore_1 = 72;
    public static final byte _dstore_2 = 73;
    public static final byte _dstore_3 = 74;
    public static final byte _astore_0 = 75;
    public static final byte _astore_1 = 76;
    public static final byte _astore_2 = 77;
    public static final byte _astore_3 = 78;
    public static final byte _iastore = 79;
    public static final byte _lastore = 80;
    public static final byte _fastore = 81;
    public static final byte _dastore = 82;
    public static final byte _aastore = 83;
    public static final byte _bastore = 84;
    public static final byte _castore = 85;
    public static final byte _sastore = 86;
    public static final byte _pop = 87;
    public static final byte pop2 = 88;
    public static final byte _dup = 89;
    public static final byte _dup_x1 = 90;
    public static final byte _dup_x2 = 91;
    public static final byte _dup2 = 92;
    public static final byte _dup2_x1 = 93;
    public static final byte dup2_x2 = 94;
    public static final byte _swap = 95;
    public static final byte _iadd = 96;
    public static final byte _isub = 100;
    public static final byte _imul = 104;
    public static final byte _idiv = 108;
    public static final byte _irem = 112;
    public static final byte _ineg = 116;
    public static final byte _ladd = 97;
    public static final byte _lsub = 101;
    public static final byte _lmul = 105;
    public static final byte _ldiv = 109;
    public static final byte _lrem = 113;
    public static final byte _lneg = 117;
    public static final byte _fadd = 98;
    public static final byte _fsub = 102;
    public static final byte _fmul = 106;
    public static final byte _fdiv = 110;
    public static final byte _frem = 114;
    public static final byte _fneg = 118;
    public static final byte _dadd = 99;
    public static final byte _dsub = 103;
    public static final byte _dmul = 107;
    public static final byte _ddiv = 111;
    public static final byte _drem = 115;
    public static final byte _dneg = 119;
    public static final byte _ishl = 120;
    public static final byte _ishr = 122;
    public static final byte _iushr = 124;
    public static final byte _iand = 126;
    public static final byte _ior = -128;
    public static final byte _ixor = -126;
    public static final byte _iinc = -124;
    public static final byte _lshl = 121;
    public static final byte _lshr = 123;
    public static final byte _lushr = 125;
    public static final byte _land = 127;
    public static final byte _lor = -127;
    public static final byte _lxor = -125;
    public static final byte _i2l = -123;
    public static final byte _i2f = -122;
    public static final byte _i2d = -121;
    public static final byte _i2b = -111;
    public static final byte _i2c = -110;
    public static final byte _i2s = -109;
    public static final byte _l2i = -120;
    public static final byte _l2f = -119;
    public static final byte _l2d = -118;
    public static final byte _f2i = -117;
    public static final byte _f2l = -116;
    public static final byte _f2d = -115;
    public static final byte _d2i = -114;
    public static final byte _d2l = -113;
    public static final byte _d2f = -112;
    public static final byte _lcmp = -108;
    public static final byte _fcmpl = -107;
    public static final byte _fcmpg = -106;
    public static final byte _dcmpl = -105;
    public static final byte _dcmpg = -104;
    public static final byte _ifeq = -103;
    public static final byte _ifne = -102;
    public static final byte _iflt = -101;
    public static final byte _ifle = -100;
    public static final byte _ifgt = -99;
    public static final byte _ifge = -98;
    public static final byte _if_icmpeq = -97;
    public static final byte _if_icmpne = -96;
    public static final byte _if_icmplt = -95;
    public static final byte _if_icmpge = -94;
    public static final byte _if_icmpgt = -93;
    public static final byte _if_icmple = -92;
    public static final byte _if_acmpeq = -91;
    public static final byte _if_acmpne = -90;
    public static final byte _goto = -89;
    public static final byte _jsr = -88;
    public static final byte _ret = -87;
    public static final byte _tableswitch = -86;
    public static final byte _lookupswitch = -85;
    public static final byte _ireturn = -84;
    public static final byte _lreturn = -83;
    public static final byte _freturn = -82;
    public static final byte _dreturn = -81;
    public static final byte _areturn = -80;
    public static final byte _return = -79;
    public static final byte _getstatic = -78;
    public static final byte _putstatic = -77;
    public static final byte _getfield = -76;
    public static final byte _putfield = -75;
    public static final byte _invokevirtual = -74;
    public static final byte _invokespecial = -73;
    public static final byte _invokestatic = -72;
    public static final byte _invokeinterface = -71;
    public static final byte _invokedynamic = -70;
    public static final byte _new = -69;
    public static final byte _newarray = -68;
    public static final byte _anewarray = -67;
    public static final byte _arraylength = -66;
    public static final byte _athrow = -65;
    public static final byte _checkcast = -64;
    public static final byte _instanceof = -63;
    public static final byte _monitorenter = -62;
    public static final byte _monitorexit = -61;
    public static final byte _multianewarray = -59;
    public static final byte _ifnull = -58;
    public static final byte _ifnonnull = -57;
    private HashMap<String, Function<String, byte[]>> scheduled = new HashMap();

    public static byte[] _iconst_(short val) {
        if (val >= -1 && val <= 5) {
            return new byte[]{(byte)(3 + val)};
        }
        if (val >= -256 && val < 256) {
            return new byte[]{16, (byte)val};
        }
        return new byte[]{17, (byte)(val >> 8), (byte)val};
    }

    private ClassAssembler() {
        super(ClassAssembler.class.getClassLoader());
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Function<String, byte[]> gen = this.scheduled.remove(name);
        if (gen == null) {
            throw new ClassNotFoundException(name);
        }
        byte[] data = gen.apply(name);
        return this.defineClass(name, data, 0, data.length);
    }

    public boolean register(String name, Function<String, byte[]> generator) {
        if (this.findLoadedClass(name) != null) {
            return true;
        }
        return this.scheduled.put(name, generator) != null;
    }

    public static byte[] genClass(List<Class<?>> interfaces, ConstantPool cpt, List<byte[]> fields, List<byte[]> methods, Map<Short, byte[]> attributes) {
        short[] iidx;
        if (interfaces != null) {
            iidx = new short[interfaces.size()];
            int i = 0;
            for (Class<?> object : interfaces) {
                iidx[i++] = cpt.putClass(object.getName());
            }
        } else {
            iidx = new short[]{};
        }
        if (fields == null) {
            fields = Collections.emptyList();
        }
        int n = 2 * iidx.length + 22 + cpt.getSize();
        for (byte[] byArray : fields) {
            n += byArray.length;
        }
        for (byte[] byArray : methods) {
            n += byArray.length;
        }
        ByteBuffer b = ClassAssembler.writeAttributes(n, attributes);
        b.putInt(-889275714);
        b.putShort((short)0).putShort((short)52);
        b.putShort((short)cpt.getCount());
        cpt.write(b);
        b.putShort((short)4113).putShort((short)2).putShort((short)4);
        b.putShort((short)iidx.length);
        for (short idx : iidx) {
            b.putShort(idx);
        }
        b.putShort((short)fields.size());
        for (byte[] arr : fields) {
            b.put(arr);
        }
        b.putShort((short)methods.size());
        for (byte[] arr : methods) {
            b.put(arr);
        }
        return b.array();
    }

    public static byte[] genField(int acc, String descr, Map<Short, byte[]> attributes, ConstantPool cpt) {
        int i = descr.indexOf(32);
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        ByteBuffer b = ClassAssembler.writeAttributes(6, attributes);
        b.putShort((short)(acc & 0xDF | 0x1000));
        b.putShort(cpt.putUtf8(descr.substring(i + 1)));
        b.putShort(cpt.putUtf8(descr.substring(0, i).replace('.', '/')));
        return b.array();
    }

    public static byte[] genMethod(int acc, short name, short descr, Map<Short, byte[]> attributes) {
        ByteBuffer b = ClassAssembler.writeAttributes(6, attributes);
        b.putShort((short)(acc & 0xBF | 0x1000));
        b.putShort(name).putShort(descr);
        return b.array();
    }

    public static Map<Short, byte[]> genCode(int locals, int stack, byte[] code, long[] exceptions, List<byte[]> stackMap, ConstantPool cpt) {
        int lSM;
        int nEx;
        int n = nEx = exceptions != null ? exceptions.length : 0;
        if (stackMap != null && !stackMap.isEmpty()) {
            lSM = 2;
            for (byte[] e : stackMap) {
                lSM += e.length;
            }
        } else {
            lSM = 0;
        }
        int l = code.length;
        ByteBuffer b = ByteBuffer.allocate(l + 12 + nEx * 8 + (lSM > 0 ? lSM + 6 : 0));
        b.putShort((short)stack).putShort((short)locals);
        b.putInt(l);
        b.put(code);
        if (exceptions != null) {
            b.putShort((short)exceptions.length);
            for (long eh : exceptions) {
                b.putLong(eh);
            }
        } else {
            b.putShort((short)0);
        }
        if (lSM > 0) {
            b.putShort((short)1);
            b.putShort(cpt.putUtf8("StackMapTable"));
            b.putInt(lSM);
            b.putShort((short)stackMap.size());
            Object object = stackMap.iterator();
            while (object.hasNext()) {
                byte[] e = (byte[])object.next();
                b.put(e);
            }
        } else {
            b.putShort((short)0);
        }
        return Collections.singletonMap(cpt.putUtf8("Code"), b.array());
    }

    public static long catchEx(int start, int end, int handler, Class<? extends Throwable> type, ConstantPool cpt) {
        return (long)(start & 0xFFFF) << 48 | (long)(end & 0xFFFF) << 32 | (long)(handler & 0xFFFF) << 16 | (long)(cpt.putClass(type.getName()) & 0xFFFF);
    }

    private static ByteBuffer writeAttributes(int ofs, Map<Short, byte[]> attributes) {
        if (attributes == null) {
            return ByteBuffer.allocate(ofs + 2);
        }
        int l = attributes.size();
        int j = 0;
        int n = 0;
        short[] keys = new short[l];
        byte[][] values = new byte[l][];
        for (Map.Entry<Short, byte[]> e : attributes.entrySet()) {
            keys[j] = e.getKey();
            int n2 = j++;
            byte[] byArray = e.getValue();
            values[n2] = byArray;
            n += byArray.length;
        }
        ByteBuffer b = ByteBuffer.allocate(6 * l + n + ofs + 2);
        b.position(ofs);
        b.putShort((short)l);
        for (j = 0; j < l; ++j) {
            b.putShort(keys[j]);
            byte[] arr = values[j];
            b.putInt(arr.length).put(arr);
        }
        b.position(0);
        return b;
    }

    static {
        ConstantPool cpt = new ConstantPool("cd4017be.generated.C_", Object.class);
        DEFAULT_CONSTR = ClassAssembler.genMethod(1, cpt.putUtf8("<init>"), cpt.putUtf8("()V"), ClassAssembler.genCode(1, 1, new byte[]{42, -73, 0, 9, -79}, null, null, cpt));
    }
}

