/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.lib.Gui.comp;

import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Tooltip;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Slider
extends Tooltip {
    private final DoubleSupplier get;
    private final DoubleConsumer set;
    private final Runnable update;
    public final int l;
    public final int tx;
    public final int ty;
    public final int tw;
    public final int th;
    public final boolean hor;
    public final double min;
    public final double max;
    public double scrollStep;

    public Slider(GuiCompGroup parent, int w, int h, int l, int x, int y, int tx, int ty, boolean hor, @Nonnull DoubleSupplier get, @Nonnull DoubleConsumer set, @Nullable Runnable update, double min, double max) {
        super(parent, hor ? l : w, hor ? h : l, x, y, null, () -> new Object[]{get.getAsDouble(), min, max});
        this.hor = hor;
        this.l = l - (hor ? w : h);
        this.tx = tx;
        this.ty = ty;
        this.tw = w;
        this.th = h;
        this.get = get;
        this.set = set;
        this.update = update;
        this.min = min;
        this.max = max;
        this.scrollStep = (max - min) / 8.0;
    }

    public Slider(GuiFrame parent, int w, int h, int l, int x, int y, int tx, int ty, boolean hor, @Nonnull DoubleSupplier get, @Nonnull DoubleConsumer set, @Nullable Runnable update) {
        this(parent, w, h, l, x, y, tx, ty, hor, get, set, update, 0.0, 1.0);
    }

    public Slider scroll(float step) {
        this.scrollStep = step;
        return this;
    }

    @Override
    public void drawBackground(int mx, int my, float t) {
        int n = (int)Math.round((this.get.getAsDouble() - this.min) / (this.max - this.min) * (double)this.l);
        if (this.hor) {
            this.parent.drawRect(this.x + n, this.y, this.tx, this.ty, this.tw, this.th);
        } else {
            this.parent.drawRect(this.x, this.y + n, this.tx, this.ty, this.tw, this.th);
        }
    }

    @Override
    public boolean mouseIn(int mx, int my, int b, byte d) {
        if (d == 3) {
            double f = this.get.getAsDouble() + (double)b * this.scrollStep;
            double min = Math.min(this.min, this.max);
            double max = Math.max(this.min, this.max);
            if (f < min) {
                f = min;
            } else if (f > max) {
                f = max;
            }
            this.set.accept(f);
            if (this.update != null) {
                this.update.run();
            }
            return true;
        }
        double f = 0.5 * (this.hor ? (double)(2 * (mx - this.x) - this.tw) / (double)this.l : (double)(2 * (my - this.y) - this.th) / (double)this.l);
        if (f < 0.0) {
            f = 0.0;
        } else if (f > 1.0) {
            f = 1.0;
        }
        this.set.accept(this.min + (this.max - this.min) * f);
        if (d == 2) {
            this.parent.setFocus(null);
        }
        return true;
    }

    @Override
    public void unfocus() {
        if (this.update != null) {
            this.update.run();
        }
    }

    @Override
    public boolean focus() {
        return true;
    }
}

